/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.types;

import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.ExtendedCellBuilder;
import org.apache.hadoop.hbase.ExtendedCellBuilderFactory;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.CellProtos;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.types.PBCell;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.PositionedByteRange;
import org.apache.hadoop.hbase.util.SimplePositionedByteRange;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class, MiscTests.class})
public class TestPBCell {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestPBCell.class);
    private static final PBCell CODEC = new PBCell();

    @Test
    public void testRoundTrip() {
        KeyValue cell = new KeyValue(Bytes.toBytes((String)"row"), Bytes.toBytes((String)"fam"), Bytes.toBytes((String)"qual"), Bytes.toBytes((String)"val"));
        CellProtos.Cell c = ProtobufUtil.toCell((Cell)cell);
        SimplePositionedByteRange pbr = new SimplePositionedByteRange(c.getSerializedSize());
        pbr.setPosition(0);
        int encodedLength = CODEC.encode((PositionedByteRange)pbr, c);
        pbr.setPosition(0);
        CellProtos.Cell decoded = CODEC.decode((PositionedByteRange)pbr);
        Assert.assertEquals((long)encodedLength, (long)pbr.getPosition());
        Assert.assertTrue((boolean)CellUtil.equals((Cell)cell, (Cell)ProtobufUtil.toCell((ExtendedCellBuilder)ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY), (CellProtos.Cell)decoded)));
    }
}

