/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.example;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.ipc.NettyRpcClientConfigHelper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.common.base.Throwables;
import org.apache.hbase.thirdparty.io.netty.bootstrap.ServerBootstrap;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.channel.Channel;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandler;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandlerContext;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelInitializer;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelOption;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoopGroup;
import org.apache.hbase.thirdparty.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.hbase.thirdparty.io.netty.channel.group.ChannelGroup;
import org.apache.hbase.thirdparty.io.netty.channel.group.DefaultChannelGroup;
import org.apache.hbase.thirdparty.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.hbase.thirdparty.io.netty.channel.socket.nio.NioServerSocketChannel;
import org.apache.hbase.thirdparty.io.netty.channel.socket.nio.NioSocketChannel;
import org.apache.hbase.thirdparty.io.netty.handler.codec.http.DefaultFullHttpResponse;
import org.apache.hbase.thirdparty.io.netty.handler.codec.http.FullHttpRequest;
import org.apache.hbase.thirdparty.io.netty.handler.codec.http.HttpHeaderNames;
import org.apache.hbase.thirdparty.io.netty.handler.codec.http.HttpObjectAggregator;
import org.apache.hbase.thirdparty.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.hbase.thirdparty.io.netty.handler.codec.http.HttpServerCodec;
import org.apache.hbase.thirdparty.io.netty.handler.codec.http.HttpVersion;
import org.apache.hbase.thirdparty.io.netty.handler.codec.http.QueryStringDecoder;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.EventExecutor;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.GlobalEventExecutor;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class HttpProxyExample {
    private final EventLoopGroup bossGroup = new NioEventLoopGroup(1);
    private final EventLoopGroup workerGroup = new NioEventLoopGroup();
    private final Configuration conf;
    private final int port;
    private AsyncConnection conn;
    private Channel serverChannel;
    private ChannelGroup channelGroup;

    public HttpProxyExample(Configuration conf, int port) {
        this.conf = conf;
        this.port = port;
    }

    public void start() throws InterruptedException, ExecutionException {
        NettyRpcClientConfigHelper.setEventLoopConfig((Configuration)this.conf, (EventLoopGroup)this.workerGroup, NioSocketChannel.class);
        this.conn = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)this.conf).get();
        this.channelGroup = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
        this.serverChannel = ((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childOption(ChannelOption.TCP_NODELAY, (Object)true).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ch.pipeline().addFirst(new ChannelHandler[]{new HttpServerCodec(), new HttpObjectAggregator(0x400000), new RequestHandler(HttpProxyExample.this.conn, HttpProxyExample.this.channelGroup)});
            }
        }).bind(this.port).syncUninterruptibly().channel();
    }

    public void join() {
        this.serverChannel.closeFuture().awaitUninterruptibly();
    }

    public int port() {
        if (this.serverChannel == null) {
            return this.port;
        }
        return ((InetSocketAddress)this.serverChannel.localAddress()).getPort();
    }

    public void stop() throws IOException {
        this.serverChannel.close().syncUninterruptibly();
        this.serverChannel = null;
        this.channelGroup.close().syncUninterruptibly();
        this.channelGroup = null;
        this.conn.close();
        this.conn = null;
    }

    public static void main(String[] args) throws InterruptedException, ExecutionException {
        int port = Integer.parseInt(args[0]);
        HttpProxyExample proxy = new HttpProxyExample(HBaseConfiguration.create(), port);
        proxy.start();
        proxy.join();
    }

    private static final class RequestHandler
    extends SimpleChannelInboundHandler<FullHttpRequest> {
        private final AsyncConnection conn;
        private final ChannelGroup channelGroup;

        public RequestHandler(AsyncConnection conn, ChannelGroup channelGroup) {
            this.conn = conn;
            this.channelGroup = channelGroup;
        }

        public void channelActive(ChannelHandlerContext ctx) {
            this.channelGroup.add((Object)ctx.channel());
            ctx.fireChannelActive();
        }

        public void channelInactive(ChannelHandlerContext ctx) {
            this.channelGroup.remove((Object)ctx.channel());
            ctx.fireChannelInactive();
        }

        private void write(ChannelHandlerContext ctx, HttpResponseStatus status, Optional<String> content) {
            DefaultFullHttpResponse resp;
            if (content.isPresent()) {
                ByteBuf buf = ctx.alloc().buffer().writeBytes(Bytes.toBytes((String)content.get()));
                resp = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, buf);
                resp.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)buf.readableBytes());
            } else {
                resp = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status);
            }
            resp.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text-plain; charset=UTF-8");
            ctx.writeAndFlush((Object)resp);
        }

        private Params parse(FullHttpRequest req) {
            String[] components = new QueryStringDecoder(req.uri()).path().split("/");
            Preconditions.checkArgument((components.length == 4 ? 1 : 0) != 0, (String)"Unrecognized uri: %s", (Object)req.uri());
            String[] cfAndCq = components[3].split(":");
            Preconditions.checkArgument((cfAndCq.length == 2 ? 1 : 0) != 0, (String)"Unrecognized uri: %s", (Object)req.uri());
            return new Params(components[1], components[2], cfAndCq[0], cfAndCq[1]);
        }

        private void get(ChannelHandlerContext ctx, FullHttpRequest req) {
            Params params = this.parse(req);
            FutureUtils.addListener((CompletableFuture)this.conn.getTable(TableName.valueOf((String)params.table)).get(new Get(Bytes.toBytes((String)params.row)).addColumn(Bytes.toBytes((String)params.family), Bytes.toBytes((String)params.qualifier))), (r, e) -> {
                if (e != null) {
                    this.exceptionCaught(ctx, (Throwable)e);
                } else {
                    byte[] value = r.getValue(Bytes.toBytes((String)params.family), Bytes.toBytes((String)params.qualifier));
                    if (value != null) {
                        this.write(ctx, HttpResponseStatus.OK, Optional.of(Bytes.toStringBinary((byte[])value)));
                    } else {
                        this.write(ctx, HttpResponseStatus.NOT_FOUND, Optional.empty());
                    }
                }
            });
        }

        private void put(ChannelHandlerContext ctx, FullHttpRequest req) {
            Params params = this.parse(req);
            byte[] value = new byte[req.content().readableBytes()];
            req.content().readBytes(value);
            FutureUtils.addListener((CompletableFuture)this.conn.getTable(TableName.valueOf((String)params.table)).put(new Put(Bytes.toBytes((String)params.row)).addColumn(Bytes.toBytes((String)params.family), Bytes.toBytes((String)params.qualifier), value)), (r, e) -> {
                if (e != null) {
                    this.exceptionCaught(ctx, (Throwable)e);
                } else {
                    this.write(ctx, HttpResponseStatus.OK, Optional.empty());
                }
            });
        }

        protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest req) {
            switch (req.method().name()) {
                case "GET": {
                    this.get(ctx, req);
                    break;
                }
                case "PUT": {
                    this.put(ctx, req);
                    break;
                }
                default: {
                    this.write(ctx, HttpResponseStatus.METHOD_NOT_ALLOWED, Optional.empty());
                }
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            if (cause instanceof IllegalArgumentException) {
                this.write(ctx, HttpResponseStatus.BAD_REQUEST, Optional.of(cause.getMessage()));
            } else {
                this.write(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR, Optional.of(Throwables.getStackTraceAsString((Throwable)cause)));
            }
        }
    }

    private static final class Params {
        public final String table;
        public final String row;
        public final String family;
        public final String qualifier;

        public Params(String table, String row, String family, String qualifier) {
            this.table = table;
            this.row = row;
            this.family = family;
            this.qualifier = qualifier;
        }
    }
}

