/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor.example;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.example.ScanModifyingObserver;
import org.apache.hadoop.hbase.testclassification.CoprocessorTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={CoprocessorTests.class, MediumTests.class})
public class TestScanModifyingObserver {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestScanModifyingObserver.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final TableName NAME = TableName.valueOf((String)"TestScanModifications");
    private static final byte[] FAMILY = Bytes.toBytes((String)"f");
    private static final ColumnFamilyDescriptor CFD = ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILY).build();
    private static final int NUM_ROWS = 5;
    private static final byte[] EXPLICIT_QUAL = Bytes.toBytes((String)"our_qualifier");
    private static final byte[] IMPLICIT_QUAL = Bytes.toBytes((String)"their_qualifier");
    private static final byte[] EXPLICIT_VAL = Bytes.toBytes((String)"provided");
    private static final byte[] IMPLICIT_VAL = Bytes.toBytes((String)"implicit");

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniCluster(1);
        UTIL.getAdmin().createTable(TableDescriptorBuilder.newBuilder((TableName)NAME).setCoprocessor(ScanModifyingObserver.class.getName()).setValue("hbase.examples.coprocessor.scanmodifying.family", Bytes.toString((byte[])FAMILY)).setValue("hbase.examples.coprocessor.scanmodifying.qualifier", Bytes.toString((byte[])IMPLICIT_QUAL)).setColumnFamily(CFD).build());
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    private void writeData(Table t) throws IOException {
        ArrayList<Put> puts = new ArrayList<Put>(5);
        for (int i = 0; i < 5; ++i) {
            Put p = new Put(Bytes.toBytes((int)(i + 1)));
            p.addColumn(FAMILY, EXPLICIT_QUAL, EXPLICIT_VAL);
            p.addColumn(FAMILY, IMPLICIT_QUAL, IMPLICIT_VAL);
            puts.add(p);
        }
        t.put(puts);
    }

    @Test
    public void test() throws IOException {
        try (Table t = UTIL.getConnection().getTable(NAME);){
            this.writeData(t);
            Scan s = new Scan();
            s.addColumn(FAMILY, EXPLICIT_QUAL);
            try (ResultScanner scanner = t.getScanner(s);){
                for (int i = 0; i < 5; ++i) {
                    Result result = scanner.next();
                    Assert.assertNotNull((String)("The " + (i + 1) + "th result was unexpectedly null"), (Object)result);
                    Assert.assertEquals((long)2L, (long)result.getFamilyMap(FAMILY).size());
                    Assert.assertArrayEquals((byte[])Bytes.toBytes((int)(i + 1)), (byte[])result.getRow());
                    Assert.assertArrayEquals((byte[])EXPLICIT_VAL, (byte[])result.getValue(FAMILY, EXPLICIT_QUAL));
                    Assert.assertArrayEquals((byte[])IMPLICIT_VAL, (byte[])result.getValue(FAMILY, IMPLICIT_QUAL));
                }
                Assert.assertNull((Object)scanner.next());
            }
        }
    }
}

