/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor.example;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.example.ValueRewritingObserver;
import org.apache.hadoop.hbase.testclassification.CoprocessorTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={CoprocessorTests.class, MediumTests.class})
public class TestValueReplacingCompaction {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestValueReplacingCompaction.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final TableName NAME = TableName.valueOf((String)"TestValueReplacement");
    private static final byte[] FAMILY = Bytes.toBytes((String)"f");
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"q");
    private static final ColumnFamilyDescriptor CFD = ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILY).build();
    private static final int NUM_ROWS = 5;
    private static final String value = "foo";
    private static final String replacedValue = "bar";

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniCluster(1);
        UTIL.getAdmin().createTable(TableDescriptorBuilder.newBuilder((TableName)NAME).setCoprocessor(ValueRewritingObserver.class.getName()).setValue("hbase.examples.coprocessor.value.rewrite.orig", value).setValue("hbase.examples.coprocessor.value.rewrite.replaced", replacedValue).setColumnFamily(CFD).build());
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    private void writeData(Table t) throws IOException {
        ArrayList<Put> puts = new ArrayList<Put>(5);
        for (int i = 0; i < 5; ++i) {
            Put p = new Put(Bytes.toBytes((int)(i + 1)));
            p.addColumn(FAMILY, QUALIFIER, Bytes.toBytes((String)value));
            puts.add(p);
        }
        t.put(puts);
    }

    @Test
    public void test() throws IOException, InterruptedException {
        try (Table t = UTIL.getConnection().getTable(NAME);){
            this.writeData(t);
            UTIL.flush(NAME);
            UTIL.compact(NAME, true);
            Scan s = new Scan();
            s.addColumn(FAMILY, QUALIFIER);
            try (ResultScanner scanner = t.getScanner(s);){
                for (int i = 0; i < 5; ++i) {
                    Result result = scanner.next();
                    Assert.assertNotNull((String)("The " + (i + 1) + "th result was unexpectedly null"), (Object)result);
                    Assert.assertEquals((long)1L, (long)result.getFamilyMap(FAMILY).size());
                    Assert.assertArrayEquals((byte[])Bytes.toBytes((int)(i + 1)), (byte[])result.getRow());
                    Assert.assertArrayEquals((byte[])Bytes.toBytes((String)replacedValue), (byte[])result.getValue(FAMILY, QUALIFIER));
                }
                Assert.assertNull((Object)scanner.next());
            }
        }
    }
}

