/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor.example;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.example.ZooKeeperScanPolicyObserver;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.testclassification.CoprocessorTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={CoprocessorTests.class, MediumTests.class})
public class TestZooKeeperScanPolicyObserver {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestZooKeeperScanPolicyObserver.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static TableName NAME = TableName.valueOf((String)"TestCP");
    private static byte[] FAMILY = Bytes.toBytes((String)"cf");
    private static byte[] QUALIFIER = Bytes.toBytes((String)"cq");
    private static Table TABLE;

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniCluster(3);
        UTIL.getAdmin().createTable(TableDescriptorBuilder.newBuilder((TableName)NAME).setCoprocessor(ZooKeeperScanPolicyObserver.class.getName()).setValue("ZooKeeperScanPolicyObserver.zookeeper.ensemble", "localhost:" + UTIL.getZkCluster().getClientPort()).setValue("ZooKeeperScanPolicyObserver.zookeeper.session.timeout", "2000").setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILY).build()).build());
        TABLE = UTIL.getConnection().getTable(NAME);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (TABLE != null) {
            TABLE.close();
        }
        UTIL.shutdownMiniCluster();
    }

    private void setExpireBefore(long time) throws KeeperException, InterruptedException, IOException {
        ZooKeeper zk = UTIL.getZooKeeperWatcher().getRecoverableZooKeeper().getZooKeeper();
        if (zk.exists("/backup/example/lastbackup", false) == null) {
            zk.create("/backup/example/lastbackup", Bytes.toBytes((long)time), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        } else {
            zk.setData("/backup/example/lastbackup", Bytes.toBytes((long)time), -1);
        }
    }

    private void assertValueEquals(int start, int end) throws IOException {
        for (int i = start; i < end; ++i) {
            Assert.assertEquals((long)i, (long)Bytes.toInt((byte[])TABLE.get(new Get(Bytes.toBytes((int)i))).getValue(FAMILY, QUALIFIER)));
        }
    }

    private void assertNotExists(int start, int end) throws IOException {
        for (int i = start; i < end; ++i) {
            Assert.assertFalse((boolean)TABLE.exists(new Get(Bytes.toBytes((int)i))));
        }
    }

    private void put(int start, int end, long ts) throws IOException {
        for (int i = start; i < end; ++i) {
            TABLE.put(new Put(Bytes.toBytes((int)i)).addColumn(FAMILY, QUALIFIER, ts, Bytes.toBytes((int)i)));
        }
    }

    @Test
    public void test() throws IOException, KeeperException, InterruptedException {
        long now = System.currentTimeMillis();
        this.put(0, 100, now - 10000L);
        this.assertValueEquals(0, 100);
        this.setExpireBefore(now - 5000L);
        Thread.sleep(5000L);
        UTIL.getAdmin().flush(NAME);
        this.assertNotExists(0, 100);
        this.put(0, 50, now - 1000L);
        UTIL.getAdmin().flush(NAME);
        this.put(50, 100, now - 100L);
        UTIL.getAdmin().flush(NAME);
        this.assertValueEquals(0, 100);
        this.setExpireBefore(now - 500L);
        Thread.sleep(5000L);
        UTIL.getAdmin().majorCompact(NAME);
        UTIL.waitFor(30000L, () -> ((HRegion)UTIL.getHBaseCluster().getRegions(NAME).iterator().next()).getStore(FAMILY).getStorefilesCount() == 1);
        this.assertNotExists(0, 50);
        this.assertValueEquals(50, 100);
    }
}

