/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor.example;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.stream.IntStream;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;

public class WriteHeavyIncrementObserverTestBase {
    protected static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    protected static TableName NAME = TableName.valueOf((String)"TestCP");
    protected static byte[] FAMILY = Bytes.toBytes((String)"cf");
    protected static byte[] ROW = Bytes.toBytes((String)"row");
    protected static byte[] CQ1 = Bytes.toBytes((String)"cq1");
    protected static byte[] CQ2 = Bytes.toBytes((String)"cq2");
    protected static Table TABLE;
    protected static long UPPER;
    protected static int THREADS;

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.getConfiguration().setLong("hbase.hregion.memstore.flush.size", 65536L);
        UTIL.getConfiguration().setLong("hbase.hregion.memstore.flush.size.limit", 1024L);
        UTIL.getConfiguration().setDouble("hbase.memstore.inmemoryflush.threshold.factor", 0.014);
        UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (TABLE != null) {
            TABLE.close();
        }
        UTIL.shutdownMiniCluster();
    }

    private static void increment(int sleepSteps) throws IOException {
        for (long i = 1L; i <= UPPER; ++i) {
            TABLE.increment(new Increment(ROW).addColumn(FAMILY, CQ1, i).addColumn(FAMILY, CQ2, 2L * i));
            if (sleepSteps <= 0 || i % (long)sleepSteps != 0L) continue;
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected final void assertSum() throws IOException {
        Result result = TABLE.get(new Get(ROW).addColumn(FAMILY, CQ1).addColumn(FAMILY, CQ2));
        Assert.assertEquals((long)((long)THREADS * (1L + UPPER) * UPPER / 2L), (long)Bytes.toLong((byte[])result.getValue(FAMILY, CQ1)));
        Assert.assertEquals((long)((long)THREADS * (1L + UPPER) * UPPER), (long)Bytes.toLong((byte[])result.getValue(FAMILY, CQ2)));
    }

    protected final void doIncrement(int sleepSteps) throws InterruptedException {
        Thread[] threads;
        for (Thread thread : threads = (Thread[])IntStream.range(0, THREADS).mapToObj(i -> new Thread(() -> {
            try {
                WriteHeavyIncrementObserverTestBase.increment(sleepSteps);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }, "increment-" + i)).toArray(Thread[]::new)) {
            thread.start();
        }
        for (Thread thread : threads) {
            thread.join();
        }
    }

    static {
        UPPER = 1000L;
        THREADS = 10;
    }
}

