/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor.example;

import java.io.IOException;
import java.util.Optional;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.metrics.Counter;
import org.apache.hadoop.hbase.metrics.Gauge;
import org.apache.hadoop.hbase.metrics.MetricRegistry;
import org.apache.hadoop.hbase.metrics.Timer;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ExampleMasterObserverWithMetrics
implements MasterCoprocessor,
MasterObserver {
    private static final Logger LOG = LoggerFactory.getLogger(ExampleMasterObserverWithMetrics.class);
    private Timer createTableTimer;
    private long createTableStartTime = Long.MIN_VALUE;
    private Counter disableTableCounter;

    public Optional<MasterObserver> getMasterObserver() {
        return Optional.of(this);
    }

    private long getTotalMemory() {
        return Runtime.getRuntime().totalMemory();
    }

    private long getMaxMemory() {
        return Runtime.getRuntime().maxMemory();
    }

    public void preCreateTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableDescriptor desc, RegionInfo[] regions) throws IOException {
        this.createTableStartTime = System.currentTimeMillis();
    }

    public void postCreateTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableDescriptor desc, RegionInfo[] regions) throws IOException {
        if (this.createTableStartTime > 0L) {
            long time = System.currentTimeMillis() - this.createTableStartTime;
            LOG.info("Create table took: " + time);
            this.createTableTimer.updateMillis(time);
        }
    }

    public void preDisableTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        this.disableTableCounter.increment();
    }

    public void start(CoprocessorEnvironment env) throws IOException {
        if (env instanceof MasterCoprocessorEnvironment) {
            MetricRegistry registry = ((MasterCoprocessorEnvironment)env).getMetricRegistryForMaster();
            if (this.createTableTimer == null) {
                this.createTableTimer = registry.timer("CreateTable");
            }
            if (this.disableTableCounter == null) {
                this.disableTableCounter = registry.counter("DisableTable");
            }
            registry.register("totalMemory", (Gauge)new Gauge<Long>(){

                public Long getValue() {
                    return ExampleMasterObserverWithMetrics.this.getTotalMemory();
                }
            });
            registry.register("maxMemory", this::getMaxMemory);
        }
    }
}

