/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.rest.client.Client;
import org.apache.hadoop.hbase.rest.client.Cluster;
import org.apache.hadoop.hbase.rest.client.RemoteHTable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClientUtils;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RESTDemoClient {
    private static String host = "localhost";
    private static int port = 9090;
    private static boolean secure = false;
    private static Configuration conf = null;

    public static void main(String[] args) throws Exception {
        String principal;
        System.out.println("REST Demo");
        System.out.println("Usage: RESTDemoClient [host=localhost] [port=9090] [secure=false]");
        System.out.println("This demo assumes you have a table called \"example\" with a column family called \"family1\"");
        if (args.length >= 1) {
            host = args[0];
        }
        if (args.length >= 2) {
            port = Integer.parseInt(args[1]);
        }
        if ((principal = (conf = HBaseConfiguration.create()).get("hbase.rest.kerberos.principal")) != null) {
            secure = true;
        }
        if (args.length >= 3) {
            secure = Boolean.parseBoolean(args[2]);
        }
        final RESTDemoClient client = new RESTDemoClient();
        Subject.doAs(RESTDemoClient.getSubject(), new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                client.run();
                return null;
            }
        });
    }

    public void run() throws Exception {
        Cluster cluster = new Cluster();
        cluster.add(host, port);
        Client restClient = new Client(cluster, conf.getBoolean("hbase.rest.ssl.enabled", false));
        try (RemoteHTable remoteTable = new RemoteHTable(restClient, conf, "example");){
            String rowKey = "row1";
            Put p = new Put(rowKey.getBytes());
            p.addColumn("family1".getBytes(), "qualifier1".getBytes(), "value1".getBytes());
            remoteTable.put(p);
            Get g = new Get(rowKey.getBytes());
            Result result = remoteTable.get(g);
            Preconditions.checkArgument((result != null ? 1 : 0) != 0, (Object)(Bytes.toString((byte[])remoteTable.getTableName()) + " should have a row with key as " + rowKey));
            System.out.println("row = " + new String(result.getRow()));
            for (Cell cell : result.rawCells()) {
                System.out.print("family = " + Bytes.toString((byte[])CellUtil.cloneFamily((Cell)cell)) + "\t");
                System.out.print("qualifier = " + Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)cell)) + "\t");
                System.out.print("value = " + Bytes.toString((byte[])CellUtil.cloneValue((Cell)cell)) + "\t");
                System.out.println("timestamp = " + Long.toString(cell.getTimestamp()));
            }
        }
    }

    static Subject getSubject() throws Exception {
        if (!secure) {
            return new Subject();
        }
        LoginContext context = ClientUtils.getLoginContext();
        context.login();
        return context.getSubject();
    }
}

