/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor.example;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.example.RefreshHFilesEndpoint;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HFileTestUtil;
import org.junit.After;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRefreshHFilesBase {
    protected static final Logger LOG = LoggerFactory.getLogger(TestRefreshHFilesBase.class);
    protected static final HBaseTestingUtility HTU = new HBaseTestingUtility();
    protected static final int NUM_RS = 2;
    protected static final TableName TABLE_NAME = TableName.valueOf((String)"testRefreshRegionHFilesEP");
    protected static final byte[] FAMILY = Bytes.toBytes((String)"family");
    protected static final byte[] QUALIFIER = Bytes.toBytes((String)"qualifier");
    protected static final byte[][] SPLIT_KEY = new byte[][]{Bytes.toBytes((String)"30")};
    protected static final int NUM_ROWS = 5;
    protected static final String HFILE_NAME = "123abcdef";
    protected static Configuration CONF = HTU.getConfiguration();
    protected static MiniHBaseCluster cluster;
    protected static Table table;

    public static void setUp(String regionImpl) {
        try {
            CONF.set("hbase.hregion.impl", regionImpl);
            CONF.setInt("hbase.client.retries.number", 2);
            CONF.setStrings("hbase.coprocessor.region.classes", new String[]{RefreshHFilesEndpoint.class.getName()});
            cluster = HTU.startMiniCluster(2);
            table = HTU.createTable(TABLE_NAME, FAMILY, SPLIT_KEY);
            HTU.loadNumericRows(table, FAMILY, 1, 20);
            HTU.flush(TABLE_NAME);
        }
        catch (Exception ex) {
            LOG.error("Couldn't finish setup", (Throwable)ex);
        }
    }

    @After
    public void tearDown() throws Exception {
        HTU.shutdownMiniCluster();
    }

    protected void addHFilesToRegions() throws IOException {
        MasterFileSystem mfs = HTU.getMiniHBaseCluster().getMaster().getMasterFileSystem();
        Path tableDir = FSUtils.getTableDir((Path)mfs.getRootDir(), (TableName)TABLE_NAME);
        for (Region region : cluster.getRegions(TABLE_NAME)) {
            Path regionDir = new Path(tableDir, region.getRegionInfo().getEncodedName());
            Path familyDir = new Path(regionDir, Bytes.toString((byte[])FAMILY));
            HFileTestUtil.createHFile((Configuration)HTU.getConfiguration(), (FileSystem)HTU.getTestFileSystem(), (Path)new Path(familyDir, HFILE_NAME), (byte[])FAMILY, (byte[])QUALIFIER, (byte[])Bytes.toBytes((String)"50"), (byte[])Bytes.toBytes((String)"60"), (int)5);
        }
    }
}

