/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor.example;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.example.RefreshHFilesClient;
import org.apache.hadoop.hbase.coprocessor.example.TestRefreshHFilesBase;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.wal.WAL;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestRefreshHFilesEndpoint
extends TestRefreshHFilesBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRefreshHFilesEndpoint.class);

    @Test
    public void testRefreshRegionHFilesEndpoint() throws Exception {
        TestRefreshHFilesEndpoint.setUp(HRegion.class.getName());
        this.addHFilesToRegions();
        Assert.assertEquals((long)2L, (long)HTU.getNumHFiles(TABLE_NAME, FAMILY));
        this.callRefreshRegionHFilesEndPoint();
        Assert.assertEquals((long)4L, (long)HTU.getNumHFiles(TABLE_NAME, FAMILY));
    }

    @Test(expected=IOException.class)
    public void testRefreshRegionHFilesEndpointWithException() throws IOException {
        TestRefreshHFilesEndpoint.setUp(HRegionForRefreshHFilesEP.class.getName());
        this.callRefreshRegionHFilesEndPoint();
    }

    private void callRefreshRegionHFilesEndPoint() throws IOException {
        try {
            RefreshHFilesClient refreshHFilesClient = new RefreshHFilesClient(CONF);
            refreshHFilesClient.refreshHFiles(TABLE_NAME);
        }
        catch (RetriesExhaustedException rex) {
            if (rex.getCause() instanceof IOException) {
                throw new IOException();
            }
        }
        catch (Throwable ex) {
            LOG.error(ex.toString(), ex);
            Assert.fail((String)"Couldn't call the RefreshRegionHFilesEndpoint");
        }
    }

    public static class HStoreWithFaultyRefreshHFilesAPI
    extends HStore {
        public HStoreWithFaultyRefreshHFilesAPI(HRegion region, ColumnFamilyDescriptor family, Configuration confParam) throws IOException {
            super(region, family, confParam, false);
        }

        public void refreshStoreFiles() throws IOException {
            throw new IOException();
        }
    }

    public static class HRegionForRefreshHFilesEP
    extends HRegion {
        HStoreWithFaultyRefreshHFilesAPI store;

        public HRegionForRefreshHFilesEP(Path tableDir, WAL wal, FileSystem fs, Configuration confParam, RegionInfo regionInfo, TableDescriptor htd, RegionServerServices rsServices) {
            super(tableDir, wal, fs, confParam, regionInfo, htd, rsServices);
        }

        public List<HStore> getStores() {
            ArrayList<HStore> list = new ArrayList<HStore>(this.stores.size());
            try {
                if (this.store == null) {
                    this.store = new HStoreWithFaultyRefreshHFilesAPI(this, ColumnFamilyDescriptorBuilder.of((byte[])TestRefreshHFilesBase.FAMILY), this.conf);
                }
                list.add(this.store);
            }
            catch (IOException ioe) {
                TestRefreshHFilesBase.LOG.info("Couldn't instantiate custom store implementation", (Throwable)ioe);
            }
            list.addAll(this.stores.values());
            return list;
        }
    }
}

