/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor.example;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.example.WriteHeavyIncrementObserver;
import org.apache.hadoop.hbase.coprocessor.example.WriteHeavyIncrementObserverTestBase;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.testclassification.CoprocessorTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={CoprocessorTests.class, MediumTests.class})
public class TestWriteHeavyIncrementObserver
extends WriteHeavyIncrementObserverTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestWriteHeavyIncrementObserver.class);

    @BeforeClass
    public static void setUp() throws Exception {
        WriteHeavyIncrementObserverTestBase.setUp();
        UTIL.getAdmin().createTable(TableDescriptorBuilder.newBuilder((TableName)NAME).setCoprocessor(WriteHeavyIncrementObserver.class.getName()).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY)).build());
        TABLE = UTIL.getConnection().getTable(NAME);
    }

    @Test
    public void test() throws Exception {
        this.doIncrement(0);
        this.assertSum();
        try (ResultScanner scanner = TABLE.getScanner(new Scan().withStartRow(ROW).withStopRow(ROW, true).addFamily(FAMILY).readAllVersions().setAllowPartialResults(true));){
            Result r = scanner.next();
            Assert.assertTrue((r.rawCells().length > 2 ? 1 : 0) != 0);
        }
        UTIL.flush(NAME);
        HRegion region = (HRegion)UTIL.getHBaseCluster().findRegionsForTable(NAME).get(0);
        HStore store = region.getStore(FAMILY);
        do {
            region.compact(true);
        } while (store.getStorefilesCount() != 1);
        this.assertSum();
        try (ResultScanner scanner = TABLE.getScanner(new Scan().withStartRow(ROW).withStopRow(ROW, true).addFamily(FAMILY).readAllVersions().setAllowPartialResults(true));){
            Result r = scanner.next();
            Assert.assertEquals((long)2L, (long)r.rawCells().length);
        }
    }
}

