/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor.example;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.MemoryCompactionPolicy;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.example.WriteHeavyIncrementObserver;
import org.apache.hadoop.hbase.coprocessor.example.WriteHeavyIncrementObserverTestBase;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.testclassification.CoprocessorTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={CoprocessorTests.class, MediumTests.class})
public class TestWriteHeavyIncrementObserverWithMemStoreCompaction
extends WriteHeavyIncrementObserverTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestWriteHeavyIncrementObserverWithMemStoreCompaction.class);

    @BeforeClass
    public static void setUp() throws Exception {
        WriteHeavyIncrementObserverTestBase.setUp();
        UTIL.getAdmin().createTable(TableDescriptorBuilder.newBuilder((TableName)NAME).setCoprocessor(WriteHeavyIncrementObserver.class.getName()).setValue("hbase.hregion.compacting.memstore.type", MemoryCompactionPolicy.EAGER.name()).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY)).build());
        TABLE = UTIL.getConnection().getTable(NAME);
    }

    @Test
    public void test() throws Exception {
        this.doIncrement(10);
        this.assertSum();
        HStore store = ((HRegion)UTIL.getHBaseCluster().findRegionsForTable(NAME).get(0)).getStore(FAMILY);
        Assert.assertEquals((long)0L, (long)store.getStorefilesCount());
    }
}

