/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.Size;
import org.apache.hadoop.hbase.hbtop.Record;
import org.apache.hadoop.hbase.hbtop.RecordFilter;
import org.apache.hadoop.hbase.hbtop.field.Field;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestRecordFilter {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRecordFilter.class);

    @Test
    public void testParseAndBuilder() {
        this.testParseAndBuilder("REGION=region1", false, RecordFilter.newBuilder((Field)Field.REGION).equal((Object)"region1"));
        this.testParseAndBuilder("REGION=", false, RecordFilter.newBuilder((Field)Field.REGION).equal((Object)""));
        this.testParseAndBuilder("!REGION=region1", false, RecordFilter.newBuilder((Field)Field.REGION).notEqual((Object)"region1"));
        this.testParseAndBuilder("REGION==region2", true, RecordFilter.newBuilder((Field)Field.REGION, (boolean)true).doubleEquals((Object)"region2"));
        this.testParseAndBuilder("!REGION==region2", true, RecordFilter.newBuilder((Field)Field.REGION, (boolean)true).notDoubleEquals((Object)"region2"));
        this.testParseAndBuilder("#REQ/S>100", false, RecordFilter.newBuilder((Field)Field.REQUEST_COUNT_PER_SECOND).greater((Object)100L));
        this.testParseAndBuilder("!#REQ/S>100", false, RecordFilter.newBuilder((Field)Field.REQUEST_COUNT_PER_SECOND).notGreater((Object)100L));
        this.testParseAndBuilder("SF>=50MB", true, RecordFilter.newBuilder((Field)Field.STORE_FILE_SIZE, (boolean)true).greaterOrEqual((Object)"50MB"));
        this.testParseAndBuilder("!SF>=50MB", true, RecordFilter.newBuilder((Field)Field.STORE_FILE_SIZE, (boolean)true).notGreaterOrEqual((Object)"50MB"));
        this.testParseAndBuilder("#REQ/S<20", false, RecordFilter.newBuilder((Field)Field.REQUEST_COUNT_PER_SECOND).less((Object)20L));
        this.testParseAndBuilder("!#REQ/S<20", false, RecordFilter.newBuilder((Field)Field.REQUEST_COUNT_PER_SECOND).notLess((Object)20L));
        this.testParseAndBuilder("%COMP<=50%", true, RecordFilter.newBuilder((Field)Field.COMPACTION_PROGRESS, (boolean)true).lessOrEqual((Object)"50%"));
        this.testParseAndBuilder("!%COMP<=50%", true, RecordFilter.newBuilder((Field)Field.COMPACTION_PROGRESS, (boolean)true).notLessOrEqual((Object)"50%"));
    }

    private void testParseAndBuilder(String filterString, boolean ignoreCase, RecordFilter expected) {
        RecordFilter actual = RecordFilter.parse((String)filterString, (boolean)ignoreCase);
        Assert.assertThat((Object)expected, (Matcher)CoreMatchers.is((Object)actual));
    }

    @Test
    public void testParseFailure() {
        RecordFilter filter = RecordFilter.parse((String)"REGIO=region1", (boolean)false);
        Assert.assertThat((Object)filter, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        filter = RecordFilter.parse((String)"", (boolean)false);
        Assert.assertThat((Object)filter, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        filter = RecordFilter.parse((String)"#REQ/S==aaa", (boolean)false);
        Assert.assertThat((Object)filter, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        filter = RecordFilter.parse((String)"SF>=50", (boolean)false);
        Assert.assertThat((Object)filter, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testToString() {
        this.testToString("REGION=region1");
        this.testToString("!REGION=region1");
        this.testToString("REGION==region2");
        this.testToString("!REGION==region2");
        this.testToString("#REQ/S>100");
        this.testToString("!#REQ/S>100");
        this.testToString("SF>=50.0MB");
        this.testToString("!SF>=50.0MB");
        this.testToString("#REQ/S<20");
        this.testToString("!#REQ/S<20");
        this.testToString("%COMP<=50.00%");
        this.testToString("!%COMP<=50.00%");
    }

    private void testToString(String filterString) {
        RecordFilter filter = RecordFilter.parse((String)filterString, (boolean)false);
        Assert.assertThat((Object)filter, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)filterString, (Matcher)CoreMatchers.is((Object)filter.toString()));
    }

    @Test
    public void testFilters() {
        List<Record> records = this.createTestRecords();
        this.testFilter(records, "REGION=region", false, "region1", "region2", "region3", "region4", "region5");
        this.testFilter(records, "!REGION=region", false, new String[0]);
        this.testFilter(records, "REGION=Region", false, new String[0]);
        this.testFilter(records, "REGION==region", false, new String[0]);
        this.testFilter(records, "REGION==region1", false, "region1");
        this.testFilter(records, "!REGION==region1", false, "region2", "region3", "region4", "region5");
        this.testFilter(records, "#REQ/S==100", false, "region1");
        this.testFilter(records, "#REQ/S>100", false, "region2", "region5");
        this.testFilter(records, "SF>=100MB", false, "region1", "region2", "region4", "region5");
        this.testFilter(records, "!#SF>=10", false, "region1", "region4");
        this.testFilter(records, "LOCALITY<0.5", false, "region5");
        this.testFilter(records, "%COMP<=50%", false, "region2", "region3", "region4", "region5");
        this.testFilters(records, Arrays.asList("SF>=100MB", "#REQ/S>100"), false, "region2", "region5");
        this.testFilters(records, Arrays.asList("%COMP<=50%", "!#SF>=10"), false, "region4");
        this.testFilters(records, Arrays.asList("!REGION==region1", "LOCALITY<0.5", "#REQ/S>100"), false, "region5");
    }

    @Test
    public void testFiltersIgnoreCase() {
        List<Record> records = this.createTestRecords();
        this.testFilter(records, "REGION=Region", true, "region1", "region2", "region3", "region4", "region5");
        this.testFilter(records, "REGION=REGION", true, "region1", "region2", "region3", "region4", "region5");
    }

    private List<Record> createTestRecords() {
        ArrayList<Record> ret = new ArrayList<Record>();
        ret.add(this.createTestRecord("region1", 100L, new Size(100.0, Size.Unit.MEGABYTE), 2, 1.0f, 80.0f));
        ret.add(this.createTestRecord("region2", 120L, new Size(100.0, Size.Unit.GIGABYTE), 10, 0.5f, 20.0f));
        ret.add(this.createTestRecord("region3", 50L, new Size(500.0, Size.Unit.KILOBYTE), 15, 0.8f, 50.0f));
        ret.add(this.createTestRecord("region4", 90L, new Size(10.0, Size.Unit.TERABYTE), 5, 0.9f, 30.0f));
        ret.add(this.createTestRecord("region5", 200L, new Size(1.0, Size.Unit.PETABYTE), 13, 0.1f, 40.0f));
        return ret;
    }

    private Record createTestRecord(String region, long requestCountPerSecond, Size storeFileSize, int numStoreFiles, float locality, float compactionProgress) {
        Record.Builder builder = Record.builder();
        builder.put(Field.REGION, (Object)region);
        builder.put(Field.REQUEST_COUNT_PER_SECOND, (Object)requestCountPerSecond);
        builder.put(Field.STORE_FILE_SIZE, (Object)storeFileSize);
        builder.put(Field.NUM_STORE_FILES, (Object)numStoreFiles);
        builder.put(Field.LOCALITY, (Object)Float.valueOf(locality));
        builder.put(Field.COMPACTION_PROGRESS, (Object)Float.valueOf(compactionProgress));
        return builder.build();
    }

    private void testFilter(List<Record> records, String filterString, boolean ignoreCase, String ... expectedRegions) {
        this.testFilters(records, Collections.singletonList(filterString), ignoreCase, expectedRegions);
    }

    private void testFilters(List<Record> records, List<String> filterStrings, boolean ignoreCase, String ... expectedRegions) {
        List actual = records.stream().filter(r -> filterStrings.stream().map(f -> RecordFilter.parse((String)f, (boolean)ignoreCase)).allMatch(f -> f.execute(r))).map(r -> r.get((Object)Field.REGION).asString()).collect(Collectors.toList());
        Assert.assertThat(actual, (Matcher)CoreMatchers.hasItems((Object[])expectedRegions));
        Assert.assertThat((Object)actual.size(), (Matcher)CoreMatchers.is((Object)expectedRegions.length));
    }
}

