/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.ClusterMetricsBuilder;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.RegionMetricsBuilder;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerMetricsBuilder;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Size;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.hbtop.Record;
import org.apache.hadoop.hbase.hbtop.field.Field;
import org.apache.hadoop.hbase.hbtop.screen.top.Summary;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.util.Bytes;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public final class TestUtils {
    private TestUtils() {
    }

    public static ClusterMetrics createDummyClusterMetrics() {
        HashMap<ServerName, ServerMetrics> serverMetricsMap = new HashMap<ServerName, ServerMetrics>();
        ArrayList<RegionMetrics> regionMetricsList = new ArrayList<RegionMetrics>();
        regionMetricsList.add(TestUtils.createRegionMetrics("table1,,1.00000000000000000000000000000000.", 100L, 50L, 100L, new Size(100.0, Size.Unit.MEGABYTE), new Size(200.0, Size.Unit.MEGABYTE), 1, new Size(100.0, Size.Unit.MEGABYTE), 0.1f, 100L, 100L, "2019-07-22 00:00:00"));
        regionMetricsList.add(TestUtils.createRegionMetrics("table2,1,2.00000000000000000000000000000001.", 200L, 100L, 200L, new Size(200.0, Size.Unit.MEGABYTE), new Size(400.0, Size.Unit.MEGABYTE), 2, new Size(200.0, Size.Unit.MEGABYTE), 0.2f, 50L, 200L, "2019-07-22 00:00:01"));
        regionMetricsList.add(TestUtils.createRegionMetrics("namespace:table3,,3_0001.00000000000000000000000000000002.", 300L, 150L, 300L, new Size(300.0, Size.Unit.MEGABYTE), new Size(600.0, Size.Unit.MEGABYTE), 3, new Size(300.0, Size.Unit.MEGABYTE), 0.3f, 100L, 300L, "2019-07-22 00:00:02"));
        ServerName host1 = ServerName.valueOf((String)"host1.apache.com", (int)1000, (long)1L);
        serverMetricsMap.put(host1, TestUtils.createServerMetrics(host1, 100L, new Size(100.0, Size.Unit.MEGABYTE), new Size(200.0, Size.Unit.MEGABYTE), 100L, regionMetricsList));
        regionMetricsList.clear();
        regionMetricsList.add(TestUtils.createRegionMetrics("table1,1,4.00000000000000000000000000000003.", 100L, 50L, 100L, new Size(100.0, Size.Unit.MEGABYTE), new Size(200.0, Size.Unit.MEGABYTE), 1, new Size(100.0, Size.Unit.MEGABYTE), 0.4f, 50L, 100L, "2019-07-22 00:00:03"));
        regionMetricsList.add(TestUtils.createRegionMetrics("table2,,5.00000000000000000000000000000004.", 200L, 100L, 200L, new Size(200.0, Size.Unit.MEGABYTE), new Size(400.0, Size.Unit.MEGABYTE), 2, new Size(200.0, Size.Unit.MEGABYTE), 0.5f, 150L, 200L, "2019-07-22 00:00:04"));
        regionMetricsList.add(TestUtils.createRegionMetrics("namespace:table3,,6.00000000000000000000000000000005.", 300L, 150L, 300L, new Size(300.0, Size.Unit.MEGABYTE), new Size(600.0, Size.Unit.MEGABYTE), 3, new Size(300.0, Size.Unit.MEGABYTE), 0.6f, 200L, 300L, "2019-07-22 00:00:05"));
        ServerName host2 = ServerName.valueOf((String)"host2.apache.com", (int)1001, (long)2L);
        serverMetricsMap.put(host2, TestUtils.createServerMetrics(host2, 200L, new Size(16.0, Size.Unit.GIGABYTE), new Size(32.0, Size.Unit.GIGABYTE), 200L, regionMetricsList));
        ServerName host3 = ServerName.valueOf((String)"host3.apache.com", (int)1002, (long)3L);
        return ClusterMetricsBuilder.newBuilder().setHBaseVersion("3.0.0-SNAPSHOT").setClusterId("01234567-89ab-cdef-0123-456789abcdef").setLiveServerMetrics(serverMetricsMap).setDeadServerNames(Collections.singletonList(host3)).setRegionsInTransition(Collections.singletonList(new RegionState(RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)"table4")).setStartKey(new byte[0]).setEndKey(new byte[0]).setOffline(true).setReplicaId(0).setRegionId(0L).setSplit(false).build(), RegionState.State.OFFLINE, host3))).build();
    }

    private static RegionMetrics createRegionMetrics(String regionName, long readRequestCount, long filteredReadRequestCount, long writeRequestCount, Size storeFileSize, Size uncompressedStoreFileSize, int storeFileCount, Size memStoreSize, float locality, long compactedCellCount, long compactingCellCount, String lastMajorCompactionTime) {
        FastDateFormat df = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");
        try {
            return RegionMetricsBuilder.newBuilder((byte[])Bytes.toBytes((String)regionName)).setReadRequestCount(readRequestCount).setFilteredReadRequestCount(filteredReadRequestCount).setWriteRequestCount(writeRequestCount).setStoreFileSize(storeFileSize).setUncompressedStoreFileSize(uncompressedStoreFileSize).setStoreFileCount(storeFileCount).setMemStoreSize(memStoreSize).setDataLocality(locality).setCompactedCellCount(compactedCellCount).setCompactingCellCount(compactingCellCount).setLastMajorCompactionTimestamp(df.parse(lastMajorCompactionTime).getTime()).build();
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static ServerMetrics createServerMetrics(ServerName serverName, long reportTimestamp, Size usedHeapSize, Size maxHeapSize, long requestCountPerSecond, List<RegionMetrics> regionMetricsList) {
        return ServerMetricsBuilder.newBuilder((ServerName)serverName).setReportTimestamp(reportTimestamp).setUsedHeapSize(usedHeapSize).setMaxHeapSize(maxHeapSize).setRequestCountPerSecond(requestCountPerSecond).setRegionMetrics(regionMetricsList).build();
    }

    public static void assertRecordsInRegionMode(List<Record> records) {
        Assert.assertThat((Object)records.size(), (Matcher)CoreMatchers.is((Object)6));
        block16: for (Record record : records) {
            switch (record.get((Object)Field.REGION_NAME).asString()) {
                case "table1,,1.00000000000000000000000000000000.": {
                    TestUtils.assertRecordInRegionMode(record, "default", "1", "", "table1", "00000000000000000000000000000000", "host1:1000", "host1.apache.com,1000,1", 0L, 0L, 0L, 0L, new Size(100.0, Size.Unit.MEGABYTE), new Size(200.0, Size.Unit.MEGABYTE), 1, new Size(100.0, Size.Unit.MEGABYTE), 0.1f, "", 100L, 100L, 100.0f, "2019-07-22 00:00:00");
                    continue block16;
                }
                case "table1,1,4.00000000000000000000000000000003.": {
                    TestUtils.assertRecordInRegionMode(record, "default", "4", "", "table1", "00000000000000000000000000000003", "host2:1001", "host2.apache.com,1001,2", 0L, 0L, 0L, 0L, new Size(100.0, Size.Unit.MEGABYTE), new Size(200.0, Size.Unit.MEGABYTE), 1, new Size(100.0, Size.Unit.MEGABYTE), 0.4f, "1", 100L, 50L, 50.0f, "2019-07-22 00:00:03");
                    continue block16;
                }
                case "table2,,5.00000000000000000000000000000004.": {
                    TestUtils.assertRecordInRegionMode(record, "default", "5", "", "table2", "00000000000000000000000000000004", "host2:1001", "host2.apache.com,1001,2", 0L, 0L, 0L, 0L, new Size(200.0, Size.Unit.MEGABYTE), new Size(400.0, Size.Unit.MEGABYTE), 2, new Size(200.0, Size.Unit.MEGABYTE), 0.5f, "", 200L, 150L, 75.0f, "2019-07-22 00:00:04");
                    continue block16;
                }
                case "table2,1,2.00000000000000000000000000000001.": {
                    TestUtils.assertRecordInRegionMode(record, "default", "2", "", "table2", "00000000000000000000000000000001", "host1:1000", "host1.apache.com,1000,1", 0L, 0L, 0L, 0L, new Size(200.0, Size.Unit.MEGABYTE), new Size(400.0, Size.Unit.MEGABYTE), 2, new Size(200.0, Size.Unit.MEGABYTE), 0.2f, "1", 200L, 50L, 25.0f, "2019-07-22 00:00:01");
                    continue block16;
                }
                case "namespace:table3,,6.00000000000000000000000000000005.": {
                    TestUtils.assertRecordInRegionMode(record, "namespace", "6", "", "table3", "00000000000000000000000000000005", "host2:1001", "host2.apache.com,1001,2", 0L, 0L, 0L, 0L, new Size(300.0, Size.Unit.MEGABYTE), new Size(600.0, Size.Unit.MEGABYTE), 3, new Size(300.0, Size.Unit.MEGABYTE), 0.6f, "", 300L, 200L, 66.66667f, "2019-07-22 00:00:05");
                    continue block16;
                }
                case "namespace:table3,,3_0001.00000000000000000000000000000002.": {
                    TestUtils.assertRecordInRegionMode(record, "namespace", "3", "1", "table3", "00000000000000000000000000000002", "host1:1000", "host1.apache.com,1000,1", 0L, 0L, 0L, 0L, new Size(300.0, Size.Unit.MEGABYTE), new Size(600.0, Size.Unit.MEGABYTE), 3, new Size(300.0, Size.Unit.MEGABYTE), 0.3f, "", 300L, 100L, 33.333336f, "2019-07-22 00:00:02");
                    continue block16;
                }
            }
            Assert.fail();
        }
    }

    private static void assertRecordInRegionMode(Record record, String namespace, String startCode, String replicaId, String table, String region, String regionServer, String longRegionServer, long requestCountPerSecond, long readRequestCountPerSecond, long filteredReadRequestCountPerSecond, long writeCountRequestPerSecond, Size storeFileSize, Size uncompressedStoreFileSize, int numStoreFiles, Size memStoreSize, float locality, String startKey, long compactingCellCount, long compactedCellCount, float compactionProgress, String lastMajorCompactionTime) {
        Assert.assertThat((Object)record.size(), (Matcher)CoreMatchers.is((Object)22));
        Assert.assertThat((Object)record.get((Object)Field.NAMESPACE).asString(), (Matcher)CoreMatchers.is((Object)namespace));
        Assert.assertThat((Object)record.get((Object)Field.START_CODE).asString(), (Matcher)CoreMatchers.is((Object)startCode));
        Assert.assertThat((Object)record.get((Object)Field.REPLICA_ID).asString(), (Matcher)CoreMatchers.is((Object)replicaId));
        Assert.assertThat((Object)record.get((Object)Field.TABLE).asString(), (Matcher)CoreMatchers.is((Object)table));
        Assert.assertThat((Object)record.get((Object)Field.REGION).asString(), (Matcher)CoreMatchers.is((Object)region));
        Assert.assertThat((Object)record.get((Object)Field.REGION_SERVER).asString(), (Matcher)CoreMatchers.is((Object)regionServer));
        Assert.assertThat((Object)record.get((Object)Field.LONG_REGION_SERVER).asString(), (Matcher)CoreMatchers.is((Object)longRegionServer));
        Assert.assertThat((Object)record.get((Object)Field.REQUEST_COUNT_PER_SECOND).asLong(), (Matcher)CoreMatchers.is((Object)requestCountPerSecond));
        Assert.assertThat((Object)record.get((Object)Field.READ_REQUEST_COUNT_PER_SECOND).asLong(), (Matcher)CoreMatchers.is((Object)readRequestCountPerSecond));
        Assert.assertThat((Object)record.get((Object)Field.FILTERED_READ_REQUEST_COUNT_PER_SECOND).asLong(), (Matcher)CoreMatchers.is((Object)filteredReadRequestCountPerSecond));
        Assert.assertThat((Object)record.get((Object)Field.WRITE_REQUEST_COUNT_PER_SECOND).asLong(), (Matcher)CoreMatchers.is((Object)writeCountRequestPerSecond));
        Assert.assertThat((Object)record.get((Object)Field.STORE_FILE_SIZE).asSize(), (Matcher)CoreMatchers.is((Object)storeFileSize));
        Assert.assertThat((Object)record.get((Object)Field.UNCOMPRESSED_STORE_FILE_SIZE).asSize(), (Matcher)CoreMatchers.is((Object)uncompressedStoreFileSize));
        Assert.assertThat((Object)record.get((Object)Field.NUM_STORE_FILES).asInt(), (Matcher)CoreMatchers.is((Object)numStoreFiles));
        Assert.assertThat((Object)record.get((Object)Field.MEM_STORE_SIZE).asSize(), (Matcher)CoreMatchers.is((Object)memStoreSize));
        Assert.assertThat((Object)Float.valueOf(record.get((Object)Field.LOCALITY).asFloat()), (Matcher)CoreMatchers.is((Object)Float.valueOf(locality)));
        Assert.assertThat((Object)record.get((Object)Field.START_KEY).asString(), (Matcher)CoreMatchers.is((Object)startKey));
        Assert.assertThat((Object)record.get((Object)Field.COMPACTING_CELL_COUNT).asLong(), (Matcher)CoreMatchers.is((Object)compactingCellCount));
        Assert.assertThat((Object)record.get((Object)Field.COMPACTED_CELL_COUNT).asLong(), (Matcher)CoreMatchers.is((Object)compactedCellCount));
        Assert.assertThat((Object)Float.valueOf(record.get((Object)Field.COMPACTION_PROGRESS).asFloat()), (Matcher)CoreMatchers.is((Object)Float.valueOf(compactionProgress)));
        Assert.assertThat((Object)record.get((Object)Field.LAST_MAJOR_COMPACTION_TIME).asString(), (Matcher)CoreMatchers.is((Object)lastMajorCompactionTime));
    }

    public static void assertRecordsInNamespaceMode(List<Record> records) {
        Assert.assertThat((Object)records.size(), (Matcher)CoreMatchers.is((Object)2));
        block8: for (Record record : records) {
            switch (record.get((Object)Field.NAMESPACE).asString()) {
                case "default": {
                    TestUtils.assertRecordInNamespaceMode(record, 0L, 0L, 0L, 0L, new Size(600.0, Size.Unit.MEGABYTE), new Size(1200.0, Size.Unit.MEGABYTE), 6, new Size(600.0, Size.Unit.MEGABYTE), 4);
                    continue block8;
                }
                case "namespace": {
                    TestUtils.assertRecordInNamespaceMode(record, 0L, 0L, 0L, 0L, new Size(600.0, Size.Unit.MEGABYTE), new Size(1200.0, Size.Unit.MEGABYTE), 6, new Size(600.0, Size.Unit.MEGABYTE), 2);
                    continue block8;
                }
            }
            Assert.fail();
        }
    }

    private static void assertRecordInNamespaceMode(Record record, long requestCountPerSecond, long readRequestCountPerSecond, long filteredReadRequestCountPerSecond, long writeCountRequestPerSecond, Size storeFileSize, Size uncompressedStoreFileSize, int numStoreFiles, Size memStoreSize, int regionCount) {
        Assert.assertThat((Object)record.size(), (Matcher)CoreMatchers.is((Object)10));
        Assert.assertThat((Object)record.get((Object)Field.REQUEST_COUNT_PER_SECOND).asLong(), (Matcher)CoreMatchers.is((Object)requestCountPerSecond));
        Assert.assertThat((Object)record.get((Object)Field.READ_REQUEST_COUNT_PER_SECOND).asLong(), (Matcher)CoreMatchers.is((Object)readRequestCountPerSecond));
        Assert.assertThat((Object)record.get((Object)Field.FILTERED_READ_REQUEST_COUNT_PER_SECOND).asLong(), (Matcher)CoreMatchers.is((Object)filteredReadRequestCountPerSecond));
        Assert.assertThat((Object)record.get((Object)Field.WRITE_REQUEST_COUNT_PER_SECOND).asLong(), (Matcher)CoreMatchers.is((Object)writeCountRequestPerSecond));
        Assert.assertThat((Object)record.get((Object)Field.STORE_FILE_SIZE).asSize(), (Matcher)CoreMatchers.is((Object)storeFileSize));
        Assert.assertThat((Object)record.get((Object)Field.UNCOMPRESSED_STORE_FILE_SIZE).asSize(), (Matcher)CoreMatchers.is((Object)uncompressedStoreFileSize));
        Assert.assertThat((Object)record.get((Object)Field.NUM_STORE_FILES).asInt(), (Matcher)CoreMatchers.is((Object)numStoreFiles));
        Assert.assertThat((Object)record.get((Object)Field.MEM_STORE_SIZE).asSize(), (Matcher)CoreMatchers.is((Object)memStoreSize));
        Assert.assertThat((Object)record.get((Object)Field.REGION_COUNT).asInt(), (Matcher)CoreMatchers.is((Object)regionCount));
    }

    public static void assertRecordsInTableMode(List<Record> records) {
        Assert.assertThat((Object)records.size(), (Matcher)CoreMatchers.is((Object)3));
        block10: for (Record record : records) {
            String tableName;
            switch (tableName = String.format("%s:%s", record.get((Object)Field.NAMESPACE).asString(), record.get((Object)Field.TABLE).asString())) {
                case "default:table1": {
                    TestUtils.assertRecordInTableMode(record, 0L, 0L, 0L, 0L, new Size(200.0, Size.Unit.MEGABYTE), new Size(400.0, Size.Unit.MEGABYTE), 2, new Size(200.0, Size.Unit.MEGABYTE), 2);
                    continue block10;
                }
                case "default:table2": {
                    TestUtils.assertRecordInTableMode(record, 0L, 0L, 0L, 0L, new Size(400.0, Size.Unit.MEGABYTE), new Size(800.0, Size.Unit.MEGABYTE), 4, new Size(400.0, Size.Unit.MEGABYTE), 2);
                    continue block10;
                }
                case "namespace:table3": {
                    TestUtils.assertRecordInTableMode(record, 0L, 0L, 0L, 0L, new Size(600.0, Size.Unit.MEGABYTE), new Size(1200.0, Size.Unit.MEGABYTE), 6, new Size(600.0, Size.Unit.MEGABYTE), 2);
                    continue block10;
                }
            }
            Assert.fail();
        }
    }

    private static void assertRecordInTableMode(Record record, long requestCountPerSecond, long readRequestCountPerSecond, long filteredReadRequestCountPerSecond, long writeCountRequestPerSecond, Size storeFileSize, Size uncompressedStoreFileSize, int numStoreFiles, Size memStoreSize, int regionCount) {
        Assert.assertThat((Object)record.size(), (Matcher)CoreMatchers.is((Object)11));
        Assert.assertThat((Object)record.get((Object)Field.REQUEST_COUNT_PER_SECOND).asLong(), (Matcher)CoreMatchers.is((Object)requestCountPerSecond));
        Assert.assertThat((Object)record.get((Object)Field.READ_REQUEST_COUNT_PER_SECOND).asLong(), (Matcher)CoreMatchers.is((Object)readRequestCountPerSecond));
        Assert.assertThat((Object)record.get((Object)Field.FILTERED_READ_REQUEST_COUNT_PER_SECOND).asLong(), (Matcher)CoreMatchers.is((Object)filteredReadRequestCountPerSecond));
        Assert.assertThat((Object)record.get((Object)Field.WRITE_REQUEST_COUNT_PER_SECOND).asLong(), (Matcher)CoreMatchers.is((Object)writeCountRequestPerSecond));
        Assert.assertThat((Object)record.get((Object)Field.STORE_FILE_SIZE).asSize(), (Matcher)CoreMatchers.is((Object)storeFileSize));
        Assert.assertThat((Object)record.get((Object)Field.UNCOMPRESSED_STORE_FILE_SIZE).asSize(), (Matcher)CoreMatchers.is((Object)uncompressedStoreFileSize));
        Assert.assertThat((Object)record.get((Object)Field.NUM_STORE_FILES).asInt(), (Matcher)CoreMatchers.is((Object)numStoreFiles));
        Assert.assertThat((Object)record.get((Object)Field.MEM_STORE_SIZE).asSize(), (Matcher)CoreMatchers.is((Object)memStoreSize));
        Assert.assertThat((Object)record.get((Object)Field.REGION_COUNT).asInt(), (Matcher)CoreMatchers.is((Object)regionCount));
    }

    public static void assertRecordsInRegionServerMode(List<Record> records) {
        Assert.assertThat((Object)records.size(), (Matcher)CoreMatchers.is((Object)2));
        block8: for (Record record : records) {
            switch (record.get((Object)Field.REGION_SERVER).asString()) {
                case "host1:1000": {
                    TestUtils.assertRecordInRegionServerMode(record, "host1.apache.com,1000,1", 0L, 0L, 0L, 0L, new Size(600.0, Size.Unit.MEGABYTE), new Size(1200.0, Size.Unit.MEGABYTE), 6, new Size(600.0, Size.Unit.MEGABYTE), 3, new Size(100.0, Size.Unit.MEGABYTE), new Size(200.0, Size.Unit.MEGABYTE));
                    continue block8;
                }
                case "host2:1001": {
                    TestUtils.assertRecordInRegionServerMode(record, "host2.apache.com,1001,2", 0L, 0L, 0L, 0L, new Size(600.0, Size.Unit.MEGABYTE), new Size(1200.0, Size.Unit.MEGABYTE), 6, new Size(600.0, Size.Unit.MEGABYTE), 3, new Size(16.0, Size.Unit.GIGABYTE), new Size(32.0, Size.Unit.GIGABYTE));
                    continue block8;
                }
            }
            Assert.fail();
        }
    }

    private static void assertRecordInRegionServerMode(Record record, String longRegionServer, long requestCountPerSecond, long readRequestCountPerSecond, long filteredReadRequestCountPerSecond, long writeCountRequestPerSecond, Size storeFileSize, Size uncompressedStoreFileSize, int numStoreFiles, Size memStoreSize, int regionCount, Size usedHeapSize, Size maxHeapSize) {
        Assert.assertThat((Object)record.size(), (Matcher)CoreMatchers.is((Object)13));
        Assert.assertThat((Object)record.get((Object)Field.LONG_REGION_SERVER).asString(), (Matcher)CoreMatchers.is((Object)longRegionServer));
        Assert.assertThat((Object)record.get((Object)Field.REQUEST_COUNT_PER_SECOND).asLong(), (Matcher)CoreMatchers.is((Object)requestCountPerSecond));
        Assert.assertThat((Object)record.get((Object)Field.READ_REQUEST_COUNT_PER_SECOND).asLong(), (Matcher)CoreMatchers.is((Object)readRequestCountPerSecond));
        Assert.assertThat((Object)record.get((Object)Field.FILTERED_READ_REQUEST_COUNT_PER_SECOND).asLong(), (Matcher)CoreMatchers.is((Object)filteredReadRequestCountPerSecond));
        Assert.assertThat((Object)record.get((Object)Field.WRITE_REQUEST_COUNT_PER_SECOND).asLong(), (Matcher)CoreMatchers.is((Object)writeCountRequestPerSecond));
        Assert.assertThat((Object)record.get((Object)Field.STORE_FILE_SIZE).asSize(), (Matcher)CoreMatchers.is((Object)storeFileSize));
        Assert.assertThat((Object)record.get((Object)Field.UNCOMPRESSED_STORE_FILE_SIZE).asSize(), (Matcher)CoreMatchers.is((Object)uncompressedStoreFileSize));
        Assert.assertThat((Object)record.get((Object)Field.NUM_STORE_FILES).asInt(), (Matcher)CoreMatchers.is((Object)numStoreFiles));
        Assert.assertThat((Object)record.get((Object)Field.MEM_STORE_SIZE).asSize(), (Matcher)CoreMatchers.is((Object)memStoreSize));
        Assert.assertThat((Object)record.get((Object)Field.REGION_COUNT).asInt(), (Matcher)CoreMatchers.is((Object)regionCount));
        Assert.assertThat((Object)record.get((Object)Field.USED_HEAP_SIZE).asSize(), (Matcher)CoreMatchers.is((Object)usedHeapSize));
        Assert.assertThat((Object)record.get((Object)Field.MAX_HEAP_SIZE).asSize(), (Matcher)CoreMatchers.is((Object)maxHeapSize));
    }

    public static void assertSummary(Summary summary) {
        Assert.assertThat((Object)summary.getVersion(), (Matcher)CoreMatchers.is((Object)"3.0.0-SNAPSHOT"));
        Assert.assertThat((Object)summary.getClusterId(), (Matcher)CoreMatchers.is((Object)"01234567-89ab-cdef-0123-456789abcdef"));
        Assert.assertThat((Object)summary.getServers(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)summary.getLiveServers(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)summary.getDeadServers(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)summary.getRegionCount(), (Matcher)CoreMatchers.is((Object)6));
        Assert.assertThat((Object)summary.getRitCount(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)summary.getAverageLoad(), (Matcher)CoreMatchers.is((Object)3.0));
        Assert.assertThat((Object)summary.getAggregateRequestPerSecond(), (Matcher)CoreMatchers.is((Object)300L));
    }
}

