/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.screen.top;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.hbtop.RecordFilter;
import org.apache.hadoop.hbase.hbtop.field.FieldInfo;
import org.apache.hadoop.hbase.hbtop.mode.Mode;
import org.apache.hadoop.hbase.hbtop.screen.ScreenView;
import org.apache.hadoop.hbase.hbtop.screen.top.FilterDisplayModeScreenPresenter;
import org.apache.hadoop.hbase.hbtop.screen.top.FilterDisplayModeScreenView;
import org.apache.hadoop.hbase.hbtop.screen.top.TopScreenView;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@Category(value={SmallTests.class})
@RunWith(value=MockitoJUnitRunner.class)
public class TestFilterDisplayModeScreenPresenter {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFilterDisplayModeScreenPresenter.class);
    @Mock
    private FilterDisplayModeScreenView filterDisplayModeScreenView;
    @Mock
    private TopScreenView topScreenView;
    private FilterDisplayModeScreenPresenter filterDisplayModeScreenPresenter;

    @Before
    public void setup() {
        List fields = Mode.REGION.getFieldInfos().stream().map(FieldInfo::getField).collect(Collectors.toList());
        ArrayList<RecordFilter> filters = new ArrayList<RecordFilter>();
        filters.add(RecordFilter.parse((String)"NAMESPACE==namespace", fields, (boolean)true));
        filters.add(RecordFilter.parse((String)"TABLE==table", fields, (boolean)true));
        this.filterDisplayModeScreenPresenter = new FilterDisplayModeScreenPresenter(this.filterDisplayModeScreenView, filters, (ScreenView)this.topScreenView);
    }

    @Test
    public void testInit() {
        this.filterDisplayModeScreenPresenter.init();
        ((FilterDisplayModeScreenView)Mockito.verify((Object)this.filterDisplayModeScreenView)).showFilters((List)ArgumentMatchers.argThat(filters -> filters.size() == 2 && ((RecordFilter)filters.get(0)).toString().equals("NAMESPACE==namespace") && ((RecordFilter)filters.get(1)).toString().equals("TABLE==table")));
    }

    @Test
    public void testReturnToTopScreen() {
        Assert.assertThat((Object)this.filterDisplayModeScreenPresenter.returnToNextScreen(), (Matcher)CoreMatchers.is((Object)this.topScreenView));
    }
}

