/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.mode;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.hbtop.Record;
import org.apache.hadoop.hbase.hbtop.RecordFilter;
import org.apache.hadoop.hbase.hbtop.field.Field;
import org.apache.hadoop.hbase.hbtop.field.FieldInfo;
import org.apache.hadoop.hbase.hbtop.field.FieldValue;
import org.apache.hadoop.hbase.hbtop.mode.DrillDownInfo;
import org.apache.hadoop.hbase.hbtop.mode.Mode;
import org.apache.hadoop.hbase.hbtop.mode.ModeStrategy;
import org.apache.hadoop.hbase.hbtop.mode.RegionModeStrategy;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class TableModeStrategy
implements ModeStrategy {
    private final List<FieldInfo> fieldInfos = Arrays.asList(new FieldInfo(Field.NAMESPACE, 0, true), new FieldInfo(Field.TABLE, 0, true), new FieldInfo(Field.REGION_COUNT, 7, true), new FieldInfo(Field.REQUEST_COUNT_PER_SECOND, 10, true), new FieldInfo(Field.READ_REQUEST_COUNT_PER_SECOND, 10, true), new FieldInfo(Field.FILTERED_READ_REQUEST_COUNT_PER_SECOND, 8, true), new FieldInfo(Field.WRITE_REQUEST_COUNT_PER_SECOND, 10, true), new FieldInfo(Field.STORE_FILE_SIZE, 13, true), new FieldInfo(Field.UNCOMPRESSED_STORE_FILE_SIZE, 15, false), new FieldInfo(Field.NUM_STORE_FILES, 7, true), new FieldInfo(Field.MEM_STORE_SIZE, 11, true));
    private final RegionModeStrategy regionModeStrategy = new RegionModeStrategy();

    TableModeStrategy() {
    }

    @Override
    public List<FieldInfo> getFieldInfos() {
        return this.fieldInfos;
    }

    @Override
    public Field getDefaultSortField() {
        return Field.REQUEST_COUNT_PER_SECOND;
    }

    @Override
    public List<Record> getRecords(ClusterMetrics clusterMetrics) {
        List records = this.regionModeStrategy.getRecords(clusterMetrics).stream().map(record -> Record.ofEntries(this.fieldInfos.stream().filter(fi -> record.containsKey((Object)fi.getField())).map(fi -> Record.entry(fi.getField(), record.get((Object)fi.getField()))))).map(record -> Record.builder().putAll((Map<Field, FieldValue>)record).put(Field.REGION_COUNT, 1).build()).collect(Collectors.toList());
        return records.stream().collect(Collectors.groupingBy(r -> {
            String namespace = r.get((Object)Field.NAMESPACE).asString();
            String table = r.get((Object)Field.TABLE).asString();
            return TableName.valueOf((String)namespace, (String)table);
        })).entrySet().stream().flatMap(e -> ((List)e.getValue()).stream().reduce(Record::combine).map(Stream::of).orElse(Stream.empty())).collect(Collectors.toList());
    }

    @Override
    public DrillDownInfo drillDown(Record selectedRecord) {
        List<RecordFilter> initialFilters = Arrays.asList(RecordFilter.newBuilder(Field.NAMESPACE).doubleEquals(selectedRecord.get((Object)Field.NAMESPACE)), RecordFilter.newBuilder(Field.TABLE).doubleEquals(selectedRecord.get((Object)Field.TABLE)));
        return new DrillDownInfo(Mode.REGION, initialFilters);
    }
}

