/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.screen.top;

import java.util.ArrayList;
import java.util.function.Function;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.hbtop.screen.ScreenView;
import org.apache.hadoop.hbase.hbtop.screen.top.InputModeScreenPresenter;
import org.apache.hadoop.hbase.hbtop.screen.top.InputModeScreenView;
import org.apache.hadoop.hbase.hbtop.screen.top.TopScreenView;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@Category(value={SmallTests.class})
@RunWith(value=MockitoJUnitRunner.class)
public class TestInputModeScreenPresenter {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestInputModeScreenPresenter.class);
    private static final String TEST_INPUT_MESSAGE = "test input message";
    @Mock
    private InputModeScreenView inputModeScreenView;
    @Mock
    private TopScreenView topScreenView;
    @Mock
    private Function<String, ScreenView> resultListener;
    private InputModeScreenPresenter inputModeScreenPresenter;

    @Before
    public void setup() {
        ArrayList<String> histories = new ArrayList<String>();
        histories.add("history1");
        histories.add("history2");
        this.inputModeScreenPresenter = new InputModeScreenPresenter(this.inputModeScreenView, TEST_INPUT_MESSAGE, histories, this.resultListener);
    }

    @Test
    public void testInit() {
        this.inputModeScreenPresenter.init();
        ((InputModeScreenView)Mockito.verify((Object)this.inputModeScreenView)).showInput((String)ArgumentMatchers.eq((Object)TEST_INPUT_MESSAGE), (String)ArgumentMatchers.eq((Object)""), ArgumentMatchers.eq((int)0));
    }

    @Test
    public void testCharacter() {
        this.inputModeScreenPresenter.character(Character.valueOf('a'));
        this.inputModeScreenPresenter.character(Character.valueOf('b'));
        this.inputModeScreenPresenter.character(Character.valueOf('c'));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.inputModeScreenView});
        ((InputModeScreenView)inOrder.verify((Object)this.inputModeScreenView)).showInput((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"a"), ArgumentMatchers.eq((int)1));
        ((InputModeScreenView)inOrder.verify((Object)this.inputModeScreenView)).showInput((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"ab"), ArgumentMatchers.eq((int)2));
        ((InputModeScreenView)inOrder.verify((Object)this.inputModeScreenView)).showInput((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"abc"), ArgumentMatchers.eq((int)3));
    }

    @Test
    public void testArrowLeftAndRight() {
        this.inputModeScreenPresenter.character(Character.valueOf('a'));
        this.inputModeScreenPresenter.character(Character.valueOf('b'));
        this.inputModeScreenPresenter.character(Character.valueOf('c'));
        this.inputModeScreenPresenter.arrowLeft();
        this.inputModeScreenPresenter.arrowLeft();
        this.inputModeScreenPresenter.arrowLeft();
        this.inputModeScreenPresenter.arrowLeft();
        this.inputModeScreenPresenter.arrowRight();
        this.inputModeScreenPresenter.arrowRight();
        this.inputModeScreenPresenter.arrowRight();
        this.inputModeScreenPresenter.arrowRight();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.inputModeScreenView});
        ((InputModeScreenView)inOrder.verify((Object)this.inputModeScreenView)).showInput((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"a"), ArgumentMatchers.eq((int)1));
        ((InputModeScreenView)inOrder.verify((Object)this.inputModeScreenView)).showInput((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"ab"), ArgumentMatchers.eq((int)2));
        ((InputModeScreenView)inOrder.verify((Object)this.inputModeScreenView)).showInput((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"abc"), ArgumentMatchers.eq((int)3));
        ((InputModeScreenView)inOrder.verify((Object)this.inputModeScreenView)).showInput((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"abc"), ArgumentMatchers.eq((int)2));
        ((InputModeScreenView)inOrder.verify((Object)this.inputModeScreenView)).showInput((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"abc"), ArgumentMatchers.eq((int)1));
        ((InputModeScreenView)inOrder.verify((Object)this.inputModeScreenView)).showInput((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"abc"), ArgumentMatchers.eq((int)0));
        ((InputModeScreenView)inOrder.verify((Object)this.inputModeScreenView)).showInput((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"abc"), ArgumentMatchers.eq((int)1));
        ((InputModeScreenView)inOrder.verify((Object)this.inputModeScreenView)).showInput((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"abc"), ArgumentMatchers.eq((int)2));
        ((InputModeScreenView)inOrder.verify((Object)this.inputModeScreenView)).showInput((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"abc"), ArgumentMatchers.eq((int)3));
    }

    @Test
    public void testHomeAndEnd() {
        this.inputModeScreenPresenter.character(Character.valueOf('a'));
        this.inputModeScreenPresenter.character(Character.valueOf('b'));
        this.inputModeScreenPresenter.character(Character.valueOf('c'));
        this.inputModeScreenPresenter.home();
        this.inputModeScreenPresenter.home();
        this.inputModeScreenPresenter.end();
        this.inputModeScreenPresenter.end();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.inputModeScreenView});
        ((InputModeScreenView)inOrder.verify((Object)this.inputModeScreenView)).showInput((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"a"), ArgumentMatchers.eq((int)1));
        ((InputModeScreenView)inOrder.verify((Object)this.inputModeScreenView)).showInput((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"ab"), ArgumentMatchers.eq((int)2));
        ((InputModeScreenView)inOrder.verify((Object)this.inputModeScreenView)).showInput((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"abc"), ArgumentMatchers.eq((int)3));
        ((InputModeScreenView)inOrder.verify((Object)this.inputModeScreenView)).showInput((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"abc"), ArgumentMatchers.eq((int)0));
        ((InputModeScreenView)inOrder.verify((Object)this.inputModeScreenView)).showInput((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"abc"), ArgumentMatchers.eq((int)3));
    }

    @Test
    public void testBackspace() {
        this.inputModeScreenPresenter.character(Character.valueOf('a'));
        this.inputModeScreenPresenter.character(Character.valueOf('b'));
        this.inputModeScreenPresenter.character(Character.valueOf('c'));
        this.inputModeScreenPresenter.backspace();
        this.inputModeScreenPresenter.backspace();
        this.inputModeScreenPresenter.backspace();
        this.inputModeScreenPresenter.backspace();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.inputModeScreenView});
        ((InputModeScreenView)inOrder.verify((Object)this.inputModeScreenView)).showInput((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"a"), ArgumentMatchers.eq((int)1));
        ((InputModeScreenView)inOrder.verify((Object)this.inputModeScreenView)).showInput((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"ab"), ArgumentMatchers.eq((int)2));
        ((InputModeScreenView)inOrder.verify((Object)this.inputModeScreenView)).showInput((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"abc"), ArgumentMatchers.eq((int)3));
        ((InputModeScreenView)inOrder.verify((Object)this.inputModeScreenView)).showInput((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"ab"), ArgumentMatchers.eq((int)2));
        ((InputModeScreenView)inOrder.verify((Object)this.inputModeScreenView)).showInput((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"a"), ArgumentMatchers.eq((int)1));
        ((InputModeScreenView)inOrder.verify((Object)this.inputModeScreenView)).showInput((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)""), ArgumentMatchers.eq((int)0));
    }

    @Test
    public void testDelete() {
        this.inputModeScreenPresenter.character(Character.valueOf('a'));
        this.inputModeScreenPresenter.character(Character.valueOf('b'));
        this.inputModeScreenPresenter.character(Character.valueOf('c'));
        this.inputModeScreenPresenter.delete();
        this.inputModeScreenPresenter.arrowLeft();
        this.inputModeScreenPresenter.delete();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.inputModeScreenView});
        ((InputModeScreenView)inOrder.verify((Object)this.inputModeScreenView)).showInput((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"a"), ArgumentMatchers.eq((int)1));
        ((InputModeScreenView)inOrder.verify((Object)this.inputModeScreenView)).showInput((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"ab"), ArgumentMatchers.eq((int)2));
        ((InputModeScreenView)inOrder.verify((Object)this.inputModeScreenView)).showInput((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"abc"), ArgumentMatchers.eq((int)3));
        ((InputModeScreenView)inOrder.verify((Object)this.inputModeScreenView)).showInput((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"abc"), ArgumentMatchers.eq((int)2));
        ((InputModeScreenView)inOrder.verify((Object)this.inputModeScreenView)).showInput((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"ab"), ArgumentMatchers.eq((int)2));
    }

    @Test
    public void testHistories() {
        this.inputModeScreenPresenter.character(Character.valueOf('a'));
        this.inputModeScreenPresenter.character(Character.valueOf('b'));
        this.inputModeScreenPresenter.character(Character.valueOf('c'));
        this.inputModeScreenPresenter.arrowUp();
        this.inputModeScreenPresenter.arrowUp();
        this.inputModeScreenPresenter.arrowUp();
        this.inputModeScreenPresenter.arrowDown();
        this.inputModeScreenPresenter.arrowDown();
        this.inputModeScreenPresenter.arrowDown();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.inputModeScreenView});
        ((InputModeScreenView)inOrder.verify((Object)this.inputModeScreenView)).showInput((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"a"), ArgumentMatchers.eq((int)1));
        ((InputModeScreenView)inOrder.verify((Object)this.inputModeScreenView)).showInput((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"ab"), ArgumentMatchers.eq((int)2));
        ((InputModeScreenView)inOrder.verify((Object)this.inputModeScreenView)).showInput((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"abc"), ArgumentMatchers.eq((int)3));
        ((InputModeScreenView)inOrder.verify((Object)this.inputModeScreenView)).showInput((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"history2"), ArgumentMatchers.eq((int)8));
        ((InputModeScreenView)inOrder.verify((Object)this.inputModeScreenView)).showInput((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"history1"), ArgumentMatchers.eq((int)8));
        ((InputModeScreenView)inOrder.verify((Object)this.inputModeScreenView)).showInput((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"history2"), ArgumentMatchers.eq((int)8));
    }

    @Test
    public void testReturnToTopScreen() {
        Mockito.when((Object)this.resultListener.apply((String)ArgumentMatchers.any())).thenReturn((Object)this.topScreenView);
        this.inputModeScreenPresenter.character(Character.valueOf('a'));
        this.inputModeScreenPresenter.character(Character.valueOf('b'));
        this.inputModeScreenPresenter.character(Character.valueOf('c'));
        Assert.assertThat((Object)this.inputModeScreenPresenter.returnToNextScreen(), (Matcher)CoreMatchers.is((Object)this.topScreenView));
        ((Function)Mockito.verify(this.resultListener)).apply(ArgumentMatchers.eq((Object)"abc"));
    }
}

