/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.screen.top;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.hbtop.screen.top.Paging;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestPaging {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestPaging.class);

    @Test
    public void testArrowUpAndArrowDown() {
        Paging paging = new Paging();
        paging.updatePageSize(3);
        paging.updateRecordsSize(5);
        this.assertPaging(paging, 0, 0, 3);
        paging.arrowDown();
        this.assertPaging(paging, 1, 0, 3);
        paging.arrowDown();
        this.assertPaging(paging, 2, 0, 3);
        paging.arrowDown();
        this.assertPaging(paging, 3, 1, 4);
        paging.arrowDown();
        this.assertPaging(paging, 4, 2, 5);
        paging.arrowDown();
        this.assertPaging(paging, 4, 2, 5);
        paging.arrowUp();
        this.assertPaging(paging, 3, 2, 5);
        paging.arrowUp();
        this.assertPaging(paging, 2, 2, 5);
        paging.arrowUp();
        this.assertPaging(paging, 1, 1, 4);
        paging.arrowUp();
        this.assertPaging(paging, 0, 0, 3);
        paging.arrowUp();
        this.assertPaging(paging, 0, 0, 3);
    }

    @Test
    public void testPageUpAndPageDown() {
        Paging paging = new Paging();
        paging.updatePageSize(3);
        paging.updateRecordsSize(8);
        this.assertPaging(paging, 0, 0, 3);
        paging.pageDown();
        this.assertPaging(paging, 3, 3, 6);
        paging.pageDown();
        this.assertPaging(paging, 6, 5, 8);
        paging.pageDown();
        this.assertPaging(paging, 7, 5, 8);
        paging.pageDown();
        this.assertPaging(paging, 7, 5, 8);
        paging.pageUp();
        this.assertPaging(paging, 4, 4, 7);
        paging.pageUp();
        this.assertPaging(paging, 1, 1, 4);
        paging.pageUp();
        this.assertPaging(paging, 0, 0, 3);
        paging.pageUp();
        this.assertPaging(paging, 0, 0, 3);
    }

    @Test
    public void testInit() {
        Paging paging = new Paging();
        paging.updatePageSize(3);
        paging.updateRecordsSize(5);
        this.assertPaging(paging, 0, 0, 3);
        paging.pageDown();
        paging.pageDown();
        paging.pageDown();
        paging.pageDown();
        paging.init();
        this.assertPaging(paging, 0, 0, 3);
    }

    @Test
    public void testWhenPageSizeGraterThanRecordsSize() {
        Paging paging = new Paging();
        paging.updatePageSize(5);
        paging.updateRecordsSize(3);
        this.assertPaging(paging, 0, 0, 3);
        paging.arrowDown();
        this.assertPaging(paging, 1, 0, 3);
        paging.arrowDown();
        this.assertPaging(paging, 2, 0, 3);
        paging.arrowDown();
        this.assertPaging(paging, 2, 0, 3);
        paging.arrowUp();
        this.assertPaging(paging, 1, 0, 3);
        paging.arrowUp();
        this.assertPaging(paging, 0, 0, 3);
        paging.arrowUp();
        this.assertPaging(paging, 0, 0, 3);
        paging.pageDown();
        this.assertPaging(paging, 2, 0, 3);
        paging.pageDown();
        this.assertPaging(paging, 2, 0, 3);
        paging.pageUp();
        this.assertPaging(paging, 0, 0, 3);
        paging.pageUp();
        this.assertPaging(paging, 0, 0, 3);
    }

    @Test
    public void testWhenPageSizeIsZero() {
        Paging paging = new Paging();
        paging.updatePageSize(0);
        paging.updateRecordsSize(5);
        this.assertPaging(paging, 0, 0, 0);
        paging.arrowDown();
        this.assertPaging(paging, 1, 0, 0);
        paging.arrowUp();
        this.assertPaging(paging, 0, 0, 0);
        paging.pageDown();
        this.assertPaging(paging, 0, 0, 0);
        paging.pageUp();
        this.assertPaging(paging, 0, 0, 0);
    }

    @Test
    public void testWhenRecordsSizeIsZero() {
        Paging paging = new Paging();
        paging.updatePageSize(3);
        paging.updateRecordsSize(0);
        this.assertPaging(paging, 0, 0, 0);
        paging.arrowDown();
        this.assertPaging(paging, 0, 0, 0);
        paging.arrowUp();
        this.assertPaging(paging, 0, 0, 0);
        paging.pageDown();
        this.assertPaging(paging, 0, 0, 0);
        paging.pageUp();
        this.assertPaging(paging, 0, 0, 0);
    }

    @Test
    public void testWhenChangingPageSizeDynamically() {
        Paging paging = new Paging();
        paging.updatePageSize(3);
        paging.updateRecordsSize(5);
        this.assertPaging(paging, 0, 0, 3);
        paging.arrowDown();
        this.assertPaging(paging, 1, 0, 3);
        paging.updatePageSize(2);
        this.assertPaging(paging, 1, 0, 2);
        paging.arrowDown();
        this.assertPaging(paging, 2, 1, 3);
        paging.arrowDown();
        this.assertPaging(paging, 3, 2, 4);
        paging.updatePageSize(4);
        this.assertPaging(paging, 3, 1, 5);
        paging.updatePageSize(5);
        this.assertPaging(paging, 3, 0, 5);
        paging.updatePageSize(0);
        this.assertPaging(paging, 3, 0, 0);
        paging.arrowDown();
        this.assertPaging(paging, 4, 0, 0);
        paging.arrowUp();
        this.assertPaging(paging, 3, 0, 0);
        paging.pageDown();
        this.assertPaging(paging, 3, 0, 0);
        paging.pageUp();
        this.assertPaging(paging, 3, 0, 0);
        paging.updatePageSize(1);
        this.assertPaging(paging, 3, 3, 4);
    }

    @Test
    public void testWhenChangingRecordsSizeDynamically() {
        Paging paging = new Paging();
        paging.updatePageSize(3);
        paging.updateRecordsSize(5);
        this.assertPaging(paging, 0, 0, 3);
        paging.updateRecordsSize(2);
        this.assertPaging(paging, 0, 0, 2);
        Assert.assertThat((Object)paging.getCurrentPosition(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)paging.getPageStartPosition(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)paging.getPageEndPosition(), (Matcher)CoreMatchers.is((Object)2));
        paging.arrowDown();
        this.assertPaging(paging, 1, 0, 2);
        paging.updateRecordsSize(3);
        this.assertPaging(paging, 1, 0, 3);
        paging.arrowDown();
        this.assertPaging(paging, 2, 0, 3);
        paging.updateRecordsSize(1);
        this.assertPaging(paging, 0, 0, 1);
        paging.updateRecordsSize(0);
        this.assertPaging(paging, 0, 0, 0);
        paging.arrowDown();
        this.assertPaging(paging, 0, 0, 0);
        paging.arrowUp();
        this.assertPaging(paging, 0, 0, 0);
        paging.pageDown();
        this.assertPaging(paging, 0, 0, 0);
        paging.pageUp();
        this.assertPaging(paging, 0, 0, 0);
    }

    private void assertPaging(Paging paging, int currentPosition, int pageStartPosition, int pageEndPosition) {
        Assert.assertThat((Object)paging.getCurrentPosition(), (Matcher)CoreMatchers.is((Object)currentPosition));
        Assert.assertThat((Object)paging.getPageStartPosition(), (Matcher)CoreMatchers.is((Object)pageStartPosition));
        Assert.assertThat((Object)paging.getPageEndPosition(), (Matcher)CoreMatchers.is((Object)pageEndPosition));
    }
}

