/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.screen.top;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.hbtop.Record;
import org.apache.hadoop.hbase.hbtop.field.Field;
import org.apache.hadoop.hbase.hbtop.field.FieldInfo;
import org.apache.hadoop.hbase.hbtop.screen.top.Header;
import org.apache.hadoop.hbase.hbtop.screen.top.Summary;
import org.apache.hadoop.hbase.hbtop.screen.top.TopScreenModel;
import org.apache.hadoop.hbase.hbtop.screen.top.TopScreenPresenter;
import org.apache.hadoop.hbase.hbtop.screen.top.TopScreenView;
import org.apache.hadoop.hbase.hbtop.terminal.TerminalSize;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@Category(value={SmallTests.class})
@RunWith(value=MockitoJUnitRunner.class)
public class TestTopScreenPresenter {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestTopScreenPresenter.class);
    private static final List<FieldInfo> TEST_FIELD_INFOS = Arrays.asList(new FieldInfo(Field.REGION, 10, true), new FieldInfo(Field.REQUEST_COUNT_PER_SECOND, 10, true), new FieldInfo(Field.LOCALITY, 10, true));
    private static final List<Record> TEST_RECORDS = Arrays.asList(Record.ofEntries((Record.Entry[])new Record.Entry[]{Record.entry((Field)Field.REGION, (Object)"region1"), Record.entry((Field)Field.REQUEST_COUNT_PER_SECOND, (Object)1L), Record.entry((Field)Field.LOCALITY, (Object)Float.valueOf(0.3f))}), Record.ofEntries((Record.Entry[])new Record.Entry[]{Record.entry((Field)Field.REGION, (Object)"region2"), Record.entry((Field)Field.REQUEST_COUNT_PER_SECOND, (Object)2L), Record.entry((Field)Field.LOCALITY, (Object)Float.valueOf(0.2f))}), Record.ofEntries((Record.Entry[])new Record.Entry[]{Record.entry((Field)Field.REGION, (Object)"region3"), Record.entry((Field)Field.REQUEST_COUNT_PER_SECOND, (Object)3L), Record.entry((Field)Field.LOCALITY, (Object)Float.valueOf(0.1f))}));
    private static final Summary TEST_SUMMARY = new Summary("00:00:01", "3.0.0-SNAPSHOT", "01234567-89ab-cdef-0123-456789abcdef", 3, 2, 1, 6, 1, 3.0, 300L);
    @Mock
    private TopScreenView topScreenView;
    @Mock
    private TopScreenModel topScreenModel;
    private TopScreenPresenter topScreenPresenter;

    @Before
    public void setup() {
        Mockito.when((Object)this.topScreenView.getTerminalSize()).thenReturn((Object)new TerminalSize(100, 100));
        Mockito.when((Object)this.topScreenView.getPageSize()).thenReturn((Object)100);
        Mockito.when((Object)this.topScreenModel.getFieldInfos()).thenReturn(TEST_FIELD_INFOS);
        Mockito.when((Object)this.topScreenModel.getFields()).thenReturn(TEST_FIELD_INFOS.stream().map(FieldInfo::getField).collect(Collectors.toList()));
        Mockito.when((Object)this.topScreenModel.getRecords()).thenReturn(TEST_RECORDS);
        Mockito.when((Object)this.topScreenModel.getSummary()).thenReturn((Object)TEST_SUMMARY);
        this.topScreenPresenter = new TopScreenPresenter(this.topScreenView, 3000L, this.topScreenModel);
    }

    @Test
    public void testRefresh() {
        this.topScreenPresenter.init();
        this.topScreenPresenter.refresh(true);
        ((TopScreenView)Mockito.verify((Object)this.topScreenView)).showTopScreen((Summary)ArgumentMatchers.argThat(this::assertSummary), (List)ArgumentMatchers.argThat(this::assertHeaders), (List)ArgumentMatchers.argThat(this::assertRecords), (Record)ArgumentMatchers.argThat(selectedRecord -> this.assertSelectedRecord((Record)selectedRecord, 0)));
    }

    @Test
    public void testVerticalScrolling() {
        this.topScreenPresenter.init();
        this.topScreenPresenter.refresh(true);
        this.topScreenPresenter.arrowDown();
        this.topScreenPresenter.arrowDown();
        this.topScreenPresenter.arrowDown();
        this.topScreenPresenter.arrowDown();
        this.topScreenPresenter.arrowDown();
        this.topScreenPresenter.arrowDown();
        this.topScreenPresenter.arrowUp();
        this.topScreenPresenter.arrowUp();
        this.topScreenPresenter.arrowUp();
        this.topScreenPresenter.pageDown();
        this.topScreenPresenter.pageDown();
        this.topScreenPresenter.pageUp();
        this.topScreenPresenter.pageUp();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.topScreenView});
        this.verifyVerticalScrolling(inOrder, 0);
        this.verifyVerticalScrolling(inOrder, 1);
        this.verifyVerticalScrolling(inOrder, 2);
        this.verifyVerticalScrolling(inOrder, 2);
        this.verifyVerticalScrolling(inOrder, 1);
        this.verifyVerticalScrolling(inOrder, 0);
        this.verifyVerticalScrolling(inOrder, 0);
        this.verifyVerticalScrolling(inOrder, 2);
        this.verifyVerticalScrolling(inOrder, 2);
        this.verifyVerticalScrolling(inOrder, 0);
        this.verifyVerticalScrolling(inOrder, 0);
    }

    private void verifyVerticalScrolling(InOrder inOrder, int expectedSelectedRecodeIndex) {
        ((TopScreenView)inOrder.verify((Object)this.topScreenView)).showTopScreen((Summary)ArgumentMatchers.any(), (List)ArgumentMatchers.any(), (List)ArgumentMatchers.any(), (Record)ArgumentMatchers.argThat(selectedRecord -> this.assertSelectedRecord((Record)selectedRecord, expectedSelectedRecodeIndex)));
    }

    @Test
    public void testHorizontalScrolling() {
        this.topScreenPresenter.init();
        this.topScreenPresenter.refresh(true);
        this.topScreenPresenter.arrowRight();
        this.topScreenPresenter.arrowRight();
        this.topScreenPresenter.arrowRight();
        this.topScreenPresenter.arrowLeft();
        this.topScreenPresenter.arrowLeft();
        this.topScreenPresenter.arrowLeft();
        this.topScreenPresenter.end();
        this.topScreenPresenter.end();
        this.topScreenPresenter.home();
        this.topScreenPresenter.home();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.topScreenView});
        this.verifyHorizontalScrolling(inOrder, 3);
        this.verifyHorizontalScrolling(inOrder, 2);
        this.verifyHorizontalScrolling(inOrder, 1);
        this.verifyHorizontalScrolling(inOrder, 1);
        this.verifyHorizontalScrolling(inOrder, 2);
        this.verifyHorizontalScrolling(inOrder, 3);
        this.verifyHorizontalScrolling(inOrder, 3);
        this.verifyHorizontalScrolling(inOrder, 1);
        this.verifyHorizontalScrolling(inOrder, 1);
        this.verifyHorizontalScrolling(inOrder, 3);
        this.verifyHorizontalScrolling(inOrder, 3);
    }

    private void verifyHorizontalScrolling(InOrder inOrder, int expectedHeaderCount) {
        ((TopScreenView)inOrder.verify((Object)this.topScreenView)).showTopScreen((Summary)ArgumentMatchers.any(), (List)ArgumentMatchers.argThat(headers -> headers.size() == expectedHeaderCount), (List)ArgumentMatchers.any(), (Record)ArgumentMatchers.any());
    }

    private boolean assertSummary(Summary actual) {
        return actual.getCurrentTime().equals(TEST_SUMMARY.getCurrentTime()) && actual.getVersion().equals(TEST_SUMMARY.getVersion()) && actual.getClusterId().equals(TEST_SUMMARY.getClusterId()) && actual.getServers() == TEST_SUMMARY.getServers() && actual.getLiveServers() == TEST_SUMMARY.getLiveServers() && actual.getDeadServers() == TEST_SUMMARY.getDeadServers() && actual.getRegionCount() == TEST_SUMMARY.getRegionCount() && actual.getRitCount() == TEST_SUMMARY.getRitCount() && actual.getAverageLoad() == TEST_SUMMARY.getAverageLoad() && actual.getAggregateRequestPerSecond() == TEST_SUMMARY.getAggregateRequestPerSecond();
    }

    private boolean assertHeaders(List<Header> actual) {
        List expected = TEST_FIELD_INFOS.stream().map(fi -> new Header(fi.getField(), fi.getDefaultLength())).collect(Collectors.toList());
        if (actual.size() != expected.size()) {
            return false;
        }
        for (int i = 0; i < actual.size(); ++i) {
            if (actual.get(i).getField() != ((Header)expected.get(i)).getField()) {
                return false;
            }
            if (actual.get(i).getLength() == ((Header)expected.get(i)).getLength()) continue;
            return false;
        }
        return true;
    }

    private boolean assertRecords(List<Record> actual) {
        if (actual.size() != TEST_RECORDS.size()) {
            return false;
        }
        for (int i = 0; i < actual.size(); ++i) {
            if (this.assertRecord(actual.get(i), TEST_RECORDS.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean assertSelectedRecord(Record actual, int expectedSelectedRecodeIndex) {
        return this.assertRecord(actual, TEST_RECORDS.get(expectedSelectedRecodeIndex));
    }

    private boolean assertRecord(Record actual, Record expected) {
        return actual.get((Object)Field.REGION).equals((Object)expected.get((Object)Field.REGION)) && actual.get((Object)Field.REQUEST_COUNT_PER_SECOND).equals((Object)expected.get((Object)Field.REQUEST_COUNT_PER_SECOND)) && actual.get((Object)Field.LOCALITY).equals((Object)expected.get((Object)Field.LOCALITY));
    }
}

