/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop;

import ch.cern.hbase.thirdparty.com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.hadoop.hbase.hbtop.field.Field;
import org.apache.hadoop.hbase.hbtop.field.FieldValue;
import org.apache.hadoop.hbase.hbtop.field.FieldValueType;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class Record
implements Map<Field, FieldValue> {
    private final ImmutableMap<Field, FieldValue> values;

    public static Builder builder() {
        return new Builder();
    }

    public static Entry entry(Field field, Object value) {
        return new Entry(field, field.newValue(value));
    }

    public static Entry entry(Field field, FieldValue value) {
        return new Entry(field, value);
    }

    public static Record ofEntries(Entry ... entries) {
        return Record.ofEntries(Stream.of(entries));
    }

    public static Record ofEntries(Stream<Entry> entries) {
        return entries.collect(Record::builder, Builder::put, (r1, r2) -> {}).build();
    }

    private Record(ImmutableMap<Field, FieldValue> values) {
        this.values = values;
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.values.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values.containsValue(value);
    }

    @Override
    public FieldValue get(Object key) {
        return (FieldValue)this.values.get(key);
    }

    @Override
    public FieldValue put(Field key, FieldValue value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FieldValue remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(@NonNull Map<? extends Field, ? extends FieldValue> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NonNull
    public Set<Field> keySet() {
        return this.values.keySet();
    }

    @Override
    @NonNull
    public Collection<FieldValue> values() {
        return this.values.values();
    }

    @Override
    @NonNull
    public Set<Map.Entry<Field, FieldValue>> entrySet() {
        return this.values.entrySet();
    }

    public Record combine(Record o) {
        return Record.ofEntries(this.values.keySet().stream().map(k -> {
            if (k.getFieldValueType() == FieldValueType.STRING) {
                return Record.entry(k, (FieldValue)this.values.get((Object)k));
            }
            return Record.entry(k, ((FieldValue)this.values.get((Object)k)).plus((FieldValue)o.values.get((Object)k)));
        }));
    }

    public static final class Builder {
        private final ImmutableMap.Builder<Field, FieldValue> builder = ImmutableMap.builder();

        private Builder() {
        }

        public Builder put(Field key, Object value) {
            this.builder.put((Object)key, (Object)key.newValue(value));
            return this;
        }

        public Builder put(Field key, FieldValue value) {
            this.builder.put((Object)key, (Object)value);
            return this;
        }

        public Builder put(Entry entry) {
            this.builder.put((Map.Entry)entry);
            return this;
        }

        public Builder putAll(Map<Field, FieldValue> map) {
            this.builder.putAll(map);
            return this;
        }

        public Record build() {
            return new Record(this.builder.build());
        }
    }

    public static final class Entry
    extends AbstractMap.SimpleImmutableEntry<Field, FieldValue> {
        private Entry(Field key, FieldValue value) {
            super(key, value);
        }
    }
}

