/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.terminal.impl;

import ch.cern.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hbase.hbtop.terminal.KeyPress;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class KeyPressGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyPressGenerator.class);
    private final Queue<KeyPress> keyPressQueue;
    private final BlockingQueue<Character> inputCharacterQueue = new LinkedBlockingQueue<Character>();
    private final Reader input;
    private final InputStream inputStream;
    private final AtomicBoolean stopThreads = new AtomicBoolean();
    private final ExecutorService executorService;
    private ParseState parseState;
    private int param1;
    private int param2;

    public KeyPressGenerator(InputStream inputStream, Queue<KeyPress> keyPressQueue) {
        this.inputStream = inputStream;
        this.input = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        this.keyPressQueue = keyPressQueue;
        this.executorService = Executors.newFixedThreadPool(2, new ThreadFactoryBuilder().setNameFormat("KeyPressGenerator-%d").setDaemon(true).setUncaughtExceptionHandler(Threads.LOGGING_EXCEPTION_HANDLER).build());
        this.initState();
    }

    public void start() {
        this.executorService.execute(this::readerThread);
        this.executorService.execute(this::generatorThread);
    }

    private void initState() {
        this.parseState = ParseState.START;
        this.param1 = 0;
        this.param2 = 0;
    }

    private void readerThread() {
        boolean done = false;
        char[] readBuffer = new char[128];
        while (!done && !this.stopThreads.get()) {
            try {
                int n = this.inputStream.available();
                if (n > 0) {
                    int rc;
                    if (readBuffer.length < n) {
                        readBuffer = new char[readBuffer.length * 2];
                    }
                    if ((rc = this.input.read(readBuffer, 0, readBuffer.length)) == -1) {
                        done = true;
                        continue;
                    }
                    for (int i = 0; i < rc; ++i) {
                        char ch = readBuffer[i];
                        this.inputCharacterQueue.offer(Character.valueOf(ch));
                    }
                    continue;
                }
                Thread.sleep(20L);
            }
            catch (InterruptedException n) {
            }
            catch (IOException e) {
                LOGGER.error("Caught an exception", (Throwable)e);
                done = true;
            }
        }
    }

    private void generatorThread() {
        block7: while (!this.stopThreads.get()) {
            Character ch;
            try {
                ch = this.inputCharacterQueue.poll(100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ignored) {
                continue;
            }
            if (ch == null) {
                if (this.parseState == ParseState.ESCAPE) {
                    this.offer(new KeyPress(KeyPress.Type.Escape, null, false, false, false));
                    this.initState();
                    continue;
                }
                if (this.parseState == ParseState.START) continue;
                this.offer(new KeyPress(KeyPress.Type.Unknown, null, false, false, false));
                this.initState();
                continue;
            }
            if (this.parseState == ParseState.START) {
                if (ch.charValue() == '\u001b') {
                    this.parseState = ParseState.ESCAPE;
                    continue;
                }
                switch (ch.charValue()) {
                    case '\n': 
                    case '\r': {
                        this.offer(new KeyPress(KeyPress.Type.Enter, Character.valueOf('\n'), false, false, false));
                        continue block7;
                    }
                    case '\b': 
                    case '\u007f': {
                        this.offer(new KeyPress(KeyPress.Type.Backspace, Character.valueOf('\b'), false, false, false));
                        continue block7;
                    }
                    case '\t': {
                        this.offer(new KeyPress(KeyPress.Type.Tab, Character.valueOf('\t'), false, false, false));
                        continue block7;
                    }
                }
                if (ch.charValue() < ' ') {
                    this.ctrlAndCharacter(ch.charValue());
                    continue;
                }
                if (this.isPrintableChar(ch.charValue())) {
                    this.offer(new KeyPress(KeyPress.Type.Character, ch, false, false, false));
                    continue;
                }
                this.offer(new KeyPress(KeyPress.Type.Unknown, null, false, false, false));
                continue;
            }
            if (this.parseState == ParseState.ESCAPE) {
                if (ch.charValue() == '\u001b') {
                    this.offer(new KeyPress(KeyPress.Type.Escape, null, false, false, false));
                    continue;
                }
                if (ch.charValue() < ' ' && ch.charValue() != '\b') {
                    this.ctrlAltAndCharacter(ch.charValue());
                    this.initState();
                    continue;
                }
                if (ch.charValue() == '\u007f' || ch.charValue() == '\b') {
                    this.offer(new KeyPress(KeyPress.Type.Backspace, Character.valueOf('\b'), false, false, false));
                    this.initState();
                    continue;
                }
                if (ch.charValue() == '[' || ch.charValue() == 'O') {
                    this.parseState = ParseState.ESCAPE_SEQUENCE_PARAM1;
                    continue;
                }
                if (this.isPrintableChar(ch.charValue())) {
                    this.offer(new KeyPress(KeyPress.Type.Character, ch, true, false, false));
                    this.initState();
                    continue;
                }
                this.offer(new KeyPress(KeyPress.Type.Escape, null, false, false, false));
                this.offer(new KeyPress(KeyPress.Type.Unknown, null, false, false, false));
                this.initState();
                continue;
            }
            this.escapeSequenceCharacter(ch.charValue());
        }
    }

    private void ctrlAndCharacter(char ch) {
        char ctrlCode;
        switch (ch) {
            case '\u0000': {
                ctrlCode = ' ';
                break;
            }
            case '\u001c': {
                ctrlCode = '\\';
                break;
            }
            case '\u001d': {
                ctrlCode = ']';
                break;
            }
            case '\u001e': {
                ctrlCode = '^';
                break;
            }
            case '\u001f': {
                ctrlCode = '_';
                break;
            }
            default: {
                ctrlCode = (char)(96 + ch);
            }
        }
        this.offer(new KeyPress(KeyPress.Type.Character, Character.valueOf(ctrlCode), false, true, false));
    }

    private boolean isPrintableChar(char ch) {
        if (Character.isISOControl(ch)) {
            return false;
        }
        Character.UnicodeBlock block = Character.UnicodeBlock.of(ch);
        return block != null && !block.equals(Character.UnicodeBlock.SPECIALS);
    }

    private void ctrlAltAndCharacter(char ch) {
        char ctrlCode;
        switch (ch) {
            case '\u0000': {
                ctrlCode = ' ';
                break;
            }
            case '\u001c': {
                ctrlCode = '\\';
                break;
            }
            case '\u001d': {
                ctrlCode = ']';
                break;
            }
            case '\u001e': {
                ctrlCode = '^';
                break;
            }
            case '\u001f': {
                ctrlCode = '_';
                break;
            }
            default: {
                ctrlCode = (char)(96 + ch);
            }
        }
        this.offer(new KeyPress(KeyPress.Type.Character, Character.valueOf(ctrlCode), true, true, false));
    }

    private void escapeSequenceCharacter(char ch) {
        switch (this.parseState) {
            case ESCAPE_SEQUENCE_PARAM1: {
                if (ch == ';') {
                    this.parseState = ParseState.ESCAPE_SEQUENCE_PARAM2;
                    break;
                }
                if (Character.isDigit(ch)) {
                    this.param1 = this.param1 * 10 + Character.digit(ch, 10);
                    break;
                }
                this.doneEscapeSequenceCharacter(ch);
                break;
            }
            case ESCAPE_SEQUENCE_PARAM2: {
                if (Character.isDigit(ch)) {
                    this.param2 = this.param2 * 10 + Character.digit(ch, 10);
                    break;
                }
                this.doneEscapeSequenceCharacter(ch);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private void doneEscapeSequenceCharacter(char last) {
        boolean alt = false;
        boolean ctrl = false;
        boolean shift = false;
        if (this.param2 != 0) {
            alt = this.isAlt(this.param2);
            ctrl = this.isCtrl(this.param2);
            shift = this.isShift(this.param2);
        }
        if (last != '~') {
            switch (last) {
                case 'A': {
                    this.offer(new KeyPress(KeyPress.Type.ArrowUp, null, alt, ctrl, shift));
                    break;
                }
                case 'B': {
                    this.offer(new KeyPress(KeyPress.Type.ArrowDown, null, alt, ctrl, shift));
                    break;
                }
                case 'C': {
                    this.offer(new KeyPress(KeyPress.Type.ArrowRight, null, alt, ctrl, shift));
                    break;
                }
                case 'D': {
                    this.offer(new KeyPress(KeyPress.Type.ArrowLeft, null, alt, ctrl, shift));
                    break;
                }
                case 'H': {
                    this.offer(new KeyPress(KeyPress.Type.Home, null, alt, ctrl, shift));
                    break;
                }
                case 'F': {
                    this.offer(new KeyPress(KeyPress.Type.End, null, alt, ctrl, shift));
                    break;
                }
                case 'P': {
                    this.offer(new KeyPress(KeyPress.Type.F1, null, alt, ctrl, shift));
                    break;
                }
                case 'Q': {
                    this.offer(new KeyPress(KeyPress.Type.F2, null, alt, ctrl, shift));
                    break;
                }
                case 'R': {
                    this.offer(new KeyPress(KeyPress.Type.F3, null, alt, ctrl, shift));
                    break;
                }
                case 'S': {
                    this.offer(new KeyPress(KeyPress.Type.F4, null, alt, ctrl, shift));
                    break;
                }
                case 'Z': {
                    this.offer(new KeyPress(KeyPress.Type.ReverseTab, null, alt, ctrl, shift));
                    break;
                }
                default: {
                    this.offer(new KeyPress(KeyPress.Type.Unknown, null, alt, ctrl, shift));
                }
            }
            this.initState();
            return;
        }
        switch (this.param1) {
            case 1: {
                this.offer(new KeyPress(KeyPress.Type.Home, null, alt, ctrl, shift));
                break;
            }
            case 2: {
                this.offer(new KeyPress(KeyPress.Type.Insert, null, alt, ctrl, shift));
                break;
            }
            case 3: {
                this.offer(new KeyPress(KeyPress.Type.Delete, null, alt, ctrl, shift));
                break;
            }
            case 4: {
                this.offer(new KeyPress(KeyPress.Type.End, null, alt, ctrl, shift));
                break;
            }
            case 5: {
                this.offer(new KeyPress(KeyPress.Type.PageUp, null, alt, ctrl, shift));
                break;
            }
            case 6: {
                this.offer(new KeyPress(KeyPress.Type.PageDown, null, alt, ctrl, shift));
                break;
            }
            case 11: {
                this.offer(new KeyPress(KeyPress.Type.F1, null, alt, ctrl, shift));
                break;
            }
            case 12: {
                this.offer(new KeyPress(KeyPress.Type.F2, null, alt, ctrl, shift));
                break;
            }
            case 13: {
                this.offer(new KeyPress(KeyPress.Type.F3, null, alt, ctrl, shift));
                break;
            }
            case 14: {
                this.offer(new KeyPress(KeyPress.Type.F4, null, alt, ctrl, shift));
                break;
            }
            case 15: {
                this.offer(new KeyPress(KeyPress.Type.F5, null, alt, ctrl, shift));
                break;
            }
            case 17: {
                this.offer(new KeyPress(KeyPress.Type.F6, null, alt, ctrl, shift));
                break;
            }
            case 18: {
                this.offer(new KeyPress(KeyPress.Type.F7, null, alt, ctrl, shift));
                break;
            }
            case 19: {
                this.offer(new KeyPress(KeyPress.Type.F8, null, alt, ctrl, shift));
                break;
            }
            case 20: {
                this.offer(new KeyPress(KeyPress.Type.F9, null, alt, ctrl, shift));
                break;
            }
            case 21: {
                this.offer(new KeyPress(KeyPress.Type.F10, null, alt, ctrl, shift));
                break;
            }
            case 23: {
                this.offer(new KeyPress(KeyPress.Type.F11, null, alt, ctrl, shift));
                break;
            }
            case 24: {
                this.offer(new KeyPress(KeyPress.Type.F12, null, alt, ctrl, shift));
                break;
            }
            default: {
                this.offer(new KeyPress(KeyPress.Type.Unknown, null, false, false, false));
            }
        }
        this.initState();
    }

    private boolean isShift(int param) {
        return (param & 1) != 0;
    }

    private boolean isAlt(int param) {
        return (param & 2) != 0;
    }

    private boolean isCtrl(int param) {
        return (param & 4) != 0;
    }

    private void offer(KeyPress keyPress) {
        if (keyPress.isCtrl() && keyPress.getType() == KeyPress.Type.Character && keyPress.getCharacter().charValue() == 'c') {
            System.exit(0);
        }
        this.keyPressQueue.offer(keyPress);
    }

    public void stop() {
        this.stopThreads.set(true);
        this.executorService.shutdown();
        try {
            while (!this.executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                LOGGER.warn("Waiting for thread-pool to terminate");
            }
        }
        catch (InterruptedException e) {
            LOGGER.warn("Interrupted while waiting for thread-pool termination", (Throwable)e);
        }
    }

    private static enum ParseState {
        START,
        ESCAPE,
        ESCAPE_SEQUENCE_PARAM1,
        ESCAPE_SEQUENCE_PARAM2;

    }
}

