/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.http;

import java.io.FileNotFoundException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.http.HttpServer;
import org.apache.hadoop.hbase.http.HttpServerFunctionalTest;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, SmallTests.class})
public class TestHttpServerWebapps
extends HttpServerFunctionalTest {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHttpServerWebapps.class);
    private static final Logger log = LoggerFactory.getLogger(TestHttpServerWebapps.class);

    @Test
    public void testValidServerResource() throws Throwable {
        HttpServer server = null;
        try {
            server = TestHttpServerWebapps.createServer("test");
        }
        finally {
            TestHttpServerWebapps.stop(server);
        }
    }

    @Test
    public void testMissingServerResource() throws Throwable {
        try {
            HttpServer server = TestHttpServerWebapps.createServer("NoSuchWebapp");
            String serverDescription = server.toString();
            TestHttpServerWebapps.stop(server);
            TestHttpServerWebapps.fail((String)("Expected an exception, got " + serverDescription));
        }
        catch (FileNotFoundException expected) {
            log.debug("Expected exception " + expected, (Throwable)expected);
        }
    }
}

