/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.util.Random;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.BloomType;

public class ChangeBloomFilterAction
extends Action {
    private final long sleepTime;
    private final TableName tableName;

    public ChangeBloomFilterAction(TableName tableName) {
        this(-1, tableName);
    }

    public ChangeBloomFilterAction(int sleepTime, TableName tableName) {
        this.sleepTime = sleepTime;
        this.tableName = tableName;
    }

    @Override
    public void perform() throws Exception {
        Random random = new Random();
        BloomType[] bloomArray = BloomType.values();
        int bloomArraySize = bloomArray.length;
        LOG.info("Performing action: Change bloom filter on all columns of table " + this.tableName);
        this.modifyAllTableColumns(this.tableName, (String columnName, ColumnFamilyDescriptorBuilder columnBuilder) -> {
            BloomType bloomType = bloomArray[random.nextInt(bloomArraySize)];
            LOG.debug("Performing action: About to set bloom filter type to " + bloomType + " on column " + columnName + " of table " + this.tableName);
            columnBuilder.setBloomFilterType(bloomType);
        });
        LOG.debug("Performing action: Just set bloom filter types on table " + this.tableName);
    }
}

