/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.RandomUtils;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.util.Bytes;

public class MoveRegionsOfTableAction
extends Action {
    private final long sleepTime;
    private final TableName tableName;
    private final long maxTime;

    public MoveRegionsOfTableAction(TableName tableName) {
        this(-1L, 600000L, tableName);
    }

    public MoveRegionsOfTableAction(long sleepTime, long maxSleepTime, TableName tableName) {
        this.sleepTime = sleepTime;
        this.tableName = tableName;
        this.maxTime = maxSleepTime;
    }

    @Override
    public void perform() throws Exception {
        if (this.sleepTime > 0L) {
            Thread.sleep(this.sleepTime);
        }
        Admin admin = this.context.getHBaseIntegrationTestingUtility().getAdmin();
        ServerName[] servers = MoveRegionsOfTableAction.getServers(admin);
        LOG.info("Performing action: Move regions of table {}", (Object)this.tableName);
        List regions = admin.getTableRegions(this.tableName);
        if (regions == null || regions.isEmpty()) {
            LOG.info("Table {} doesn't have regions to move", (Object)this.tableName);
            return;
        }
        Collections.shuffle(regions);
        long start = System.currentTimeMillis();
        for (HRegionInfo regionInfo : regions) {
            if (this.context.isStopping()) {
                return;
            }
            MoveRegionsOfTableAction.moveRegion(admin, servers, (RegionInfo)regionInfo);
            if (this.sleepTime > 0L) {
                Thread.sleep(this.sleepTime);
            }
            if (System.currentTimeMillis() - start <= this.maxTime) continue;
            break;
        }
    }

    static ServerName[] getServers(Admin admin) throws IOException {
        Set serversList = admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS)).getLiveServerMetrics().keySet();
        return serversList.toArray(new ServerName[serversList.size()]);
    }

    static void moveRegion(Admin admin, ServerName[] servers, RegionInfo regionInfo) {
        try {
            String destServerName = servers[RandomUtils.nextInt((int)0, (int)servers.length)].getServerName();
            LOG.debug("Moving {} to {}", (Object)regionInfo.getRegionNameAsString(), (Object)destServerName);
            admin.move(regionInfo.getEncodedNameAsBytes(), Bytes.toBytes((String)destServerName));
        }
        catch (Exception ex) {
            LOG.warn("Move failed, might be caused by other chaos: {}", (Object)ex.getMessage());
        }
    }
}

