/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.util.ArrayList;
import java.util.LinkedList;
import org.apache.commons.lang3.RandomUtils;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.chaos.actions.Action;

public class UnbalanceRegionsAction
extends Action {
    private double fractionOfRegions;
    private double fractionOfServers;

    public UnbalanceRegionsAction(double fractionOfRegions, double fractionOfServers) {
        this.fractionOfRegions = fractionOfRegions;
        this.fractionOfServers = fractionOfServers;
    }

    @Override
    public void perform() throws Exception {
        LOG.info("Unbalancing regions");
        ClusterMetrics status = this.cluster.getClusterMetrics();
        LinkedList<ServerName> victimServers = new LinkedList<ServerName>(status.getLiveServerMetrics().keySet());
        int targetServerCount = (int)Math.ceil(this.fractionOfServers * (double)victimServers.size());
        ArrayList<ServerName> targetServers = new ArrayList<ServerName>(targetServerCount);
        for (int i = 0; i < targetServerCount; ++i) {
            int victimIx = RandomUtils.nextInt((int)0, (int)victimServers.size());
            targetServers.add((ServerName)victimServers.remove(victimIx));
        }
        this.unbalanceRegions(status, victimServers, targetServers, this.fractionOfRegions);
    }
}

