/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.factories;

import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.chaos.actions.AddColumnAction;
import org.apache.hadoop.hbase.chaos.actions.BatchRestartRsAction;
import org.apache.hadoop.hbase.chaos.actions.ChangeBloomFilterAction;
import org.apache.hadoop.hbase.chaos.actions.ChangeCompressionAction;
import org.apache.hadoop.hbase.chaos.actions.ChangeEncodingAction;
import org.apache.hadoop.hbase.chaos.actions.ChangeSplitPolicyAction;
import org.apache.hadoop.hbase.chaos.actions.ChangeVersionsAction;
import org.apache.hadoop.hbase.chaos.actions.CompactRandomRegionOfTableAction;
import org.apache.hadoop.hbase.chaos.actions.CompactTableAction;
import org.apache.hadoop.hbase.chaos.actions.DecreaseMaxHFileSizeAction;
import org.apache.hadoop.hbase.chaos.actions.DumpClusterStatusAction;
import org.apache.hadoop.hbase.chaos.actions.FlushRandomRegionOfTableAction;
import org.apache.hadoop.hbase.chaos.actions.FlushTableAction;
import org.apache.hadoop.hbase.chaos.actions.MergeRandomAdjacentRegionsOfTableAction;
import org.apache.hadoop.hbase.chaos.actions.MoveRandomRegionOfTableAction;
import org.apache.hadoop.hbase.chaos.actions.MoveRegionsOfTableAction;
import org.apache.hadoop.hbase.chaos.actions.RemoveColumnAction;
import org.apache.hadoop.hbase.chaos.actions.RestartActiveMasterAction;
import org.apache.hadoop.hbase.chaos.actions.RestartRandomRsAction;
import org.apache.hadoop.hbase.chaos.actions.RestartRsHoldingMetaAction;
import org.apache.hadoop.hbase.chaos.actions.RollingBatchRestartRsAction;
import org.apache.hadoop.hbase.chaos.actions.SnapshotTableAction;
import org.apache.hadoop.hbase.chaos.actions.SplitAllRegionOfTableAction;
import org.apache.hadoop.hbase.chaos.actions.SplitRandomRegionOfTableAction;
import org.apache.hadoop.hbase.chaos.factories.MonkeyFactory;
import org.apache.hadoop.hbase.chaos.monkies.ChaosMonkey;
import org.apache.hadoop.hbase.chaos.monkies.PolicyBasedChaosMonkey;
import org.apache.hadoop.hbase.chaos.policies.CompositeSequentialPolicy;
import org.apache.hadoop.hbase.chaos.policies.DoActionsOncePolicy;
import org.apache.hadoop.hbase.chaos.policies.PeriodicRandomActionPolicy;

public class SlowDeterministicMonkeyFactory
extends MonkeyFactory {
    private long action1Period;
    private long action2Period;
    private long action3Period;
    private long action4Period;
    private long moveRegionsMaxTime;
    private long moveRegionsSleepTime;
    private long moveRandomRegionSleepTime;
    private long restartRandomRSSleepTime;
    private long batchRestartRSSleepTime;
    private float batchRestartRSRatio;
    private long restartActiveMasterSleepTime;
    private long rollingBatchRestartRSSleepTime;
    private float rollingBatchRestartRSRatio;
    private long restartRsHoldingMetaSleepTime;
    private float compactTableRatio;
    private float compactRandomRegionRatio;
    private long decreaseHFileSizeSleepTime;

    @Override
    public ChaosMonkey build() {
        this.loadProperties();
        Action[] actions1 = new Action[]{new CompactTableAction(this.tableName, this.compactTableRatio), new CompactRandomRegionOfTableAction(this.tableName, this.compactRandomRegionRatio), new FlushTableAction(this.tableName), new FlushRandomRegionOfTableAction(this.tableName), new MoveRandomRegionOfTableAction(this.tableName)};
        Action[] actions2 = new Action[]{new SplitRandomRegionOfTableAction(this.tableName), new MergeRandomAdjacentRegionsOfTableAction(this.tableName), new SnapshotTableAction(this.tableName), new AddColumnAction(this.tableName), new RemoveColumnAction(this.tableName, this.columnFamilies), new ChangeEncodingAction(this.tableName), new ChangeCompressionAction(this.tableName), new ChangeBloomFilterAction(this.tableName), new ChangeVersionsAction(this.tableName), new ChangeSplitPolicyAction(this.tableName)};
        Action[] actions3 = new Action[]{new MoveRegionsOfTableAction(this.moveRegionsSleepTime, this.moveRegionsMaxTime, this.tableName), new MoveRandomRegionOfTableAction(this.moveRandomRegionSleepTime, this.tableName), new RestartRandomRsAction(this.restartRandomRSSleepTime), new BatchRestartRsAction(this.batchRestartRSSleepTime, this.batchRestartRSRatio), new RestartActiveMasterAction(this.restartActiveMasterSleepTime), new RollingBatchRestartRsAction(this.rollingBatchRestartRSSleepTime, this.rollingBatchRestartRSRatio), new RestartRsHoldingMetaAction(this.restartRsHoldingMetaSleepTime), new DecreaseMaxHFileSizeAction(this.decreaseHFileSizeSleepTime, this.tableName), new SplitAllRegionOfTableAction(this.tableName)};
        Action[] actions4 = new Action[]{new DumpClusterStatusAction()};
        return new PolicyBasedChaosMonkey(this.util, new PeriodicRandomActionPolicy(this.action1Period, actions1), new PeriodicRandomActionPolicy(this.action2Period, actions2), new CompositeSequentialPolicy(new DoActionsOncePolicy(this.action3Period, actions3), new PeriodicRandomActionPolicy(this.action3Period, actions3)), new PeriodicRandomActionPolicy(this.action4Period, actions4));
    }

    private void loadProperties() {
        this.action1Period = Long.parseLong(this.properties.getProperty("sdm.action1.period", "60000"));
        this.action2Period = Long.parseLong(this.properties.getProperty("sdm.action2.period", "90000"));
        this.action3Period = Long.parseLong(this.properties.getProperty("sdm.action3.period", "150000"));
        this.action4Period = Long.parseLong(this.properties.getProperty("sdm.action4.period", "90000"));
        this.moveRegionsMaxTime = Long.parseLong(this.properties.getProperty("move.regions.max.time", "600000"));
        this.moveRegionsSleepTime = Long.parseLong(this.properties.getProperty("move.regions.sleep.time", "800"));
        this.moveRandomRegionSleepTime = Long.parseLong(this.properties.getProperty("move.randomregion.sleep.time", "800"));
        this.restartRandomRSSleepTime = Long.parseLong(this.properties.getProperty("restart.random.rs.sleep.time", "60000"));
        this.batchRestartRSSleepTime = Long.parseLong(this.properties.getProperty("batch.restart.rs.sleep.time", "5000"));
        this.batchRestartRSRatio = Float.parseFloat(this.properties.getProperty("batch.restart.rs.ratio", "0.5"));
        this.restartActiveMasterSleepTime = Long.parseLong(this.properties.getProperty("restart.active.master.sleep.time", "5000"));
        this.rollingBatchRestartRSSleepTime = Long.parseLong(this.properties.getProperty("rolling.batch.restart.rs.sleep.time", "5000"));
        this.rollingBatchRestartRSRatio = Float.parseFloat(this.properties.getProperty("rolling.batch.restart.rs.ratio", "1.0"));
        this.restartRsHoldingMetaSleepTime = Long.parseLong(this.properties.getProperty("restart.rs.holding.meta.sleep.time", "35000"));
        this.compactTableRatio = Float.parseFloat(this.properties.getProperty("compact.table.ratio", "0.5"));
        this.compactRandomRegionRatio = Float.parseFloat(this.properties.getProperty("compact.random.region.ratio", "0.6"));
        this.decreaseHFileSizeSleepTime = Long.parseLong(this.properties.getProperty("decrease.hfile.size.sleep.time", "30000"));
    }
}

