/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterManager;
import org.apache.hadoop.hbase.DistributedHBaseCluster;
import org.apache.hadoop.hbase.HBaseCluster;
import org.apache.hadoop.hbase.HBaseClusterManager;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.util.ReflectionUtils;

public class IntegrationTestingUtility
extends HBaseTestingUtility {
    public static final String IS_DISTRIBUTED_CLUSTER = "hbase.test.cluster.distributed";
    private static final String HBASE_CLUSTER_MANAGER_CLASS = "hbase.it.clustermanager.class";
    private static final Class<? extends ClusterManager> DEFAULT_HBASE_CLUSTER_MANAGER_CLASS = HBaseClusterManager.class;

    public IntegrationTestingUtility() {
        this(HBaseConfiguration.create());
    }

    public IntegrationTestingUtility(Configuration conf) {
        super(conf);
    }

    public void initializeCluster(int numSlaves) throws Exception {
        if (this.isDistributedCluster()) {
            this.createDistributedHBaseCluster();
            this.checkNodeCount(numSlaves);
        } else {
            this.startMiniCluster(numSlaves);
        }
    }

    public void checkNodeCount(int numSlaves) throws Exception {
        HBaseCluster cluster = this.getHBaseClusterInterface();
        if (cluster.getClusterMetrics().getLiveServerMetrics().size() < numSlaves) {
            throw new Exception("Cluster does not have enough nodes:" + numSlaves);
        }
    }

    public void restoreCluster() throws IOException {
        if (this.isDistributedCluster()) {
            this.getHBaseClusterInterface().restoreInitialStatus();
        } else {
            try {
                this.shutdownMiniCluster();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    public static void setUseDistributedCluster(Configuration conf) {
        conf.setBoolean(IS_DISTRIBUTED_CLUSTER, true);
        System.setProperty(IS_DISTRIBUTED_CLUSTER, "true");
    }

    public boolean isDistributedCluster() {
        Configuration conf = this.getConfiguration();
        boolean isDistributedCluster = false;
        isDistributedCluster = Boolean.parseBoolean(System.getProperty(IS_DISTRIBUTED_CLUSTER, "false"));
        if (!isDistributedCluster) {
            isDistributedCluster = conf.getBoolean(IS_DISTRIBUTED_CLUSTER, false);
        }
        return isDistributedCluster;
    }

    public void createDistributedHBaseCluster() throws IOException {
        Configuration conf = this.getConfiguration();
        if (conf.get("original.defaultFS") != null) {
            conf.set("fs.defaultFS", conf.get("original.defaultFS"));
        }
        if (conf.get("original.hbase.dir") != null) {
            conf.set("hbase.rootdir", conf.get("original.hbase.dir"));
        }
        LOG.debug("Setting {} to {} since it is a distributed cluster", (Object)"hbase.rootdir", (Object)conf.get("hbase.rootdir"));
        Class clusterManagerClass = conf.getClass(HBASE_CLUSTER_MANAGER_CLASS, DEFAULT_HBASE_CLUSTER_MANAGER_CLASS, ClusterManager.class);
        ClusterManager clusterManager = (ClusterManager)ReflectionUtils.newInstance((Class)clusterManagerClass, (Configuration)conf);
        this.setHBaseCluster(new DistributedHBaseCluster(conf, clusterManager));
        this.getAdmin();
    }
}

