/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import ch.cern.hbase.thirdparty.com.google.gson.Gson;
import ch.cern.hbase.thirdparty.com.google.gson.JsonElement;
import ch.cern.hbase.thirdparty.com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.xml.ws.http.HTTPException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.ClusterManager;
import org.apache.hadoop.hbase.HBaseClusterManager;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.util.GsonUtil;
import org.apache.hadoop.util.ReflectionUtils;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RESTApiClusterManager
extends Configured
implements ClusterManager {
    private static final String REST_API_CLUSTER_MANAGER_HOSTNAME = "hbase.it.clustermanager.restapi.hostname";
    private static final String REST_API_CLUSTER_MANAGER_USERNAME = "hbase.it.clustermanager.restapi.username";
    private static final String REST_API_CLUSTER_MANAGER_PASSWORD = "hbase.it.clustermanager.restapi.password";
    private static final String REST_API_CLUSTER_MANAGER_CLUSTER_NAME = "hbase.it.clustermanager.restapi.clustername";
    private static final Gson GSON = GsonUtil.createGson().create();
    private static final String DEFAULT_SERVER_HOSTNAME = "http://localhost:7180";
    private static final String DEFAULT_SERVER_USERNAME = "admin";
    private static final String DEFAULT_SERVER_PASSWORD = "admin";
    private static final String DEFAULT_CLUSTER_NAME = "Cluster 1";
    private String serverHostname;
    private String serverUsername;
    private String serverPassword;
    private String clusterName;
    private static final String API_VERSION = "v6";
    private Client client = ClientBuilder.newClient();
    private ClusterManager hBaseClusterManager = (ClusterManager)ReflectionUtils.newInstance(HBaseClusterManager.class, (Configuration)new IntegrationTestingUtility().getConfiguration());
    private static final Logger LOG = LoggerFactory.getLogger(RESTApiClusterManager.class);
    private static Map<ClusterManager.ServiceType, Service> roleServiceType = new HashMap<ClusterManager.ServiceType, Service>();

    RESTApiClusterManager() {
    }

    public void setConf(Configuration conf) {
        super.setConf(conf);
        if (conf == null) {
            return;
        }
        this.serverHostname = conf.get(REST_API_CLUSTER_MANAGER_HOSTNAME, DEFAULT_SERVER_HOSTNAME);
        this.serverUsername = conf.get(REST_API_CLUSTER_MANAGER_USERNAME, "admin");
        this.serverPassword = conf.get(REST_API_CLUSTER_MANAGER_PASSWORD, "admin");
        this.clusterName = conf.get(REST_API_CLUSTER_MANAGER_CLUSTER_NAME, DEFAULT_CLUSTER_NAME);
        this.client.register((Object)HttpAuthenticationFeature.basic((String)this.serverUsername, (String)this.serverPassword));
    }

    @Override
    public void start(ClusterManager.ServiceType service, String hostname, int port) throws IOException {
        this.performClusterManagerCommand(service, hostname, RoleCommand.START);
    }

    @Override
    public void stop(ClusterManager.ServiceType service, String hostname, int port) throws IOException {
        this.performClusterManagerCommand(service, hostname, RoleCommand.STOP);
    }

    @Override
    public void restart(ClusterManager.ServiceType service, String hostname, int port) throws IOException {
        this.performClusterManagerCommand(service, hostname, RoleCommand.RESTART);
    }

    @Override
    public boolean isRunning(ClusterManager.ServiceType service, String hostname, int port) throws IOException {
        String serviceName = this.getServiceName(roleServiceType.get((Object)service));
        String hostId = this.getHostId(hostname);
        String roleState = this.getRoleState(serviceName, service.toString(), hostId);
        String healthSummary = this.getHealthSummary(serviceName, service.toString(), hostId);
        boolean isRunning = false;
        if ("STARTED".equals(roleState) && "GOOD".equals(healthSummary)) {
            isRunning = true;
        }
        return isRunning;
    }

    @Override
    public void kill(ClusterManager.ServiceType service, String hostname, int port) throws IOException {
        this.hBaseClusterManager.kill(service, hostname, port);
    }

    @Override
    public void suspend(ClusterManager.ServiceType service, String hostname, int port) throws IOException {
        this.hBaseClusterManager.suspend(service, hostname, port);
    }

    @Override
    public void resume(ClusterManager.ServiceType service, String hostname, int port) throws IOException {
        this.hBaseClusterManager.resume(service, hostname, port);
    }

    private void performClusterManagerCommand(ClusterManager.ServiceType role, String hostname, RoleCommand command) throws IOException {
        LOG.info("Performing " + (Object)((Object)command) + " command against " + (Object)((Object)role) + " on " + hostname + "...");
        String serviceName = this.getServiceName(roleServiceType.get((Object)role));
        String hostId = this.getHostId(hostname);
        String roleName = this.getRoleName(serviceName, role.toString(), hostId);
        this.doRoleCommand(serviceName, roleName, command);
    }

    private void doRoleCommand(String serviceName, String roleName, RoleCommand roleCommand) {
        URI uri = UriBuilder.fromUri((String)this.serverHostname).path("api").path(API_VERSION).path("clusters").path(this.clusterName).path("services").path(serviceName).path("roleCommands").path(roleCommand.toString()).build(new Object[0]);
        String body = "{ \"items\": [ \"" + roleName + "\" ] }";
        LOG.info("Executing POST against " + uri + " with body " + body + "...");
        WebTarget webTarget = this.client.target(uri);
        Invocation.Builder invocationBuilder = webTarget.request(new String[]{"application/json"});
        Response response = invocationBuilder.post(Entity.json((Object)body));
        int statusCode = response.getStatus();
        if (statusCode != Response.Status.OK.getStatusCode()) {
            throw new HTTPException(statusCode);
        }
    }

    private String getHealthSummary(String serviceName, String roleType, String hostId) throws IOException {
        return this.getRolePropertyValue(serviceName, roleType, hostId, "healthSummary");
    }

    private String getHostId(String hostname) throws IOException {
        String hostId = null;
        URI uri = UriBuilder.fromUri((String)this.serverHostname).path("api").path(API_VERSION).path("hosts").build(new Object[0]);
        JsonElement hosts = this.getJsonNodeFromURIGet(uri);
        if (hosts != null) {
            for (JsonElement host : hosts.getAsJsonArray()) {
                if (!host.getAsJsonObject().get("hostname").getAsString().equals(hostname)) continue;
                hostId = host.getAsJsonObject().get("hostId").getAsString();
                break;
            }
        } else {
            hostId = null;
        }
        return hostId;
    }

    private JsonElement getJsonNodeFromURIGet(URI uri) throws IOException {
        LOG.info("Executing GET against " + uri + "...");
        WebTarget webTarget = this.client.target(uri);
        Invocation.Builder invocationBuilder = webTarget.request(new String[]{"application/json"});
        Response response = invocationBuilder.get();
        int statusCode = response.getStatus();
        if (statusCode != Response.Status.OK.getStatusCode()) {
            throw new HTTPException(statusCode);
        }
        return GSON.toJsonTree(response.readEntity(String.class)).getAsJsonObject().get("items");
    }

    private String getRoleName(String serviceName, String roleType, String hostId) throws IOException {
        return this.getRolePropertyValue(serviceName, roleType, hostId, "name");
    }

    private String getRolePropertyValue(String serviceName, String roleType, String hostId, String property) throws IOException {
        String roleValue = null;
        URI uri = UriBuilder.fromUri((String)this.serverHostname).path("api").path(API_VERSION).path("clusters").path(this.clusterName).path("services").path(serviceName).path("roles").build(new Object[0]);
        JsonElement roles = this.getJsonNodeFromURIGet(uri);
        if (roles != null) {
            for (JsonElement role : roles.getAsJsonArray()) {
                JsonObject roleObj = role.getAsJsonObject();
                if (!roleObj.get("hostRef").getAsJsonObject().get("hostId").getAsString().equals(hostId) || !roleObj.get("type").getAsString().toLowerCase(Locale.ROOT).equals(roleType.toLowerCase(Locale.ROOT))) continue;
                roleValue = roleObj.get(property).getAsString();
                break;
            }
        }
        return roleValue;
    }

    private String getRoleState(String serviceName, String roleType, String hostId) throws IOException {
        return this.getRolePropertyValue(serviceName, roleType, hostId, "roleState");
    }

    private String getServiceName(Service service) throws IOException {
        String serviceName = null;
        URI uri = UriBuilder.fromUri((String)this.serverHostname).path("api").path(API_VERSION).path("clusters").path(this.clusterName).path("services").build(new Object[0]);
        JsonElement services = this.getJsonNodeFromURIGet(uri);
        if (services != null) {
            for (JsonElement serviceEntry : services.getAsJsonArray()) {
                if (!serviceEntry.getAsJsonObject().get("type").getAsString().equals(service.toString())) continue;
                serviceName = serviceEntry.getAsJsonObject().get("name").getAsString();
                break;
            }
        }
        return serviceName;
    }

    static {
        roleServiceType.put(ClusterManager.ServiceType.HADOOP_NAMENODE, Service.HDFS);
        roleServiceType.put(ClusterManager.ServiceType.HADOOP_DATANODE, Service.HDFS);
        roleServiceType.put(ClusterManager.ServiceType.HADOOP_JOBTRACKER, Service.MAPREDUCE);
        roleServiceType.put(ClusterManager.ServiceType.HADOOP_TASKTRACKER, Service.MAPREDUCE);
        roleServiceType.put(ClusterManager.ServiceType.HBASE_MASTER, Service.HBASE);
        roleServiceType.put(ClusterManager.ServiceType.HBASE_REGIONSERVER, Service.HBASE);
    }

    private static enum Service {
        HBASE,
        HDFS,
        MAPREDUCE;

    }

    private static enum RoleCommand {
        START,
        STOP,
        RESTART;


        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

