/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.chaos.actions.RestartActionBaseAction;
import org.apache.hadoop.hbase.chaos.monkies.PolicyBasedChaosMonkey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchRestartRsAction
extends RestartActionBaseAction {
    float ratio;
    private static final Logger LOG = LoggerFactory.getLogger(BatchRestartRsAction.class);

    public BatchRestartRsAction(long sleepTime, float ratio) {
        super(sleepTime);
        this.ratio = ratio;
    }

    @Override
    public void perform() throws Exception {
        LOG.info(String.format("Performing action: Batch restarting %d%% of region servers", (int)(this.ratio * 100.0f)));
        List<ServerName> selectedServers = PolicyBasedChaosMonkey.selectRandomItems(this.getCurrentServers(), this.ratio);
        HashSet<ServerName> killedServers = new HashSet<ServerName>();
        for (ServerName server : selectedServers) {
            if (this.context.isStopping()) break;
            LOG.info("Killing region server:" + server);
            this.cluster.killRegionServer(server);
            killedServers.add(server);
        }
        for (ServerName server : killedServers) {
            this.cluster.waitForRegionServerToStop(server, 60000L);
        }
        LOG.info("Killed " + killedServers.size() + " region servers. Reported num of rs:" + this.cluster.getClusterMetrics().getLiveServerMetrics().size());
        this.sleep(this.sleepTime);
        for (ServerName server : killedServers) {
            LOG.info("Starting region server:" + server.getHostname());
            this.cluster.startRegionServer(server.getHostname(), server.getPort());
        }
        for (ServerName server : killedServers) {
            this.cluster.waitForRegionServerToStart(server.getHostname(), server.getPort(), 60000L);
        }
        LOG.info("Started " + killedServers.size() + " region servers. Reported num of rs:" + this.cluster.getClusterMetrics().getLiveServerMetrics().size());
    }
}

