/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.io.compress.Compressor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeCompressionAction
extends Action {
    private final TableName tableName;
    private final Random random;
    private static final Logger LOG = LoggerFactory.getLogger(ChangeCompressionAction.class);

    public ChangeCompressionAction(TableName tableName) {
        this.tableName = tableName;
        this.random = new Random();
    }

    @Override
    public void perform() throws IOException {
        Compression.Algorithm algo;
        Compression.Algorithm[] possibleAlgos = Compression.Algorithm.values();
        while (true) {
            algo = possibleAlgos[this.random.nextInt(possibleAlgos.length)];
            try {
                Compressor c = algo.getCompressor();
                algo.returnCompressor(c);
            }
            catch (Throwable t) {
                LOG.info("Performing action: Changing compression algorithms to " + algo + " is not supported, pick another one");
                continue;
            }
            break;
        }
        Compression.Algorithm chosenAlgo = algo;
        LOG.debug("Performing action: Changing compression algorithms on " + this.tableName.getNameAsString() + " to " + chosenAlgo);
        this.modifyAllTableColumns(this.tableName, (ColumnFamilyDescriptorBuilder columnFamilyDescriptorBuilder) -> {
            if (this.random.nextBoolean()) {
                columnFamilyDescriptorBuilder.setCompactionCompressionType(chosenAlgo);
            } else {
                columnFamilyDescriptorBuilder.setCompressionType(chosenAlgo);
            }
        });
    }
}

