/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeVersionsAction
extends Action {
    private final TableName tableName;
    private static final Logger LOG = LoggerFactory.getLogger(ChangeVersionsAction.class);
    private Random random;

    public ChangeVersionsAction(TableName tableName) {
        this.tableName = tableName;
        this.random = new Random();
    }

    @Override
    public void perform() throws IOException {
        int versions = this.random.nextInt(3) + 1;
        LOG.debug("Performing action: Changing versions on " + this.tableName + " to " + versions);
        this.modifyAllTableColumns(this.tableName, (ColumnFamilyDescriptorBuilder columnBuilder) -> columnBuilder.setMinVersions(versions).setMaxVersions(versions));
        LOG.debug("Performing action: Just changed versions on " + this.tableName);
    }
}

