/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.RandomUtils;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.chaos.actions.RestartActionBaseAction;
import org.apache.hadoop.hbase.util.RegionMover;
import org.apache.hadoop.util.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GracefulRollingRestartRsAction
extends RestartActionBaseAction {
    private static final Logger LOG = LoggerFactory.getLogger(GracefulRollingRestartRsAction.class);

    public GracefulRollingRestartRsAction(long sleepTime) {
        super(sleepTime);
    }

    @Override
    public void perform() throws Exception {
        LOG.info("Performing action: Rolling restarting non-master region servers");
        List<ServerName> selectedServers = this.selectServers();
        LOG.info("Disabling balancer to make unloading possible");
        this.setBalancer(false, true);
        for (ServerName server : selectedServers) {
            String rsName = server.getAddress().toString();
            try (RegionMover rm = new RegionMover.RegionMoverBuilder(rsName, this.getConf()).ack(true).build();){
                LOG.info("Unloading {}", (Object)server);
                rm.unload();
                LOG.info("Restarting {}", (Object)server);
                this.gracefulRestartRs(server, this.sleepTime);
                LOG.info("Loading {}", (Object)server);
                rm.load();
            }
            catch (Shell.ExitCodeException e) {
                LOG.info("Problem restarting but presume successful; code={}", (Object)e.getExitCode(), (Object)e);
            }
            this.sleep(RandomUtils.nextInt((int)0, (int)((int)this.sleepTime)));
        }
        LOG.info("Enabling balancer");
        this.setBalancer(true, true);
    }

    protected List<ServerName> selectServers() throws IOException {
        return Arrays.asList(this.getCurrentServers());
    }
}

