/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.io.IOException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.util.Threads;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestartActionBaseAction
extends Action {
    private static final Logger LOG = LoggerFactory.getLogger(RestartActionBaseAction.class);
    long sleepTime;

    public RestartActionBaseAction(long sleepTime) {
        this.sleepTime = sleepTime;
    }

    void sleep(long sleepTime) {
        LOG.info("Sleeping for:" + sleepTime);
        Threads.sleep((long)sleepTime);
    }

    void restartMaster(ServerName server, long sleepTime) throws IOException {
        sleepTime = Math.max(sleepTime, 1000L);
        if (this.context.isStopping()) {
            return;
        }
        LOG.info("Killing master: {}", (Object)server);
        this.killMaster(server);
        this.sleep(sleepTime);
        LOG.info("Starting master: {}", (Object)server);
        this.startMaster(server);
    }

    void gracefulRestartRs(ServerName server, long sleepTime) throws IOException {
        sleepTime = Math.max(sleepTime, 1000L);
        if (this.context.isStopping()) {
            return;
        }
        LOG.info("Stopping region server: {}", (Object)server);
        this.stopRs(server);
        this.sleep(sleepTime);
        LOG.info("Starting region server: {}", (Object)server);
        this.startRs(server);
    }

    void restartRs(ServerName server, long sleepTime) throws IOException {
        sleepTime = Math.max(sleepTime, 1000L);
        if (this.context.isStopping()) {
            return;
        }
        LOG.info("Killing region server: {}", (Object)server);
        this.killRs(server);
        this.sleep(sleepTime);
        LOG.info("Starting region server: {}", (Object)server);
        this.startRs(server);
    }

    void restartZKNode(ServerName server, long sleepTime) throws IOException {
        sleepTime = Math.max(sleepTime, 1000L);
        if (this.context.isStopping()) {
            return;
        }
        LOG.info("Killing zookeeper node: {}", (Object)server);
        this.killZKNode(server);
        this.sleep(sleepTime);
        LOG.info("Starting zookeeper node: {}", (Object)server);
        this.startZKNode(server);
    }

    void restartDataNode(ServerName server, long sleepTime) throws IOException {
        sleepTime = Math.max(sleepTime, 1000L);
        if (this.context.isStopping()) {
            return;
        }
        LOG.info("Killing data node: {}", (Object)server);
        this.killDataNode(server);
        this.sleep(sleepTime);
        LOG.info("Starting data node: {}", (Object)server);
        this.startDataNode(server);
    }

    void restartNameNode(ServerName server, long sleepTime) throws IOException {
        sleepTime = Math.max(sleepTime, 1000L);
        if (this.context.isStopping()) {
            return;
        }
        LOG.info("Killing name node: {}", (Object)server);
        this.killNameNode(server);
        this.sleep(sleepTime);
        LOG.info("Starting name node: {}", (Object)server);
        this.startNameNode(server);
    }
}

