/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.factories;

import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.chaos.actions.CorruptDataFilesAction;
import org.apache.hadoop.hbase.chaos.actions.DeleteDataFilesAction;
import org.apache.hadoop.hbase.chaos.actions.DumpClusterStatusAction;
import org.apache.hadoop.hbase.chaos.factories.MonkeyFactory;
import org.apache.hadoop.hbase.chaos.monkies.ChaosMonkey;
import org.apache.hadoop.hbase.chaos.monkies.PolicyBasedChaosMonkey;
import org.apache.hadoop.hbase.chaos.policies.PeriodicRandomActionPolicy;

public class DataIssuesMonkeyFactory
extends MonkeyFactory {
    private long action1Period;
    private long action2Period;
    private float chanceToAct;

    @Override
    public ChaosMonkey build() {
        this.loadProperties();
        Action[] actions1 = new Action[]{new DeleteDataFilesAction(this.chanceToAct), new CorruptDataFilesAction(this.chanceToAct)};
        Action[] actions2 = new Action[]{new DumpClusterStatusAction()};
        return new PolicyBasedChaosMonkey(this.util, new PeriodicRandomActionPolicy(this.action1Period, actions1), new PeriodicRandomActionPolicy(this.action2Period, actions2));
    }

    private void loadProperties() {
        this.action1Period = Long.parseLong(this.properties.getProperty("sdm.action1.period", "60000"));
        this.action2Period = Long.parseLong(this.properties.getProperty("sdm.action2.period", "90000"));
        this.chanceToAct = Float.parseFloat(this.properties.getProperty("data.issue.chance", "0.01"));
    }
}

