/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.util;

import ch.cern.hbase.thirdparty.com.google.common.base.Preconditions;
import ch.cern.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.chaos.util.ChaosMonkeyRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Monkeys
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(Monkeys.class);
    private final Configuration conf;
    private final ChaosMonkeyRunner monkeyRunner;
    private final Runnable runner;
    private final ExecutorService executor;

    public Monkeys() {
        this(HBaseConfiguration.create());
    }

    public Monkeys(Configuration conf) {
        this.conf = (Configuration)Preconditions.checkNotNull((Object)conf, (Object)"Should specify a configuration");
        this.monkeyRunner = new ChaosMonkeyRunner();
        this.runner = () -> {
            try {
                this.monkeyRunner.getAndStartMonkey();
            }
            catch (Exception e) {
                LOG.error("Exception occurred when running chaos monkeys: ", (Throwable)e);
            }
        };
        this.executor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ChaosMonkey").build());
        IntegrationTestingUtility.setUseDistributedCluster(this.conf);
    }

    public void addResource(Configuration otherConf) {
        this.conf.addResource(otherConf);
        this.monkeyRunner.setConf(this.conf);
    }

    public void addResource(String otherConf) {
        this.conf.addResource(otherConf);
        this.monkeyRunner.setConf(this.conf);
    }

    public void startChaos() {
        this.executor.execute(this.runner);
        LOG.info("Chaos monkeys are running.");
    }

    public void stopChaos() {
        this.monkeyRunner.stopRunner();
        LOG.info("Chaos monkeys are stopped.");
    }

    @Override
    public void close() throws IOException {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.warn("Interruption occurred while stopping chaos monkeys " + e);
        }
    }
}

