/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hbase.ArrayBackedTag;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.HadoopShims;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.PerformanceEvaluation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.TagUtil;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.mapreduce.CellSerialization;
import org.apache.hadoop.hbase.mapreduce.CellSortReducer;
import org.apache.hadoop.hbase.mapreduce.HFileOutputFormat2;
import org.apache.hadoop.hbase.mapreduce.MultiTableHFileOutputFormat;
import org.apache.hadoop.hbase.mapreduce.MutationSerialization;
import org.apache.hadoop.hbase.mapreduce.NMapInputFormat;
import org.apache.hadoop.hbase.mapreduce.ResultSerialization;
import org.apache.hadoop.hbase.mapreduce.SimpleTotalOrderPartitioner;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.TestHRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.VerySlowMapReduceTests;
import org.apache.hadoop.hbase.tool.LoadIncrementalHFiles;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={VerySlowMapReduceTests.class, LargeTests.class})
public class TestCellBasedHFileOutputFormat2 {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCellBasedHFileOutputFormat2.class);
    private static final int ROWSPERSPLIT = 1024;
    public static final byte[] FAMILY_NAME = TestHRegionFileSystem.FAMILY_NAME;
    private static final byte[][] FAMILIES = new byte[][]{Bytes.add((byte[])FAMILY_NAME, (byte[])Bytes.toBytes((String)"-A")), Bytes.add((byte[])FAMILY_NAME, (byte[])Bytes.toBytes((String)"-B"))};
    private static final TableName[] TABLE_NAMES = (TableName[])Stream.of("TestTable", "TestTable2", "TestTable3").map(TableName::valueOf).toArray(TableName[]::new);
    private HBaseTestingUtility util = new HBaseTestingUtility();
    private static final Logger LOG = LoggerFactory.getLogger(TestCellBasedHFileOutputFormat2.class);

    private void setupRandomGeneratorMapper(Job job, boolean putSortReducer) {
        if (putSortReducer) {
            job.setInputFormatClass(NMapInputFormat.class);
            job.setMapperClass(RandomPutGeneratingMapper.class);
            job.setMapOutputKeyClass(ImmutableBytesWritable.class);
            job.setMapOutputValueClass(Put.class);
        } else {
            job.setInputFormatClass(NMapInputFormat.class);
            job.setMapperClass(RandomKVGeneratingMapper.class);
            job.setMapOutputKeyClass(ImmutableBytesWritable.class);
            job.setMapOutputValueClass(KeyValue.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Ignore(value="Goes zombie too frequently; needs work. See HBASE-14563")
    @Test
    public void test_LATEST_TIMESTAMP_isReplaced() throws Exception {
        Path dir;
        Configuration conf;
        block3: {
            conf = new Configuration(this.util.getConfiguration());
            RecordWriter writer = null;
            TaskAttemptContext context = null;
            dir = this.util.getDataTestDir("test_LATEST_TIMESTAMP_isReplaced");
            try {
                Job job = new Job(conf);
                FileOutputFormat.setOutputPath((Job)job, (Path)dir);
                context = this.createTestTaskAttemptContext(job);
                HFileOutputFormat2 hof = new HFileOutputFormat2();
                writer = hof.getRecordWriter(context);
                byte[] b = Bytes.toBytes((String)"b");
                KeyValue kv = new KeyValue(b, b, b);
                KeyValue original = kv.clone();
                writer.write((Object)new ImmutableBytesWritable(), (Object)kv);
                Assert.assertFalse((boolean)original.equals((Object)kv));
                Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneRow((Cell)original), (byte[])CellUtil.cloneRow((Cell)kv)));
                Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneFamily((Cell)original), (byte[])CellUtil.cloneFamily((Cell)kv)));
                Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneQualifier((Cell)original), (byte[])CellUtil.cloneQualifier((Cell)kv)));
                Assert.assertNotSame((Object)original.getTimestamp(), (Object)kv.getTimestamp());
                Assert.assertNotSame((Object)Long.MAX_VALUE, (Object)kv.getTimestamp());
                kv = new KeyValue(b, b, b, kv.getTimestamp() - 1L, b);
                original = kv.clone();
                writer.write((Object)new ImmutableBytesWritable(), (Object)kv);
                Assert.assertTrue((boolean)original.equals((Object)kv));
                if (writer == null || context == null) break block3;
            }
            catch (Throwable throwable) {
                if (writer != null && context != null) {
                    writer.close(context);
                }
                dir.getFileSystem(conf).delete(dir, true);
                throw throwable;
            }
            writer.close(context);
        }
        dir.getFileSystem(conf).delete(dir, true);
    }

    private TaskAttemptContext createTestTaskAttemptContext(Job job) throws Exception {
        HadoopShims hadoop = (HadoopShims)CompatibilitySingletonFactory.getInstance(HadoopShims.class);
        TaskAttemptContext context = (TaskAttemptContext)hadoop.createTestTaskAttemptContext((Object)job, "attempt_201402131733_0001_m_000000_0");
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Ignore(value="Goes zombie too frequently; needs work. See HBASE-14563")
    @Test
    public void test_TIMERANGE() throws Exception {
        Path dir;
        Configuration conf;
        block3: {
            conf = new Configuration(this.util.getConfiguration());
            RecordWriter writer = null;
            TaskAttemptContext context = null;
            dir = this.util.getDataTestDir("test_TIMERANGE_present");
            LOG.info("Timerange dir writing to dir: " + dir);
            try {
                Job job = new Job(conf);
                FileOutputFormat.setOutputPath((Job)job, (Path)dir);
                context = this.createTestTaskAttemptContext(job);
                HFileOutputFormat2 hof = new HFileOutputFormat2();
                writer = hof.getRecordWriter(context);
                byte[] b = Bytes.toBytes((String)"b");
                KeyValue kv = new KeyValue(b, b, b, 2000L, b);
                KeyValue original = kv.clone();
                writer.write((Object)new ImmutableBytesWritable(), (Object)kv);
                Assert.assertEquals((Object)original, (Object)kv);
                kv = new KeyValue(b, b, b, 1000L, b);
                original = kv.clone();
                writer.write((Object)new ImmutableBytesWritable(), (Object)kv);
                Assert.assertEquals((Object)original, (Object)kv);
                writer.close(context);
                FileSystem fs = FileSystem.get((Configuration)conf);
                Path attemptDirectory = hof.getDefaultWorkFile(context, "").getParent();
                FileStatus[] sub1 = fs.listStatus(attemptDirectory);
                FileStatus[] file = fs.listStatus(sub1[0].getPath());
                HFile.Reader rd = HFile.createReader((FileSystem)fs, (Path)file[0].getPath(), (CacheConfig)new CacheConfig(conf), (boolean)true, (Configuration)conf);
                Map finfo = rd.loadFileInfo();
                byte[] range = (byte[])finfo.get("TIMERANGE".getBytes("UTF-8"));
                Assert.assertNotNull((Object)range);
                TimeRangeTracker timeRangeTracker = TimeRangeTracker.parseFrom((byte[])range);
                LOG.info(timeRangeTracker.getMin() + "...." + timeRangeTracker.getMax());
                Assert.assertEquals((long)1000L, (long)timeRangeTracker.getMin());
                Assert.assertEquals((long)2000L, (long)timeRangeTracker.getMax());
                rd.close();
                if (writer == null || context == null) break block3;
            }
            catch (Throwable throwable) {
                if (writer != null && context != null) {
                    writer.close(context);
                }
                dir.getFileSystem(conf).delete(dir, true);
                throw throwable;
            }
            writer.close(context);
        }
        dir.getFileSystem(conf).delete(dir, true);
    }

    @Ignore(value="Goes zombie too frequently; needs work. See HBASE-14563")
    @Test
    public void testWritingPEData() throws Exception {
        Configuration conf = this.util.getConfiguration();
        Path testDir = this.util.getDataTestDirOnTestFS("testWritingPEData");
        FileSystem fs = testDir.getFileSystem(conf);
        conf.setInt("mapreduce.task.io.sort.mb", 20);
        conf.setLong("hbase.hregion.max.filesize", 65536L);
        Job job = new Job(conf, "testWritingPEData");
        this.setupRandomGeneratorMapper(job, false);
        byte[] startKey = new byte[10];
        byte[] endKey = new byte[10];
        Arrays.fill(startKey, (byte)0);
        Arrays.fill(endKey, (byte)-1);
        job.setPartitionerClass(SimpleTotalOrderPartitioner.class);
        SimpleTotalOrderPartitioner.setStartKey((Configuration)job.getConfiguration(), (byte[])startKey);
        SimpleTotalOrderPartitioner.setEndKey((Configuration)job.getConfiguration(), (byte[])endKey);
        job.setReducerClass(CellSortReducer.class);
        job.setOutputFormatClass(HFileOutputFormat2.class);
        job.setNumReduceTasks(4);
        job.getConfiguration().setStrings("io.serializations", new String[]{conf.get("io.serializations"), MutationSerialization.class.getName(), ResultSerialization.class.getName(), CellSerialization.class.getName()});
        FileOutputFormat.setOutputPath((Job)job, (Path)testDir);
        Assert.assertTrue((boolean)job.waitForCompletion(false));
        FileStatus[] files = fs.listStatus(testDir);
        Assert.assertTrue((files.length > 0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void test_WritingTagData() throws Exception {
        Path dir;
        Configuration conf;
        block5: {
            conf = new Configuration(this.util.getConfiguration());
            String HFILE_FORMAT_VERSION_CONF_KEY = "hfile.format.version";
            conf.setInt("hfile.format.version", 3);
            RecordWriter writer = null;
            TaskAttemptContext context = null;
            dir = this.util.getDataTestDir("WritingTagData");
            try {
                conf.set("hbase.mapreduce.hfileoutputformat.table.name", TABLE_NAMES[0].getNameAsString());
                conf.setBoolean("hbase.bulkload.locality.sensitive.enabled", false);
                Job job = new Job(conf);
                FileOutputFormat.setOutputPath((Job)job, (Path)dir);
                context = this.createTestTaskAttemptContext(job);
                HFileOutputFormat2 hof = new HFileOutputFormat2();
                writer = hof.getRecordWriter(context);
                byte[] b = Bytes.toBytes((String)"b");
                ArrayList<ArrayBackedTag> tags = new ArrayList<ArrayBackedTag>();
                tags.add(new ArrayBackedTag(8, Bytes.toBytes((int)978670)));
                KeyValue kv = new KeyValue(b, b, b, Long.MAX_VALUE, b, tags);
                writer.write((Object)new ImmutableBytesWritable(), (Object)kv);
                writer.close(context);
                writer = null;
                FileSystem fs = dir.getFileSystem(conf);
                RemoteIterator iterator = fs.listFiles(dir, true);
                while (iterator.hasNext()) {
                    LocatedFileStatus keyFileStatus = (LocatedFileStatus)iterator.next();
                    HFile.Reader reader = HFile.createReader((FileSystem)fs, (Path)keyFileStatus.getPath(), (CacheConfig)new CacheConfig(conf), (boolean)true, (Configuration)conf);
                    HFileScanner scanner = reader.getScanner(false, false, false);
                    scanner.seekTo();
                    Cell cell = scanner.getCell();
                    List tagsFromCell = TagUtil.asList((byte[])cell.getTagsArray(), (int)cell.getTagsOffset(), (int)cell.getTagsLength());
                    Assert.assertTrue((tagsFromCell.size() > 0 ? 1 : 0) != 0);
                    for (Tag tag : tagsFromCell) {
                        Assert.assertTrue((tag.getType() == 8 ? 1 : 0) != 0);
                    }
                }
                if (writer == null || context == null) break block5;
            }
            catch (Throwable throwable) {
                if (writer != null && context != null) {
                    writer.close(context);
                }
                dir.getFileSystem(conf).delete(dir, true);
                throw throwable;
            }
            writer.close(context);
        }
        dir.getFileSystem(conf).delete(dir, true);
    }

    @Ignore(value="Goes zombie too frequently; needs work. See HBASE-14563")
    @Test
    public void testJobConfiguration() throws Exception {
        Configuration conf = new Configuration(this.util.getConfiguration());
        conf.set("hbase.fs.tmp.dir", this.util.getDataTestDir("testJobConfiguration").toString());
        Job job = new Job(conf);
        job.setWorkingDirectory(this.util.getDataTestDir("testJobConfiguration"));
        Table table = (Table)Mockito.mock(Table.class);
        RegionLocator regionLocator = (RegionLocator)Mockito.mock(RegionLocator.class);
        this.setupMockStartKeys(regionLocator);
        this.setupMockTableName(regionLocator);
        HFileOutputFormat2.configureIncrementalLoad((Job)job, (TableDescriptor)table.getTableDescriptor(), (RegionLocator)regionLocator);
        Assert.assertEquals((long)job.getNumReduceTasks(), (long)4L);
    }

    private byte[][] generateRandomStartKeys(int numKeys) {
        Random random = new Random();
        byte[][] ret = new byte[numKeys][];
        ret[0] = HConstants.EMPTY_BYTE_ARRAY;
        for (int i = 1; i < numKeys; ++i) {
            ret[i] = PerformanceEvaluation.generateData(random, 1000);
        }
        return ret;
    }

    private byte[][] generateRandomSplitKeys(int numKeys) {
        Random random = new Random();
        byte[][] ret = new byte[numKeys][];
        for (int i = 0; i < numKeys; ++i) {
            ret[i] = PerformanceEvaluation.generateData(random, 1000);
        }
        return ret;
    }

    @Ignore(value="Goes zombie too frequently; needs work. See HBASE-14563")
    @Test
    public void testMRIncrementalLoad() throws Exception {
        LOG.info("\nStarting test testMRIncrementalLoad\n");
        this.doIncrementalLoadTest(false, false, false, "testMRIncrementalLoad");
    }

    @Ignore(value="Goes zombie too frequently; needs work. See HBASE-14563")
    @Test
    public void testMRIncrementalLoadWithSplit() throws Exception {
        LOG.info("\nStarting test testMRIncrementalLoadWithSplit\n");
        this.doIncrementalLoadTest(true, false, false, "testMRIncrementalLoadWithSplit");
    }

    @Ignore(value="Goes zombie too frequently; needs work. See HBASE-14563")
    @Test
    public void testMRIncrementalLoadWithLocality() throws Exception {
        LOG.info("\nStarting test testMRIncrementalLoadWithLocality\n");
        this.doIncrementalLoadTest(false, true, false, "testMRIncrementalLoadWithLocality1");
        this.doIncrementalLoadTest(true, true, false, "testMRIncrementalLoadWithLocality2");
    }

    @Test
    public void testMRIncrementalLoadWithPutSortReducer() throws Exception {
        LOG.info("\nStarting test testMRIncrementalLoadWithPutSortReducer\n");
        this.doIncrementalLoadTest(false, false, true, "testMRIncrementalLoadWithPutSortReducer");
    }

    private void doIncrementalLoadTest(boolean shouldChangeRegions, boolean shouldKeepLocality, boolean putSortReducer, String tableStr) throws Exception {
        this.doIncrementalLoadTest(shouldChangeRegions, shouldKeepLocality, putSortReducer, Arrays.asList(tableStr));
    }

    @Test
    public void testMultiMRIncrementalLoadWithPutSortReducer() throws Exception {
        LOG.info("\nStarting test testMultiMRIncrementalLoadWithPutSortReducer\n");
        this.doIncrementalLoadTest(false, false, true, Arrays.stream(TABLE_NAMES).map(TableName::getNameAsString).collect(Collectors.toList()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void doIncrementalLoadTest(boolean shouldChangeRegions, boolean shouldKeepLocality, boolean putSortReducer, List<String> tableStr) throws Exception {
        void var13_17;
        void var16_25;
        FileStatus[] tableSingle2;
        this.util = new HBaseTestingUtility();
        Configuration conf = this.util.getConfiguration();
        conf.setBoolean("hbase.bulkload.locality.sensitive.enabled", shouldKeepLocality);
        int hostCount = 1;
        int regionNum = 5;
        if (shouldKeepLocality) {
            hostCount = 3;
            regionNum = 20;
        }
        String[] hostnames = new String[hostCount];
        for (int i = 0; i < hostCount; ++i) {
            hostnames[i] = "datanode_" + i;
        }
        this.util.startMiniCluster(1, hostCount, hostnames);
        HashMap<String, Table> allTables = new HashMap<String, Table>(tableStr.size());
        ArrayList<HFileOutputFormat2.TableInfo> tableInfo = new ArrayList<HFileOutputFormat2.TableInfo>(tableStr.size());
        boolean writeMultipleTables = tableStr.size() > 1;
        for (String string : tableStr) {
            byte[][] splitKeys = this.generateRandomSplitKeys(regionNum - 1);
            TableName tableName = TableName.valueOf((String)string);
            Table table = this.util.createTable(tableName, FAMILIES, splitKeys);
            RegionLocator r = this.util.getConnection().getRegionLocator(tableName);
            Assert.assertEquals((String)"Should start with empty table", (long)0L, (long)this.util.countRows(table));
            int numRegions = r.getStartKeys().length;
            Assert.assertEquals((String)("Should make " + regionNum + " regions"), (long)numRegions, (long)regionNum);
            allTables.put(string, table);
            tableInfo.add(new HFileOutputFormat2.TableInfo((TableDescriptor)table.getTableDescriptor(), r));
        }
        Path testDir = this.util.getDataTestDirOnTestFS("testLocalMRIncrementalLoad");
        this.runIncrementalPELoad(conf, tableInfo, testDir, putSortReducer);
        for (FileStatus[] tableSingle2 : allTables.values()) {
            Assert.assertEquals((String)"HFOF should not touch actual table", (long)0L, (long)this.util.countRows((Table)tableSingle2));
        }
        boolean bl = false;
        tableSingle2 = testDir.getFileSystem(conf).listStatus(testDir);
        int tableName = tableSingle2.length;
        boolean bl2 = false;
        while (var16_25 < tableName) {
            block29: {
                Path tablePath;
                block28: {
                    FileStatus tf = tableSingle2[var16_25];
                    tablePath = testDir;
                    if (!writeMultipleTables) break block28;
                    if (!allTables.containsKey(tf.getPath().getName())) break block29;
                    ++var13_17;
                    tablePath = tf.getPath();
                }
                int dir = 0;
                for (FileStatus f : tablePath.getFileSystem(conf).listStatus(tablePath)) {
                    for (byte[] byArray : FAMILIES) {
                        if (!Bytes.toString((byte[])byArray).equals(f.getPath().getName())) continue;
                        ++dir;
                    }
                }
                Assert.assertEquals((String)"Column family not found in FS.", (long)FAMILIES.length, (long)dir);
            }
            ++var16_25;
        }
        if (writeMultipleTables) {
            Assert.assertEquals((String)"Dir for all input tables not created", (long)((long)var13_17), (long)allTables.size());
        }
        Admin admin = this.util.getConnection().getAdmin();
        try {
            if (shouldChangeRegions) {
                Table chosenTable = (Table)allTables.values().iterator().next();
                LOG.info("Changing regions in table " + chosenTable.getName().getNameAsString());
                admin.disableTable(chosenTable.getName());
                this.util.waitUntilNoRegionsInTransition();
                this.util.deleteTable(chosenTable.getName());
                byte[][] byArray = this.generateRandomSplitKeys(14);
                Table table = this.util.createTable(chosenTable.getName(), FAMILIES, byArray);
                while (this.util.getConnection().getRegionLocator(chosenTable.getName()).getAllRegionLocations().size() != 15 || !admin.isTableAvailable(table.getName())) {
                    Thread.sleep(200L);
                    LOG.info("Waiting for new region assignment to happen");
                }
            }
            for (HFileOutputFormat2.TableInfo tableInfo2 : tableInfo) {
                Object object;
                Path tableDir = testDir;
                String tableNameStr = tableInfo2.getHTableDescriptor().getNameAsString();
                LOG.info("Running LoadIncrementalHFiles on table" + tableNameStr);
                if (writeMultipleTables) {
                    tableDir = new Path(testDir, tableNameStr);
                }
                Table currentTable = (Table)allTables.get(tableNameStr);
                TableName currentTableName = currentTable.getName();
                new LoadIncrementalHFiles(conf).doBulkLoad(tableDir, admin, currentTable, tableInfo2.getRegionLocator());
                int expectedRows = 0;
                if (putSortReducer) {
                    Assert.assertEquals((String)"LoadIncrementalHFiles should put expected data in table", (long)expectedRows, (long)this.util.countRows(currentTable));
                } else {
                    expectedRows = NMapInputFormat.getNumMapTasks(conf) * 1024;
                    Assert.assertEquals((String)"LoadIncrementalHFiles should put expected data in table", (long)expectedRows, (long)this.util.countRows(currentTable));
                    Scan scan = new Scan();
                    ResultScanner results = currentTable.getScanner(scan);
                    object = results.iterator();
                    while (object.hasNext()) {
                        Result res = (Result)object.next();
                        Assert.assertEquals((long)FAMILIES.length, (long)res.rawCells().length);
                        Cell first = res.rawCells()[0];
                        for (Cell kv : res.rawCells()) {
                            Assert.assertTrue((boolean)CellUtil.matchingRows((Cell)first, (Cell)kv));
                            Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneValue((Cell)first), (byte[])CellUtil.cloneValue((Cell)kv)));
                        }
                    }
                    results.close();
                }
                String tableDigestBefore = this.util.checksumRows(currentTable);
                HDFSBlocksDistribution hbd = new HDFSBlocksDistribution();
                object = this.util.getHBaseCluster().getRegions(currentTableName).iterator();
                while (object.hasNext()) {
                    HRegion region = (HRegion)object.next();
                    hbd.add(region.getHDFSBlocksDistribution());
                }
                for (String string : hostnames) {
                    float locality = hbd.getBlockLocalityIndex(string);
                    LOG.info("locality of [" + (String)string + "]: " + locality);
                    Assert.assertEquals((long)100L, (long)((int)(locality * 100.0f)));
                }
                admin.disableTable(currentTableName);
                while (!admin.isTableDisabled(currentTableName)) {
                    Thread.sleep(200L);
                    LOG.info("Waiting for table to disable");
                }
                admin.enableTable(currentTableName);
                this.util.waitTableAvailable(currentTableName);
                Assert.assertEquals((String)"Data should remain after reopening of regions", (Object)tableDigestBefore, (Object)this.util.checksumRows(currentTable));
            }
        }
        finally {
            for (HFileOutputFormat2.TableInfo tableInfo3 : tableInfo) {
                tableInfo3.getRegionLocator().close();
            }
            for (Map.Entry entry : allTables.entrySet()) {
                ((Table)entry.getValue()).close();
                this.util.deleteTable(((Table)entry.getValue()).getName());
            }
            testDir.getFileSystem(conf).delete(testDir, true);
            this.util.shutdownMiniCluster();
        }
    }

    private void runIncrementalPELoad(Configuration conf, List<HFileOutputFormat2.TableInfo> tableInfo, Path outDir, boolean putSortReducer) throws IOException, InterruptedException, ClassNotFoundException {
        Job job = new Job(conf, "testLocalMRIncrementalLoad");
        job.setWorkingDirectory(this.util.getDataTestDirOnTestFS("runIncrementalPELoad"));
        job.getConfiguration().setStrings("io.serializations", new String[]{conf.get("io.serializations"), MutationSerialization.class.getName(), ResultSerialization.class.getName(), CellSerialization.class.getName()});
        this.setupRandomGeneratorMapper(job, putSortReducer);
        if (tableInfo.size() > 1) {
            MultiTableHFileOutputFormat.configureIncrementalLoad((Job)job, tableInfo);
            int sum = 0;
            for (HFileOutputFormat2.TableInfo tableInfoSingle : tableInfo) {
                sum += tableInfoSingle.getRegionLocator().getAllRegionLocations().size();
            }
            Assert.assertEquals((long)sum, (long)job.getNumReduceTasks());
        } else {
            RegionLocator regionLocator = tableInfo.get(0).getRegionLocator();
            HFileOutputFormat2.configureIncrementalLoad((Job)job, (TableDescriptor)tableInfo.get(0).getHTableDescriptor(), (RegionLocator)regionLocator);
            Assert.assertEquals((long)regionLocator.getAllRegionLocations().size(), (long)job.getNumReduceTasks());
        }
        FileOutputFormat.setOutputPath((Job)job, (Path)outDir);
        Assert.assertFalse((boolean)this.util.getTestFileSystem().exists(outDir));
        Assert.assertTrue((boolean)job.waitForCompletion(true));
    }

    @Ignore(value="Goes zombie too frequently; needs work. See HBASE-14563")
    @Test
    public void testSerializeDeserializeFamilyCompressionMap() throws IOException {
        for (int numCfs = 0; numCfs <= 3; ++numCfs) {
            Configuration conf = new Configuration(this.util.getConfiguration());
            Map<String, Compression.Algorithm> familyToCompression = this.getMockColumnFamiliesForCompression(numCfs);
            Table table = (Table)Mockito.mock(Table.class);
            this.setupMockColumnFamiliesForCompression(table, familyToCompression);
            conf.set("hbase.hfileoutputformat.families.compression", HFileOutputFormat2.serializeColumnFamilyAttribute((Function)HFileOutputFormat2.compressionDetails, Arrays.asList(table.getTableDescriptor())));
            Map retrievedFamilyToCompressionMap = HFileOutputFormat2.createFamilyCompressionMap((Configuration)conf);
            for (Map.Entry<String, Compression.Algorithm> entry : familyToCompression.entrySet()) {
                Assert.assertEquals((String)("Compression configuration incorrect for column family:" + entry.getKey()), (Object)entry.getValue(), retrievedFamilyToCompressionMap.get(entry.getKey().getBytes("UTF-8")));
            }
        }
    }

    private void setupMockColumnFamiliesForCompression(Table table, Map<String, Compression.Algorithm> familyToCompression) throws IOException {
        HTableDescriptor mockTableDescriptor = new HTableDescriptor(TABLE_NAMES[0]);
        for (Map.Entry<String, Compression.Algorithm> entry : familyToCompression.entrySet()) {
            mockTableDescriptor.addFamily(new HColumnDescriptor(entry.getKey()).setMaxVersions(1).setCompressionType(entry.getValue()).setBlockCacheEnabled(false).setTimeToLive(0));
        }
        ((Table)Mockito.doReturn((Object)mockTableDescriptor).when((Object)table)).getTableDescriptor();
    }

    private Map<String, Compression.Algorithm> getMockColumnFamiliesForCompression(int numCfs) {
        HashMap<String, Compression.Algorithm> familyToCompression = new HashMap<String, Compression.Algorithm>();
        if (numCfs-- > 0) {
            familyToCompression.put("Family1!@#!@#&", Compression.Algorithm.LZO);
        }
        if (numCfs-- > 0) {
            familyToCompression.put("Family2=asdads&!AASD", Compression.Algorithm.SNAPPY);
        }
        if (numCfs-- > 0) {
            familyToCompression.put("Family2=asdads&!AASD", Compression.Algorithm.GZ);
        }
        if (numCfs-- > 0) {
            familyToCompression.put("Family3", Compression.Algorithm.NONE);
        }
        return familyToCompression;
    }

    @Ignore(value="Goes zombie too frequently; needs work. See HBASE-14563")
    @Test
    public void testSerializeDeserializeFamilyBloomTypeMap() throws IOException {
        for (int numCfs = 0; numCfs <= 2; ++numCfs) {
            Configuration conf = new Configuration(this.util.getConfiguration());
            Map<String, BloomType> familyToBloomType = this.getMockColumnFamiliesForBloomType(numCfs);
            Table table = (Table)Mockito.mock(Table.class);
            this.setupMockColumnFamiliesForBloomType(table, familyToBloomType);
            conf.set("hbase.hfileoutputformat.families.bloomtype", HFileOutputFormat2.serializeColumnFamilyAttribute((Function)HFileOutputFormat2.bloomTypeDetails, Arrays.asList(table.getTableDescriptor())));
            Map retrievedFamilyToBloomTypeMap = HFileOutputFormat2.createFamilyBloomTypeMap((Configuration)conf);
            for (Map.Entry<String, BloomType> entry : familyToBloomType.entrySet()) {
                Assert.assertEquals((String)("BloomType configuration incorrect for column family:" + entry.getKey()), (Object)entry.getValue(), retrievedFamilyToBloomTypeMap.get(entry.getKey().getBytes("UTF-8")));
            }
        }
    }

    private void setupMockColumnFamiliesForBloomType(Table table, Map<String, BloomType> familyToDataBlockEncoding) throws IOException {
        HTableDescriptor mockTableDescriptor = new HTableDescriptor(TABLE_NAMES[0]);
        for (Map.Entry<String, BloomType> entry : familyToDataBlockEncoding.entrySet()) {
            mockTableDescriptor.addFamily(new HColumnDescriptor(entry.getKey()).setMaxVersions(1).setBloomFilterType(entry.getValue()).setBlockCacheEnabled(false).setTimeToLive(0));
        }
        ((Table)Mockito.doReturn((Object)mockTableDescriptor).when((Object)table)).getTableDescriptor();
    }

    private Map<String, BloomType> getMockColumnFamiliesForBloomType(int numCfs) {
        HashMap<String, BloomType> familyToBloomType = new HashMap<String, BloomType>();
        if (numCfs-- > 0) {
            familyToBloomType.put("Family1!@#!@#&", BloomType.ROW);
        }
        if (numCfs-- > 0) {
            familyToBloomType.put("Family2=asdads&!AASD", BloomType.ROWCOL);
        }
        if (numCfs-- > 0) {
            familyToBloomType.put("Family3", BloomType.NONE);
        }
        return familyToBloomType;
    }

    @Ignore(value="Goes zombie too frequently; needs work. See HBASE-14563")
    @Test
    public void testSerializeDeserializeFamilyBlockSizeMap() throws IOException {
        for (int numCfs = 0; numCfs <= 3; ++numCfs) {
            Configuration conf = new Configuration(this.util.getConfiguration());
            Map<String, Integer> familyToBlockSize = this.getMockColumnFamiliesForBlockSize(numCfs);
            Table table = (Table)Mockito.mock(Table.class);
            this.setupMockColumnFamiliesForBlockSize(table, familyToBlockSize);
            conf.set("hbase.mapreduce.hfileoutputformat.blocksize", HFileOutputFormat2.serializeColumnFamilyAttribute((Function)HFileOutputFormat2.blockSizeDetails, Arrays.asList(table.getTableDescriptor())));
            Map retrievedFamilyToBlockSizeMap = HFileOutputFormat2.createFamilyBlockSizeMap((Configuration)conf);
            for (Map.Entry<String, Integer> entry : familyToBlockSize.entrySet()) {
                Assert.assertEquals((String)("BlockSize configuration incorrect for column family:" + entry.getKey()), (Object)entry.getValue(), retrievedFamilyToBlockSizeMap.get(entry.getKey().getBytes("UTF-8")));
            }
        }
    }

    private void setupMockColumnFamiliesForBlockSize(Table table, Map<String, Integer> familyToDataBlockEncoding) throws IOException {
        HTableDescriptor mockTableDescriptor = new HTableDescriptor(TABLE_NAMES[0]);
        for (Map.Entry<String, Integer> entry : familyToDataBlockEncoding.entrySet()) {
            mockTableDescriptor.addFamily(new HColumnDescriptor(entry.getKey()).setMaxVersions(1).setBlocksize(entry.getValue().intValue()).setBlockCacheEnabled(false).setTimeToLive(0));
        }
        ((Table)Mockito.doReturn((Object)mockTableDescriptor).when((Object)table)).getTableDescriptor();
    }

    private Map<String, Integer> getMockColumnFamiliesForBlockSize(int numCfs) {
        HashMap<String, Integer> familyToBlockSize = new HashMap<String, Integer>();
        if (numCfs-- > 0) {
            familyToBlockSize.put("Family1!@#!@#&", 1234);
        }
        if (numCfs-- > 0) {
            familyToBlockSize.put("Family2=asdads&!AASD", Integer.MAX_VALUE);
        }
        if (numCfs-- > 0) {
            familyToBlockSize.put("Family2=asdads&!AASD", Integer.MAX_VALUE);
        }
        if (numCfs-- > 0) {
            familyToBlockSize.put("Family3", 0);
        }
        return familyToBlockSize;
    }

    @Ignore(value="Goes zombie too frequently; needs work. See HBASE-14563")
    @Test
    public void testSerializeDeserializeFamilyDataBlockEncodingMap() throws IOException {
        for (int numCfs = 0; numCfs <= 3; ++numCfs) {
            Configuration conf = new Configuration(this.util.getConfiguration());
            Map<String, DataBlockEncoding> familyToDataBlockEncoding = this.getMockColumnFamiliesForDataBlockEncoding(numCfs);
            Table table = (Table)Mockito.mock(Table.class);
            this.setupMockColumnFamiliesForDataBlockEncoding(table, familyToDataBlockEncoding);
            HTableDescriptor tableDescriptor = table.getTableDescriptor();
            conf.set("hbase.mapreduce.hfileoutputformat.families.datablock.encoding", HFileOutputFormat2.serializeColumnFamilyAttribute((Function)HFileOutputFormat2.dataBlockEncodingDetails, Arrays.asList(tableDescriptor)));
            Map retrievedFamilyToDataBlockEncodingMap = HFileOutputFormat2.createFamilyDataBlockEncodingMap((Configuration)conf);
            for (Map.Entry<String, DataBlockEncoding> entry : familyToDataBlockEncoding.entrySet()) {
                Assert.assertEquals((String)("DataBlockEncoding configuration incorrect for column family:" + entry.getKey()), (Object)entry.getValue(), retrievedFamilyToDataBlockEncodingMap.get(entry.getKey().getBytes("UTF-8")));
            }
        }
    }

    private void setupMockColumnFamiliesForDataBlockEncoding(Table table, Map<String, DataBlockEncoding> familyToDataBlockEncoding) throws IOException {
        HTableDescriptor mockTableDescriptor = new HTableDescriptor(TABLE_NAMES[0]);
        for (Map.Entry<String, DataBlockEncoding> entry : familyToDataBlockEncoding.entrySet()) {
            mockTableDescriptor.addFamily(new HColumnDescriptor(entry.getKey()).setMaxVersions(1).setDataBlockEncoding(entry.getValue()).setBlockCacheEnabled(false).setTimeToLive(0));
        }
        ((Table)Mockito.doReturn((Object)mockTableDescriptor).when((Object)table)).getTableDescriptor();
    }

    private Map<String, DataBlockEncoding> getMockColumnFamiliesForDataBlockEncoding(int numCfs) {
        HashMap<String, DataBlockEncoding> familyToDataBlockEncoding = new HashMap<String, DataBlockEncoding>();
        if (numCfs-- > 0) {
            familyToDataBlockEncoding.put("Family1!@#!@#&", DataBlockEncoding.DIFF);
        }
        if (numCfs-- > 0) {
            familyToDataBlockEncoding.put("Family2=asdads&!AASD", DataBlockEncoding.FAST_DIFF);
        }
        if (numCfs-- > 0) {
            familyToDataBlockEncoding.put("Family2=asdads&!AASD", DataBlockEncoding.PREFIX);
        }
        if (numCfs-- > 0) {
            familyToDataBlockEncoding.put("Family3", DataBlockEncoding.NONE);
        }
        return familyToDataBlockEncoding;
    }

    private void setupMockStartKeys(RegionLocator table) throws IOException {
        byte[][] mockKeys = new byte[][]{HConstants.EMPTY_BYTE_ARRAY, Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"ggg"), Bytes.toBytes((String)"zzz")};
        ((RegionLocator)Mockito.doReturn((Object)mockKeys).when((Object)table)).getStartKeys();
    }

    private void setupMockTableName(RegionLocator table) throws IOException {
        TableName mockTableName = TableName.valueOf((String)"mock_table");
        ((RegionLocator)Mockito.doReturn((Object)mockTableName).when((Object)table)).getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore(value="Goes zombie too frequently; needs work. See HBASE-14563")
    @Test
    public void testColumnFamilySettings() throws Exception {
        Configuration conf = new Configuration(this.util.getConfiguration());
        RecordWriter writer = null;
        TaskAttemptContext context = null;
        Path dir = this.util.getDataTestDir("testColumnFamilySettings");
        Table table = (Table)Mockito.mock(Table.class);
        RegionLocator regionLocator = (RegionLocator)Mockito.mock(RegionLocator.class);
        HTableDescriptor htd = new HTableDescriptor(TABLE_NAMES[0]);
        ((Table)Mockito.doReturn((Object)htd).when((Object)table)).getTableDescriptor();
        for (HColumnDescriptor hcd : HBaseTestingUtility.generateColumnDescriptors()) {
            htd.addFamily(hcd);
        }
        this.setupMockStartKeys(regionLocator);
        try {
            conf.set("io.seqfile.compression.type", "NONE");
            conf.set("hbase.fs.tmp.dir", dir.toString());
            conf.setBoolean("hbase.bulkload.locality.sensitive.enabled", false);
            Job job = new Job(conf, "testLocalMRIncrementalLoad");
            job.setWorkingDirectory(this.util.getDataTestDirOnTestFS("testColumnFamilySettings"));
            this.setupRandomGeneratorMapper(job, false);
            HFileOutputFormat2.configureIncrementalLoad((Job)job, (TableDescriptor)table.getTableDescriptor(), (RegionLocator)regionLocator);
            FileOutputFormat.setOutputPath((Job)job, (Path)dir);
            context = this.createTestTaskAttemptContext(job);
            HFileOutputFormat2 hof = new HFileOutputFormat2();
            writer = hof.getRecordWriter(context);
            this.writeRandomKeyValues((RecordWriter<ImmutableBytesWritable, Cell>)writer, context, htd.getFamiliesKeys(), 1024);
            writer.close(context);
            FileSystem fs = dir.getFileSystem(conf);
            hof.getOutputCommitter(context).commitTask(context);
            hof.getOutputCommitter(context).commitJob((JobContext)context);
            FileStatus[] families = FSUtils.listStatus((FileSystem)fs, (Path)dir, (PathFilter)new FSUtils.FamilyDirFilter(fs));
            Assert.assertEquals((long)htd.getFamilies().size(), (long)families.length);
            for (FileStatus f : families) {
                String familyStr = f.getPath().getName();
                HColumnDescriptor hcd = htd.getFamily(Bytes.toBytes((String)familyStr));
                Path dataFilePath = fs.listStatus(f.getPath())[0].getPath();
                HFile.Reader reader = HFile.createReader((FileSystem)fs, (Path)dataFilePath, (CacheConfig)new CacheConfig(conf), (boolean)true, (Configuration)conf);
                Map fileInfo = reader.loadFileInfo();
                byte[] bloomFilter = (byte[])fileInfo.get(HStoreFile.BLOOM_FILTER_TYPE_KEY);
                if (bloomFilter == null) {
                    bloomFilter = Bytes.toBytes((String)"NONE");
                }
                Assert.assertEquals((String)("Incorrect bloom filter used for column family " + familyStr + "(reader: " + reader + ")"), (Object)hcd.getBloomFilterType(), (Object)BloomType.valueOf((String)Bytes.toString((byte[])bloomFilter)));
                Assert.assertEquals((String)("Incorrect compression used for column family " + familyStr + "(reader: " + reader + ")"), (Object)hcd.getCompressionType(), (Object)reader.getFileContext().getCompression());
            }
        }
        finally {
            dir.getFileSystem(conf).delete(dir, true);
        }
    }

    private void writeRandomKeyValues(RecordWriter<ImmutableBytesWritable, Cell> writer, TaskAttemptContext context, Set<byte[]> families, int numRows) throws IOException, InterruptedException {
        byte[] keyBytes = new byte[4];
        int valLength = 10;
        byte[] valBytes = new byte[valLength];
        int taskId = context.getTaskAttemptID().getTaskID().getId();
        assert (taskId < 127) : "Unit tests dont support > 127 tasks!";
        byte[] qualifier = Bytes.toBytes((String)"data");
        Random random = new Random();
        for (int i = 0; i < numRows; ++i) {
            Bytes.putInt((byte[])keyBytes, (int)0, (int)i);
            random.nextBytes(valBytes);
            ImmutableBytesWritable key = new ImmutableBytesWritable(keyBytes);
            for (byte[] family : families) {
                KeyValue kv = new KeyValue(keyBytes, family, qualifier, valBytes);
                writer.write((Object)key, (Object)kv);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore(value="Flakey: See HBASE-9051")
    @Test
    public void testExcludeAllFromMinorCompaction() throws Exception {
        Configuration conf = this.util.getConfiguration();
        conf.setInt("hbase.hstore.compaction.min", 2);
        this.generateRandomStartKeys(5);
        this.util.startMiniCluster();
        try (Connection conn = ConnectionFactory.createConnection();
             Admin admin = conn.getAdmin();
             Table table = this.util.createTable(TABLE_NAMES[0], FAMILIES);){
            RegionLocator locator = conn.getRegionLocator(TABLE_NAMES[0]);
            Throwable throwable = null;
            try {
                DistributedFileSystem fs = this.util.getDFSCluster().getFileSystem();
                Assert.assertEquals((String)"Should start with empty table", (long)0L, (long)this.util.countRows(table));
                Path storePath = new Path(FSUtils.getTableDir((Path)FSUtils.getRootDir((Configuration)conf), (TableName)TABLE_NAMES[0]), new Path(((HRegionInfo)admin.getTableRegions(TABLE_NAMES[0]).get(0)).getEncodedName(), Bytes.toString((byte[])FAMILIES[0])));
                Assert.assertEquals((long)0L, (long)fs.listStatus(storePath).length);
                conf.setBoolean("hbase.mapreduce.hfileoutputformat.compaction.exclude", true);
                for (int i = 0; i < 2; ++i) {
                    Path testDir = this.util.getDataTestDirOnTestFS("testExcludeAllFromMinorCompaction_" + i);
                    this.runIncrementalPELoad(conf, Arrays.asList(new HFileOutputFormat2.TableInfo((TableDescriptor)table.getTableDescriptor(), conn.getRegionLocator(TABLE_NAMES[0]))), testDir, false);
                    new LoadIncrementalHFiles(conf).doBulkLoad(testDir, admin, table, locator);
                }
                int expectedRows = 2 * NMapInputFormat.getNumMapTasks(conf) * 1024;
                Assert.assertEquals((String)"LoadIncrementalHFiles should put expected data in table", (long)expectedRows, (long)this.util.countRows(table));
                Assert.assertEquals((long)2L, (long)fs.listStatus(storePath).length);
                admin.compact(TABLE_NAMES[0]);
                try {
                    this.quickPoll(new Callable<Boolean>((FileSystem)fs, storePath){
                        final /* synthetic */ FileSystem val$fs;
                        final /* synthetic */ Path val$storePath;
                        {
                            this.val$fs = fileSystem;
                            this.val$storePath = path;
                        }

                        @Override
                        public Boolean call() throws Exception {
                            List regions = TestCellBasedHFileOutputFormat2.this.util.getMiniHBaseCluster().getRegions(TABLE_NAMES[0]);
                            for (HRegion region : regions) {
                                for (HStore store : region.getStores()) {
                                    store.closeAndArchiveCompactedFiles();
                                }
                            }
                            return this.val$fs.listStatus(this.val$storePath).length == 1;
                        }
                    }, 5000);
                    throw new IOException("SF# = " + fs.listStatus(storePath).length);
                }
                catch (AssertionError assertionError) {
                    admin.majorCompact(TABLE_NAMES[0]);
                    this.quickPoll(new Callable<Boolean>((FileSystem)fs, storePath){
                        final /* synthetic */ FileSystem val$fs;
                        final /* synthetic */ Path val$storePath;
                        {
                            this.val$fs = fileSystem;
                            this.val$storePath = path;
                        }

                        @Override
                        public Boolean call() throws Exception {
                            List regions = TestCellBasedHFileOutputFormat2.this.util.getMiniHBaseCluster().getRegions(TABLE_NAMES[0]);
                            for (HRegion region : regions) {
                                for (HStore store : region.getStores()) {
                                    store.closeAndArchiveCompactedFiles();
                                }
                            }
                            return this.val$fs.listStatus(this.val$storePath).length == 1;
                        }
                    }, 5000);
                    if (locator != null) {
                        if (throwable != null) {
                            try {
                                locator.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        } else {
                            locator.close();
                        }
                    }
                }
            }
            catch (Throwable throwable3) {
                try {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (locator != null) {
                        if (throwable != null) {
                            try {
                                locator.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            locator.close();
                        }
                    }
                    throw throwable4;
                }
            }
        }
        finally {
            this.util.shutdownMiniCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore(value="Goes zombie too frequently; needs work. See HBASE-14563")
    @Test
    public void testExcludeMinorCompaction() throws Exception {
        Configuration conf = this.util.getConfiguration();
        conf.setInt("hbase.hstore.compaction.min", 2);
        this.generateRandomStartKeys(5);
        this.util.startMiniCluster();
        try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);){
            Admin admin = conn.getAdmin();
            Throwable throwable = null;
            try {
                Path testDir = this.util.getDataTestDirOnTestFS("testExcludeMinorCompaction");
                DistributedFileSystem fs = this.util.getDFSCluster().getFileSystem();
                Table table = this.util.createTable(TABLE_NAMES[0], FAMILIES);
                Assert.assertEquals((String)"Should start with empty table", (long)0L, (long)this.util.countRows(table));
                Path storePath = new Path(FSUtils.getTableDir((Path)FSUtils.getRootDir((Configuration)conf), (TableName)TABLE_NAMES[0]), new Path(((HRegionInfo)admin.getTableRegions(TABLE_NAMES[0]).get(0)).getEncodedName(), Bytes.toString((byte[])FAMILIES[0])));
                Assert.assertEquals((long)0L, (long)fs.listStatus(storePath).length);
                Put p = new Put(Bytes.toBytes((String)"test"));
                p.addColumn(FAMILIES[0], Bytes.toBytes((String)"1"), Bytes.toBytes((String)"1"));
                table.put(p);
                admin.flush(TABLE_NAMES[0]);
                Assert.assertEquals((long)1L, (long)this.util.countRows(table));
                this.quickPoll(new Callable<Boolean>((FileSystem)fs, storePath){
                    final /* synthetic */ FileSystem val$fs;
                    final /* synthetic */ Path val$storePath;
                    {
                        this.val$fs = fileSystem;
                        this.val$storePath = path;
                    }

                    @Override
                    public Boolean call() throws Exception {
                        return this.val$fs.listStatus(this.val$storePath).length == 1;
                    }
                }, 5000);
                conf.setBoolean("hbase.mapreduce.hfileoutputformat.compaction.exclude", true);
                RegionLocator regionLocator = conn.getRegionLocator(TABLE_NAMES[0]);
                this.runIncrementalPELoad(conf, Arrays.asList(new HFileOutputFormat2.TableInfo((TableDescriptor)table.getTableDescriptor(), regionLocator)), testDir, false);
                new LoadIncrementalHFiles(conf).doBulkLoad(testDir, admin, table, regionLocator);
                int expectedRows = NMapInputFormat.getNumMapTasks(conf) * 1024;
                Assert.assertEquals((String)"LoadIncrementalHFiles should put expected data in table", (long)(expectedRows + 1), (long)this.util.countRows(table));
                Assert.assertEquals((long)2L, (long)fs.listStatus(storePath).length);
                admin.compact(TABLE_NAMES[0]);
                try {
                    this.quickPoll(new Callable<Boolean>((FileSystem)fs, storePath){
                        final /* synthetic */ FileSystem val$fs;
                        final /* synthetic */ Path val$storePath;
                        {
                            this.val$fs = fileSystem;
                            this.val$storePath = path;
                        }

                        @Override
                        public Boolean call() throws Exception {
                            return this.val$fs.listStatus(this.val$storePath).length == 1;
                        }
                    }, 5000);
                    throw new IOException("SF# = " + fs.listStatus(storePath).length);
                }
                catch (AssertionError assertionError) {
                    admin.majorCompact(TABLE_NAMES[0]);
                    this.quickPoll(new Callable<Boolean>((FileSystem)fs, storePath){
                        final /* synthetic */ FileSystem val$fs;
                        final /* synthetic */ Path val$storePath;
                        {
                            this.val$fs = fileSystem;
                            this.val$storePath = path;
                        }

                        @Override
                        public Boolean call() throws Exception {
                            return this.val$fs.listStatus(this.val$storePath).length == 1;
                        }
                    }, 5000);
                    if (admin != null) {
                        if (throwable != null) {
                            try {
                                admin.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        } else {
                            admin.close();
                        }
                    }
                }
            }
            catch (Throwable throwable3) {
                try {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (admin != null) {
                        if (throwable != null) {
                            try {
                                admin.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            admin.close();
                        }
                    }
                    throw throwable4;
                }
            }
        }
        finally {
            this.util.shutdownMiniCluster();
        }
    }

    private void quickPoll(Callable<Boolean> c, int waitMs) throws Exception {
        int sleepMs = 10;
        int retries = (int)Math.ceil((double)waitMs / (double)sleepMs);
        while (retries-- > 0) {
            if (c.call().booleanValue()) {
                return;
            }
            Thread.sleep(sleepMs);
        }
        Assert.fail();
    }

    public static void main(String[] args) throws Exception {
        new TestCellBasedHFileOutputFormat2().manualTest(args);
    }

    public void manualTest(String[] args) throws Exception {
        block39: {
            Configuration conf = HBaseConfiguration.create();
            this.util = new HBaseTestingUtility(conf);
            if ("newtable".equals(args[0])) {
                TableName tname = TableName.valueOf((String)args[1]);
                byte[][] splitKeys = this.generateRandomSplitKeys(4);
                Table table = this.util.createTable(tname, FAMILIES, splitKeys);
            } else {
                if ("incremental".equals(args[0])) {
                    TableName tname = TableName.valueOf((String)args[1]);
                    try (Connection c = ConnectionFactory.createConnection((Configuration)conf);
                         Admin admin = c.getAdmin();
                         RegionLocator regionLocator = c.getRegionLocator(tname);){
                        Path outDir = new Path("incremental-out");
                        this.runIncrementalPELoad(conf, Arrays.asList(new HFileOutputFormat2.TableInfo((TableDescriptor)admin.getTableDescriptor(tname), regionLocator)), outDir, false);
                        break block39;
                    }
                }
                throw new RuntimeException("usage: TestHFileOutputFormat2 newtable | incremental");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlockStoragePolicy() throws Exception {
        this.util = new HBaseTestingUtility();
        Configuration conf = this.util.getConfiguration();
        conf.set("hbase.hstore.block.storage.policy", "ALL_SSD");
        conf.set("hbase.hstore.block.storage.policy." + Bytes.toString((byte[])HFileOutputFormat2.combineTableNameSuffix((byte[])TABLE_NAMES[0].getName(), (byte[])FAMILIES[0])), "ONE_SSD");
        Path cf1Dir = new Path(this.util.getDataTestDir(), Bytes.toString((byte[])FAMILIES[0]));
        Path cf2Dir = new Path(this.util.getDataTestDir(), Bytes.toString((byte[])FAMILIES[1]));
        this.util.startMiniDFSCluster(3);
        DistributedFileSystem fs = this.util.getDFSCluster().getFileSystem();
        try {
            fs.mkdirs(cf1Dir);
            fs.mkdirs(cf2Dir);
            String spA = this.getStoragePolicyName((FileSystem)fs, cf1Dir);
            String spB = this.getStoragePolicyName((FileSystem)fs, cf2Dir);
            LOG.debug("Storage policy of cf 0: [" + spA + "].");
            LOG.debug("Storage policy of cf 1: [" + spB + "].");
            Assert.assertEquals((Object)"HOT", (Object)spA);
            Assert.assertEquals((Object)"HOT", (Object)spB);
            HFileOutputFormat2.configureStoragePolicy((Configuration)conf, (FileSystem)fs, (byte[])HFileOutputFormat2.combineTableNameSuffix((byte[])TABLE_NAMES[0].getName(), (byte[])FAMILIES[0]), (Path)cf1Dir);
            HFileOutputFormat2.configureStoragePolicy((Configuration)conf, (FileSystem)fs, (byte[])HFileOutputFormat2.combineTableNameSuffix((byte[])TABLE_NAMES[0].getName(), (byte[])FAMILIES[1]), (Path)cf2Dir);
            spA = this.getStoragePolicyName((FileSystem)fs, cf1Dir);
            spB = this.getStoragePolicyName((FileSystem)fs, cf2Dir);
            LOG.debug("Storage policy of cf 0: [" + spA + "].");
            LOG.debug("Storage policy of cf 1: [" + spB + "].");
            Assert.assertNotNull((Object)spA);
            Assert.assertEquals((Object)"ONE_SSD", (Object)spA);
            Assert.assertNotNull((Object)spB);
            Assert.assertEquals((Object)"ALL_SSD", (Object)spB);
        }
        finally {
            fs.delete(cf1Dir, true);
            fs.delete(cf2Dir, true);
            this.util.shutdownMiniDFSCluster();
        }
    }

    private String getStoragePolicyName(FileSystem fs, Path path) {
        try {
            Object blockStoragePolicySpi = ReflectionUtils.invokeMethod((Object)fs, (String)"getStoragePolicy", (Object[])new Object[]{path});
            return (String)ReflectionUtils.invokeMethod((Object)blockStoragePolicySpi, (String)"getName", (Object[])new Object[0]);
        }
        catch (Exception e) {
            String policy;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Failed to get policy directly", (Throwable)e);
            }
            return (policy = this.getStoragePolicyNameForOldHDFSVersion(fs, path)) == null ? "HOT" : policy;
        }
    }

    private String getStoragePolicyNameForOldHDFSVersion(FileSystem fs, Path path) {
        try {
            Field idUnspecified;
            byte storagePolicyId;
            DistributedFileSystem dfs;
            HdfsFileStatus status;
            if (fs instanceof DistributedFileSystem && null != (status = (dfs = (DistributedFileSystem)fs).getClient().getFileInfo(path.toUri().getPath())) && (storagePolicyId = status.getStoragePolicy()) != (idUnspecified = BlockStoragePolicySuite.class.getField("ID_UNSPECIFIED")).getByte(BlockStoragePolicySuite.class)) {
                BlockStoragePolicy[] policies;
                for (BlockStoragePolicy policy : policies = dfs.getStoragePolicies()) {
                    if (policy.getId() != storagePolicyId) continue;
                    return policy.getName();
                }
            }
        }
        catch (Throwable e) {
            LOG.warn("failed to get block storage policy of [" + path + "]", e);
        }
        return null;
    }

    static class RandomPutGeneratingMapper
    extends Mapper<NullWritable, NullWritable, ImmutableBytesWritable, Put> {
        private int keyLength;
        private static final int KEYLEN_DEFAULT = 10;
        private static final String KEYLEN_CONF = "randomkv.key.length";
        private int valLength;
        private static final int VALLEN_DEFAULT = 10;
        private static final String VALLEN_CONF = "randomkv.val.length";
        private static final byte[] QUALIFIER = Bytes.toBytes((String)"data");
        private boolean multiTableMapper = false;
        private TableName[] tables = null;

        RandomPutGeneratingMapper() {
        }

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            super.setup(context);
            Configuration conf = context.getConfiguration();
            this.keyLength = conf.getInt(KEYLEN_CONF, 10);
            this.valLength = conf.getInt(VALLEN_CONF, 10);
            this.multiTableMapper = conf.getBoolean("hbase.mapreduce.use.multi.table.hfileoutputformat", false);
            this.tables = this.multiTableMapper ? TABLE_NAMES : new TableName[]{TABLE_NAMES[0]};
        }

        protected void map(NullWritable n1, NullWritable n2, Mapper.Context context) throws IOException, InterruptedException {
            byte[] keyBytes = new byte[this.keyLength];
            byte[] valBytes = new byte[this.valLength];
            int taskId = context.getTaskAttemptID().getTaskID().getId();
            assert (taskId < 127) : "Unit tests dont support > 127 tasks!";
            Random random = new Random();
            for (int j = 0; j < this.tables.length; ++j) {
                for (int i = 0; i < 1024; ++i) {
                    random.nextBytes(keyBytes);
                    keyBytes[this.keyLength - 1] = (byte)(taskId & 0xFF);
                    random.nextBytes(valBytes);
                    byte[] key = keyBytes;
                    if (this.multiTableMapper) {
                        key = MultiTableHFileOutputFormat.createCompositeKey((byte[])this.tables[j].getName(), (byte[])keyBytes);
                    }
                    for (byte[] family : FAMILIES) {
                        Put p = new Put(keyBytes);
                        p.addColumn(family, QUALIFIER, valBytes);
                        p.setTTL(1L);
                        context.write((Object)new ImmutableBytesWritable(key), (Object)p);
                    }
                }
            }
        }
    }

    static class RandomKVGeneratingMapper
    extends Mapper<NullWritable, NullWritable, ImmutableBytesWritable, Cell> {
        private int keyLength;
        private static final int KEYLEN_DEFAULT = 10;
        private static final String KEYLEN_CONF = "randomkv.key.length";
        private int valLength;
        private static final int VALLEN_DEFAULT = 10;
        private static final String VALLEN_CONF = "randomkv.val.length";
        private static final byte[] QUALIFIER = Bytes.toBytes((String)"data");
        private boolean multiTableMapper = false;
        private TableName[] tables = null;

        RandomKVGeneratingMapper() {
        }

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            super.setup(context);
            Configuration conf = context.getConfiguration();
            this.keyLength = conf.getInt(KEYLEN_CONF, 10);
            this.valLength = conf.getInt(VALLEN_CONF, 10);
            this.multiTableMapper = conf.getBoolean("hbase.mapreduce.use.multi.table.hfileoutputformat", false);
            this.tables = this.multiTableMapper ? TABLE_NAMES : new TableName[]{TABLE_NAMES[0]};
        }

        protected void map(NullWritable n1, NullWritable n2, Mapper.Context context) throws IOException, InterruptedException {
            byte[] keyBytes = new byte[this.keyLength];
            byte[] valBytes = new byte[this.valLength];
            int taskId = context.getTaskAttemptID().getTaskID().getId();
            assert (taskId < 127) : "Unit tests dont support > 127 tasks!";
            Random random = new Random();
            for (int j = 0; j < this.tables.length; ++j) {
                for (int i = 0; i < 1024; ++i) {
                    random.nextBytes(keyBytes);
                    keyBytes[this.keyLength - 1] = (byte)(taskId & 0xFF);
                    random.nextBytes(valBytes);
                    byte[] key = keyBytes;
                    if (this.multiTableMapper) {
                        key = MultiTableHFileOutputFormat.createCompositeKey((byte[])this.tables[j].getName(), (byte[])keyBytes);
                    }
                    for (byte[] family : FAMILIES) {
                        KeyValue kv = new KeyValue(keyBytes, family, QUALIFIER, valBytes);
                        context.write((Object)new ImmutableBytesWritable(key), (Object)kv);
                    }
                }
            }
        }
    }
}

