/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.mapreduce.MapreduceTestingShim;
import org.apache.hadoop.hbase.mapreduce.WALInputFormat;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.testclassification.MapReduceTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MapReduceTests.class, MediumTests.class})
public class TestWALRecordReader {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestWALRecordReader.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestWALRecordReader.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static Configuration conf;
    private static FileSystem fs;
    private static Path hbaseDir;
    private static FileSystem walFs;
    private static Path walRootDir;
    static final TableName tableName;
    private static final byte[] rowName;
    static final RegionInfo info;
    private static final byte[] family;
    private static final byte[] value;
    private static Path logDir;
    protected MultiVersionConcurrencyControl mvcc;
    protected static NavigableMap<byte[], Integer> scopes;

    private static String getName() {
        return "TestWALRecordReader";
    }

    @Before
    public void setUp() throws Exception {
        fs.delete(hbaseDir, true);
        walFs.delete(walRootDir, true);
        this.mvcc = new MultiVersionConcurrencyControl();
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        conf.setInt("dfs.blocksize", 0x100000);
        conf.setInt("dfs.replication", 1);
        TEST_UTIL.startMiniDFSCluster(1);
        conf = TEST_UTIL.getConfiguration();
        fs = TEST_UTIL.getDFSCluster().getFileSystem();
        hbaseDir = TEST_UTIL.createRootDir();
        walRootDir = TEST_UTIL.createWALRootDir();
        walFs = FSUtils.getWALFileSystem((Configuration)conf);
        logDir = new Path(walRootDir, "WALs");
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        fs.delete(hbaseDir, true);
        walFs.delete(walRootDir, true);
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testPartialRead() throws Exception {
        WALFactory walfactory = new WALFactory(conf, TestWALRecordReader.getName());
        WAL log = walfactory.getWAL(info);
        long ts = System.currentTimeMillis();
        WALEdit edit = new WALEdit();
        edit.add((Cell)new KeyValue(rowName, family, Bytes.toBytes((String)"1"), ts, value));
        log.append(info, this.getWalKeyImpl(ts, scopes), edit, true);
        edit = new WALEdit();
        edit.add((Cell)new KeyValue(rowName, family, Bytes.toBytes((String)"2"), ts + 1L, value));
        log.append(info, this.getWalKeyImpl(ts + 1L, scopes), edit, true);
        log.sync();
        LOG.info("Before 1st WAL roll " + log.toString());
        log.rollWriter();
        LOG.info("Past 1st WAL roll " + log.toString());
        Thread.sleep(1L);
        long ts1 = System.currentTimeMillis();
        edit = new WALEdit();
        edit.add((Cell)new KeyValue(rowName, family, Bytes.toBytes((String)"3"), ts1 + 1L, value));
        log.append(info, this.getWalKeyImpl(ts1 + 1L, scopes), edit, true);
        edit = new WALEdit();
        edit.add((Cell)new KeyValue(rowName, family, Bytes.toBytes((String)"4"), ts1 + 2L, value));
        log.append(info, this.getWalKeyImpl(ts1 + 2L, scopes), edit, true);
        log.sync();
        log.shutdown();
        walfactory.shutdown();
        LOG.info("Closed WAL " + log.toString());
        WALInputFormat input = new WALInputFormat();
        Configuration jobConf = new Configuration(conf);
        jobConf.set("mapreduce.input.fileinputformat.inputdir", logDir.toString());
        jobConf.setLong("wal.end.time", ts);
        List splits = input.getSplits(MapreduceTestingShim.createJobContext((Configuration)jobConf));
        Assert.assertEquals((long)1L, (long)splits.size());
        this.testSplit((InputSplit)splits.get(0), new byte[][]{Bytes.toBytes((String)"1")});
        jobConf.setLong("wal.start.time", ts + 1L);
        jobConf.setLong("wal.end.time", ts1 + 1L);
        splits = input.getSplits(MapreduceTestingShim.createJobContext((Configuration)jobConf));
        Assert.assertEquals((long)2L, (long)splits.size());
        this.testSplit((InputSplit)splits.get(0), new byte[][]{Bytes.toBytes((String)"2")});
        this.testSplit((InputSplit)splits.get(1), new byte[][]{Bytes.toBytes((String)"3")});
    }

    @Test
    public void testWALRecordReader() throws Exception {
        WALFactory walfactory = new WALFactory(conf, TestWALRecordReader.getName());
        WAL log = walfactory.getWAL(info);
        byte[] value = Bytes.toBytes((String)"value");
        WALEdit edit = new WALEdit();
        edit.add((Cell)new KeyValue(rowName, family, Bytes.toBytes((String)"1"), System.currentTimeMillis(), value));
        long txid = log.append(info, this.getWalKeyImpl(System.currentTimeMillis(), scopes), edit, true);
        log.sync(txid);
        Thread.sleep(1L);
        long secondTs = System.currentTimeMillis();
        log.rollWriter();
        edit = new WALEdit();
        edit.add((Cell)new KeyValue(rowName, family, Bytes.toBytes((String)"2"), System.currentTimeMillis(), value));
        txid = log.append(info, this.getWalKeyImpl(System.currentTimeMillis(), scopes), edit, true);
        log.sync(txid);
        log.shutdown();
        walfactory.shutdown();
        long thirdTs = System.currentTimeMillis();
        WALInputFormat input = new WALInputFormat();
        Configuration jobConf = new Configuration(conf);
        jobConf.set("mapreduce.input.fileinputformat.inputdir", logDir.toString());
        List splits = input.getSplits(MapreduceTestingShim.createJobContext((Configuration)jobConf));
        Assert.assertEquals((long)2L, (long)splits.size());
        this.testSplit((InputSplit)splits.get(0), new byte[][]{Bytes.toBytes((String)"1")});
        this.testSplit((InputSplit)splits.get(1), new byte[][]{Bytes.toBytes((String)"2")});
        jobConf.setLong("wal.end.time", secondTs - 1L);
        splits = input.getSplits(MapreduceTestingShim.createJobContext((Configuration)jobConf));
        Assert.assertEquals((long)1L, (long)splits.size());
        this.testSplit((InputSplit)splits.get(0), new byte[][]{Bytes.toBytes((String)"1")});
        jobConf.setLong("wal.end.time", Long.MAX_VALUE);
        jobConf.setLong("wal.start.time", thirdTs);
        splits = input.getSplits(MapreduceTestingShim.createJobContext((Configuration)jobConf));
        Assert.assertEquals((long)2L, (long)splits.size());
        this.testSplit((InputSplit)splits.get(0), new byte[0][]);
        this.testSplit((InputSplit)splits.get(1), new byte[0][]);
    }

    protected WALKeyImpl getWalKeyImpl(long time, NavigableMap<byte[], Integer> scopes) {
        return new WALKeyImpl(info.getEncodedNameAsBytes(), tableName, time, this.mvcc, scopes);
    }

    private WALInputFormat.WALRecordReader<WALKey> getReader() {
        return new WALInputFormat.WALKeyRecordReader();
    }

    private void testSplit(InputSplit split, byte[] ... columns) throws Exception {
        WALInputFormat.WALRecordReader<WALKey> reader = this.getReader();
        reader.initialize(split, MapReduceTestUtil.createDummyMapTaskAttemptContext((Configuration)conf));
        for (byte[] column : columns) {
            Assert.assertTrue((boolean)reader.nextKeyValue());
            Cell cell = (Cell)reader.getCurrentValue().getCells().get(0);
            if (Bytes.equals((byte[])column, (int)0, (int)column.length, (byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength())) continue;
            Assert.assertTrue((String)("expected [" + Bytes.toString((byte[])column) + "], actual [" + Bytes.toString((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength()) + "]"), (boolean)false);
        }
        Assert.assertFalse((boolean)reader.nextKeyValue());
        reader.close();
    }

    static {
        tableName = TableName.valueOf((String)TestWALRecordReader.getName());
        rowName = tableName.getName();
        info = RegionInfoBuilder.newBuilder((TableName)tableName).build();
        family = Bytes.toBytes((String)"column");
        value = Bytes.toBytes((String)"value");
        scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
    }
}

