/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.mapreduce.MultiTableSnapshotInputFormatImpl;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hbase.thirdparty.com.google.common.base.MoreObjects;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Matchers;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestMultiTableSnapshotInputFormatImpl {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMultiTableSnapshotInputFormatImpl.class);
    private MultiTableSnapshotInputFormatImpl subject;
    private Map<String, Collection<Scan>> snapshotScans;
    private Path restoreDir;
    private Configuration conf;
    private Path rootDir;

    @Before
    public void setUp() throws Exception {
        this.subject = (MultiTableSnapshotInputFormatImpl)Mockito.spy((Object)new MultiTableSnapshotInputFormatImpl());
        ((MultiTableSnapshotInputFormatImpl)Mockito.doNothing().when((Object)this.subject)).restoreSnapshot((Configuration)Matchers.any(), (String)Matchers.any(), (Path)Matchers.any(), (Path)Matchers.any(), (FileSystem)Matchers.any());
        this.conf = new Configuration();
        this.rootDir = new Path("file:///test-root-dir");
        FSUtils.setRootDir((Configuration)this.conf, (Path)this.rootDir);
        this.snapshotScans = ImmutableMap.of((Object)"snapshot1", (Object)ImmutableList.of((Object)new Scan(Bytes.toBytes((String)"1"), Bytes.toBytes((String)"2"))), (Object)"snapshot2", (Object)ImmutableList.of((Object)new Scan(Bytes.toBytes((String)"3"), Bytes.toBytes((String)"4")), (Object)new Scan(Bytes.toBytes((String)"5"), Bytes.toBytes((String)"6"))));
        this.restoreDir = new Path(FSUtils.getRootDir((Configuration)this.conf), "restore-dir");
    }

    public void callSetInput() throws IOException {
        this.subject.setInput(this.conf, this.snapshotScans, this.restoreDir);
    }

    public Map<String, Collection<ScanWithEquals>> toScanWithEquals(Map<String, Collection<Scan>> snapshotScans) throws IOException {
        HashMap rtn = Maps.newHashMap();
        for (Map.Entry<String, Collection<Scan>> entry : snapshotScans.entrySet()) {
            ArrayList scans = Lists.newArrayList();
            for (Scan scan : entry.getValue()) {
                scans.add(new ScanWithEquals(scan));
            }
            rtn.put(entry.getKey(), scans);
        }
        return rtn;
    }

    @Test
    public void testSetInputSetsSnapshotToScans() throws Exception {
        this.callSetInput();
        Map actual = this.subject.getSnapshotsToScans(this.conf);
        Map<String, Collection<ScanWithEquals>> actualWithEquals = this.toScanWithEquals(actual);
        Map<String, Collection<ScanWithEquals>> expectedWithEquals = this.toScanWithEquals(this.snapshotScans);
        Assert.assertEquals(expectedWithEquals, actualWithEquals);
    }

    @Test
    public void testSetInputPushesRestoreDirectories() throws Exception {
        this.callSetInput();
        Map restoreDirs = this.subject.getSnapshotDirs(this.conf);
        Assert.assertEquals(this.snapshotScans.keySet(), restoreDirs.keySet());
    }

    @Test
    public void testSetInputCreatesRestoreDirectoriesUnderRootRestoreDir() throws Exception {
        this.callSetInput();
        Map restoreDirs = this.subject.getSnapshotDirs(this.conf);
        for (Path snapshotDir : restoreDirs.values()) {
            Assert.assertEquals((String)("Expected " + snapshotDir + " to be a child of " + this.restoreDir), (Object)this.restoreDir, (Object)snapshotDir.getParent());
        }
    }

    @Test
    public void testSetInputRestoresSnapshots() throws Exception {
        this.callSetInput();
        Map snapshotDirs = this.subject.getSnapshotDirs(this.conf);
        for (Map.Entry entry : snapshotDirs.entrySet()) {
            ((MultiTableSnapshotInputFormatImpl)Mockito.verify((Object)this.subject)).restoreSnapshot((Configuration)Matchers.eq((Object)this.conf), (String)Matchers.eq(entry.getKey()), (Path)Matchers.eq((Object)this.rootDir), (Path)Matchers.eq(entry.getValue()), (FileSystem)Matchers.any());
        }
    }

    public static class ScanWithEquals {
        private final String startRow;
        private final String stopRow;

        public ScanWithEquals(Scan scan) throws IOException {
            this.startRow = Bytes.toStringBinary((byte[])scan.getStartRow());
            this.stopRow = Bytes.toStringBinary((byte[])scan.getStopRow());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ScanWithEquals)) {
                return false;
            }
            ScanWithEquals otherScan = (ScanWithEquals)obj;
            return Objects.equals(this.startRow, otherScan.startRow) && Objects.equals(this.stopRow, otherScan.stopRow);
        }

        public int hashCode() {
            return Objects.hash(this.startRow, this.stopRow);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("startRow", (Object)this.startRow).add("stopRow", (Object)this.stopRow).toString();
        }
    }
}

