/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapred;

import ch.cern.hbase.thirdparty.com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapred.TableMap;
import org.apache.hadoop.hbase.mapred.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.MultiTableInputFormatTestBase;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.VerySlowMapReduceTests;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={VerySlowMapReduceTests.class, LargeTests.class})
public class TestMultiTableSnapshotInputFormat
extends org.apache.hadoop.hbase.mapreduce.TestMultiTableSnapshotInputFormat {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMultiTableSnapshotInputFormat.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestMultiTableSnapshotInputFormat.class);

    @Override
    protected void runJob(String jobName, Configuration c, List<Scan> scans) throws IOException, InterruptedException, ClassNotFoundException {
        JobConf job = new JobConf(TEST_UTIL.getConfiguration());
        job.setJobName(jobName);
        job.setMapperClass(Mapper.class);
        job.setReducerClass(Reducer.class);
        TableMapReduceUtil.initMultiTableSnapshotMapperJob(this.getSnapshotScanMapping(scans), Mapper.class, ImmutableBytesWritable.class, ImmutableBytesWritable.class, (JobConf)job, (boolean)true, (Path)this.restoreDir);
        TableMapReduceUtil.addDependencyJars((JobConf)job);
        job.setReducerClass(Reducer.class);
        job.setNumReduceTasks(1);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)new Path(job.getJobName()));
        LOG.info("Started " + job.getJobName());
        RunningJob runningJob = JobClient.runJob((JobConf)job);
        runningJob.waitForCompletion();
        Assert.assertTrue((boolean)runningJob.isSuccessful());
        LOG.info("After map/reduce completion - job " + jobName);
    }

    public static class Reducer
    extends MultiTableInputFormatTestBase.ScanReducer
    implements org.apache.hadoop.mapred.Reducer<ImmutableBytesWritable, ImmutableBytesWritable, NullWritable, NullWritable> {
        private JobConf jobConf;

        public void reduce(ImmutableBytesWritable key, Iterator<ImmutableBytesWritable> values, OutputCollector<NullWritable, NullWritable> outputCollector, Reporter reporter) throws IOException {
            this.makeAssertions(key, Lists.newArrayList(values));
        }

        public void close() throws IOException {
            super.cleanup((Configuration)this.jobConf);
        }

        public void configure(JobConf jobConf) {
            this.jobConf = jobConf;
        }
    }

    public static class Mapper
    extends MultiTableInputFormatTestBase.ScanMapper
    implements TableMap<ImmutableBytesWritable, ImmutableBytesWritable> {
        public void map(ImmutableBytesWritable key, Result value, OutputCollector<ImmutableBytesWritable, ImmutableBytesWritable> outputCollector, Reporter reporter) throws IOException {
            this.makeAssertions(key, value);
            outputCollector.collect((Object)key, (Object)key);
        }

        public void close() throws IOException {
        }

        public void configure(JobConf jobConf) {
        }
    }
}

