/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapred;

import ch.cern.hbase.thirdparty.com.google.common.base.Joiner;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapred.RowCounter;
import org.apache.hadoop.hbase.testclassification.MapReduceTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentMatchers;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={MapReduceTests.class, SmallTests.class})
public class TestRowCounter {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRowCounter.class);

    @Test
    public void shouldPrintUsage() throws Exception {
        String expectedOutput = "rowcounter <outputdir> <tablename> <column1> [<column2>...]";
        String result = new OutputReader(System.out){

            @Override
            void doRead() {
                Assert.assertEquals((long)-1L, (long)RowCounter.printUsage());
            }
        }.read();
        Assert.assertTrue((boolean)result.startsWith(expectedOutput));
    }

    @Test
    public void shouldExitAndPrintUsageSinceParameterNumberLessThanThree() throws Exception {
        final String[] args = new String[]{"one", "two"};
        String line = "ERROR: Wrong number of parameters: " + args.length;
        String result = new OutputReader(System.err){

            @Override
            void doRead() throws Exception {
                Assert.assertEquals((long)-1L, (long)new RowCounter().run(args));
            }
        }.read();
        Assert.assertTrue((boolean)result.startsWith(line));
    }

    @Test
    public void shouldRegInReportEveryIncomingRow() throws IOException {
        int iterationNumber = 999;
        RowCounter.RowCounterMapper mapper = new RowCounter.RowCounterMapper();
        Reporter reporter = (Reporter)Mockito.mock(Reporter.class);
        for (int i = 0; i < iterationNumber; ++i) {
            mapper.map((ImmutableBytesWritable)Mockito.mock(ImmutableBytesWritable.class), (Result)Mockito.mock(Result.class), (OutputCollector)Mockito.mock(OutputCollector.class), reporter);
        }
        ((Reporter)Mockito.verify((Object)reporter, (VerificationMode)Mockito.times((int)iterationNumber))).incrCounter((Enum)Matchers.any(), ArgumentMatchers.anyLong());
    }

    @Test
    public void shouldCreateAndRunSubmittableJob() throws Exception {
        RowCounter rCounter = new RowCounter();
        rCounter.setConf(HBaseConfiguration.create());
        String[] args = new String[]{"\temp", "tableA", "column1", "column2", "column3"};
        JobConf jobConfig = rCounter.createSubmittableJob(args);
        Assert.assertNotNull((Object)jobConfig);
        Assert.assertEquals((long)0L, (long)jobConfig.getNumReduceTasks());
        Assert.assertEquals((Object)"rowcounter", (Object)jobConfig.getJobName());
        Assert.assertEquals((Object)jobConfig.getMapOutputValueClass(), Result.class);
        Assert.assertEquals((Object)jobConfig.getMapperClass(), RowCounter.RowCounterMapper.class);
        Assert.assertEquals((Object)jobConfig.get("hbase.mapred.tablecolumns"), (Object)Joiner.on((char)' ').join((Object)"column1", (Object)"column2", new Object[]{"column3"}));
        Assert.assertEquals((Object)jobConfig.getMapOutputKeyClass(), ImmutableBytesWritable.class);
    }

    private static abstract class OutputReader {
        private final PrintStream ps;
        private PrintStream oldPrintStream;
        private Outs outs;

        protected OutputReader(PrintStream ps) {
            this.ps = ps;
        }

        protected String read() throws Exception {
            ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
            if (this.ps == System.out) {
                this.oldPrintStream = System.out;
                this.outs = Outs.OUT;
                System.setOut(new PrintStream(outBytes));
            } else if (this.ps == System.err) {
                this.oldPrintStream = System.err;
                this.outs = Outs.ERR;
                System.setErr(new PrintStream(outBytes));
            } else {
                throw new IllegalStateException("OutputReader: unsupported PrintStream");
            }
            try {
                this.doRead();
                String string = new String(outBytes.toByteArray());
                return string;
            }
            finally {
                switch (this.outs) {
                    case OUT: {
                        System.setOut(this.oldPrintStream);
                        break;
                    }
                    case ERR: {
                        System.setErr(this.oldPrintStream);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("OutputReader: unsupported PrintStream");
                    }
                }
            }
        }

        abstract void doRead() throws Exception;
    }

    static enum Outs {
        OUT,
        ERR;

    }
}

