/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapred;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapred.TableMap;
import org.apache.hadoop.hbase.mapred.TableSnapshotInputFormat;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableSnapshotInputFormatTestBase;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.VerySlowMapReduceTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.RegionSplitter;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.lib.NullOutputFormat;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Mockito;

@Category(value={VerySlowMapReduceTests.class, LargeTests.class})
public class TestTableSnapshotInputFormat
extends TableSnapshotInputFormatTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestTableSnapshotInputFormat.class);
    private static final byte[] aaa = Bytes.toBytes((String)"aaa");
    private static final byte[] after_zzz = Bytes.toBytes((String)"zz{");
    private static final String COLUMNS = Bytes.toString((byte[])FAMILIES[0]) + " " + Bytes.toString((byte[])FAMILIES[1]);
    @Rule
    public TestName name = new TestName();

    @Override
    protected byte[] getStartRow() {
        return aaa;
    }

    @Override
    protected byte[] getEndRow() {
        return after_zzz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInitTableSnapshotMapperJobConfig() throws Exception {
        this.setupCluster();
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        String snapshotName = "foo";
        try {
            TestTableSnapshotInputFormat.createTableAndSnapshot(this.UTIL, tableName, snapshotName, this.getStartRow(), this.getEndRow(), 1);
            JobConf job = new JobConf(this.UTIL.getConfiguration());
            Path tmpTableDir = this.UTIL.getDataTestDirOnTestFS(snapshotName);
            org.apache.hadoop.hbase.mapred.TableMapReduceUtil.initTableSnapshotMapJob((String)snapshotName, (String)COLUMNS, TestTableSnapshotMapper.class, ImmutableBytesWritable.class, NullWritable.class, (JobConf)job, (boolean)false, (Path)tmpTableDir);
            Assert.assertEquals((String)"Snapshot job should be configured for default LruBlockCache.", (double)0.4f, (double)job.getFloat("hfile.block.cache.size", -1.0f), (double)0.01);
            Assert.assertEquals((String)"Snapshot job should not use BucketCache.", (double)0.0, (double)job.getFloat("hbase.bucketcache.size", -1.0f), (double)0.01);
        }
        finally {
            this.UTIL.getAdmin().deleteSnapshot(snapshotName);
            this.UTIL.deleteTable(tableName);
            this.tearDownCluster();
        }
    }

    @Override
    @Test
    public void testWithMockedMapReduceMultiRegion() throws Exception {
        this.testWithMockedMapReduce(this.UTIL, "testWithMockedMapReduceMultiRegion", 10, 1, 10, true);
    }

    @Override
    @Test
    public void testWithMapReduceMultiRegion() throws Exception {
        this.testWithMapReduce(this.UTIL, "testWithMapReduceMultiRegion", 10, 1, 10, false);
    }

    @Override
    @Test
    public void testWithMapReduceAndOfflineHBaseMultiRegion() throws Exception {
        this.testWithMapReduce(this.UTIL, "testWithMapReduceAndOfflineHBaseMultiRegion", 10, 1, 10, true);
    }

    @Override
    public void testRestoreSnapshotDoesNotCreateBackRefLinksInit(TableName tableName, String snapshotName, Path tmpTableDir) throws Exception {
        JobConf job = new JobConf(this.UTIL.getConfiguration());
        org.apache.hadoop.hbase.mapred.TableMapReduceUtil.initTableSnapshotMapJob((String)snapshotName, (String)COLUMNS, TestTableSnapshotMapper.class, ImmutableBytesWritable.class, NullWritable.class, (JobConf)job, (boolean)false, (Path)tmpTableDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void testWithMockedMapReduce(HBaseTestingUtility util, String snapshotName, int numRegions, int numSplitsPerRegion, int expectedNumSplits, boolean setLocalityEnabledTo) throws Exception {
        this.setupCluster();
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try {
            TestTableSnapshotInputFormat.createTableAndSnapshot(util, tableName, snapshotName, this.getStartRow(), this.getEndRow(), numRegions);
            JobConf job = new JobConf(util.getConfiguration());
            Path tmpTableDir = util.getDataTestDirOnTestFS(snapshotName);
            if (numSplitsPerRegion > 1) {
                org.apache.hadoop.hbase.mapred.TableMapReduceUtil.initTableSnapshotMapJob((String)snapshotName, (String)COLUMNS, TestTableSnapshotMapper.class, ImmutableBytesWritable.class, NullWritable.class, (JobConf)job, (boolean)false, (Path)tmpTableDir, (RegionSplitter.SplitAlgorithm)new RegionSplitter.UniformSplit(), (int)numSplitsPerRegion);
            } else {
                org.apache.hadoop.hbase.mapred.TableMapReduceUtil.initTableSnapshotMapJob((String)snapshotName, (String)COLUMNS, TestTableSnapshotMapper.class, ImmutableBytesWritable.class, NullWritable.class, (JobConf)job, (boolean)false, (Path)tmpTableDir);
            }
            this.verifyWithMockedMapReduce(job, numRegions, expectedNumSplits, this.getStartRow(), this.getEndRow());
        }
        finally {
            util.getAdmin().deleteSnapshot(snapshotName);
            util.deleteTable(tableName);
            this.tearDownCluster();
        }
    }

    private void verifyWithMockedMapReduce(JobConf job, int numRegions, int expectedNumSplits, byte[] startRow, byte[] stopRow) throws IOException, InterruptedException {
        TableSnapshotInputFormat tsif = new TableSnapshotInputFormat();
        InputSplit[] splits = tsif.getSplits(job, 0);
        Assert.assertEquals((long)expectedNumSplits, (long)splits.length);
        HBaseTestingUtility.SeenRowTracker rowTracker = new HBaseTestingUtility.SeenRowTracker(startRow, stopRow);
        boolean localityEnabled = true;
        for (int i = 0; i < splits.length; ++i) {
            InputSplit split = splits[i];
            Assert.assertTrue((boolean)(split instanceof TableSnapshotInputFormat.TableSnapshotRegionSplit));
            if (localityEnabled) {
                Assert.assertTrue((split.getLocations() != null ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((split.getLocations() != null && split.getLocations().length == 0 ? 1 : 0) != 0);
            }
            OutputCollector collector = (OutputCollector)Mockito.mock(OutputCollector.class);
            Reporter reporter = (Reporter)Mockito.mock(Reporter.class);
            RecordReader rr = tsif.getRecordReader(split, job, reporter);
            ImmutableBytesWritable key = (ImmutableBytesWritable)rr.createKey();
            Result value = (Result)rr.createValue();
            while (rr.next((Object)key, (Object)value)) {
                TestTableSnapshotInputFormat.verifyRowFromMap(key, value);
                rowTracker.addRow(key.copyBytes());
            }
            rr.close();
        }
        rowTracker.validate();
    }

    @Override
    protected void testWithMapReduceImpl(HBaseTestingUtility util, TableName tableName, String snapshotName, Path tableDir, int numRegions, int numSplitsPerRegion, int expectedNumSplits, boolean shutdownCluster) throws Exception {
        TestTableSnapshotInputFormat.doTestWithMapReduce(util, tableName, snapshotName, this.getStartRow(), this.getEndRow(), tableDir, numRegions, numSplitsPerRegion, expectedNumSplits, shutdownCluster);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doTestWithMapReduce(HBaseTestingUtility util, TableName tableName, String snapshotName, byte[] startRow, byte[] endRow, Path tableDir, int numRegions, int numSplitsPerRegion, int expectedNumSplits, boolean shutdownCluster) throws Exception {
        TestTableSnapshotInputFormat.createTableAndSnapshot(util, tableName, snapshotName, startRow, endRow, numRegions);
        if (shutdownCluster) {
            util.shutdownMiniHBaseCluster();
        }
        try {
            JobConf jobConf = new JobConf(util.getConfiguration());
            jobConf.setJarByClass(util.getClass());
            TableMapReduceUtil.addDependencyJarsForClasses((Configuration)jobConf, (Class[])new Class[]{TestTableSnapshotInputFormat.class});
            if (numSplitsPerRegion > 1) {
                org.apache.hadoop.hbase.mapred.TableMapReduceUtil.initTableSnapshotMapJob((String)snapshotName, (String)COLUMNS, TestTableSnapshotMapper.class, ImmutableBytesWritable.class, NullWritable.class, (JobConf)jobConf, (boolean)true, (Path)tableDir, (RegionSplitter.SplitAlgorithm)new RegionSplitter.UniformSplit(), (int)numSplitsPerRegion);
            } else {
                org.apache.hadoop.hbase.mapred.TableMapReduceUtil.initTableSnapshotMapJob((String)snapshotName, (String)COLUMNS, TestTableSnapshotMapper.class, ImmutableBytesWritable.class, NullWritable.class, (JobConf)jobConf, (boolean)true, (Path)tableDir);
            }
            jobConf.setReducerClass(TestTableSnapshotReducer.class);
            jobConf.setNumReduceTasks(1);
            jobConf.setOutputFormat(NullOutputFormat.class);
            RunningJob job = JobClient.runJob((JobConf)jobConf);
            Assert.assertTrue((boolean)job.isSuccessful());
        }
        finally {
            if (!shutdownCluster) {
                util.getAdmin().deleteSnapshot(snapshotName);
                util.deleteTable(tableName);
            }
        }
    }

    @Ignore
    @Test
    public void testWithMapReduceMultipleMappersPerRegion() throws Exception {
        this.testWithMapReduce(this.UTIL, "testWithMapReduceMultiRegion", 10, 5, 50, false);
    }

    static /* synthetic */ byte[] access$100() {
        return aaa;
    }

    static /* synthetic */ byte[] access$200() {
        return after_zzz;
    }

    public static class TestTableSnapshotReducer
    extends MapReduceBase
    implements Reducer<ImmutableBytesWritable, NullWritable, NullWritable, NullWritable> {
        HBaseTestingUtility.SeenRowTracker rowTracker = new HBaseTestingUtility.SeenRowTracker(TestTableSnapshotInputFormat.access$100(), TestTableSnapshotInputFormat.access$200());

        public void reduce(ImmutableBytesWritable key, Iterator<NullWritable> values, OutputCollector<NullWritable, NullWritable> collector, Reporter reporter) throws IOException {
            this.rowTracker.addRow(key.get());
        }

        public void close() {
            this.rowTracker.validate();
        }
    }

    static class TestTableSnapshotMapper
    extends MapReduceBase
    implements TableMap<ImmutableBytesWritable, NullWritable> {
        TestTableSnapshotMapper() {
        }

        public void map(ImmutableBytesWritable key, Result value, OutputCollector<ImmutableBytesWritable, NullWritable> collector, Reporter reporter) throws IOException {
            TestTableSnapshotInputFormat.verifyRowFromMap(key, value);
            collector.collect((Object)key, (Object)NullWritable.get());
        }
    }
}

