/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.metrics.impl;

import java.util.stream.IntStream;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.metrics.Snapshot;
import org.apache.hadoop.hbase.metrics.impl.HistogramImpl;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestHistogramImpl {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHistogramImpl.class);

    @Test
    public void testUpdate() {
        HistogramImpl histogram = new HistogramImpl();
        Assert.assertEquals((long)0L, (long)histogram.getCount());
        histogram.update(0);
        Assert.assertEquals((long)1L, (long)histogram.getCount());
        histogram.update(10);
        Assert.assertEquals((long)2L, (long)histogram.getCount());
        histogram.update(20);
        histogram.update(30);
        Assert.assertEquals((long)4L, (long)histogram.getCount());
    }

    @Test
    public void testSnapshot() {
        HistogramImpl histogram = new HistogramImpl();
        IntStream.range(0, 100).forEach(arg_0 -> ((HistogramImpl)histogram).update(arg_0));
        Snapshot snapshot = histogram.snapshot();
        Assert.assertEquals((long)100L, (long)snapshot.getCount());
        Assert.assertEquals((long)50L, (long)snapshot.getMedian());
        Assert.assertEquals((long)49L, (long)snapshot.getMean());
        Assert.assertEquals((long)0L, (long)snapshot.getMin());
        Assert.assertEquals((long)99L, (long)snapshot.getMax());
        Assert.assertEquals((long)25L, (long)snapshot.get25thPercentile());
        Assert.assertEquals((long)75L, (long)snapshot.get75thPercentile());
        Assert.assertEquals((long)90L, (long)snapshot.get90thPercentile());
        Assert.assertEquals((long)95L, (long)snapshot.get95thPercentile());
        Assert.assertEquals((long)98L, (long)snapshot.get98thPercentile());
        Assert.assertEquals((long)99L, (long)snapshot.get99thPercentile());
        Assert.assertEquals((long)99L, (long)snapshot.get999thPercentile());
        Assert.assertEquals((long)51L, (long)snapshot.getCountAtOrBelow(50L));
        Assert.assertEquals((long)100L, (long)histogram.getCount());
        IntStream.range(100, 200).forEach(arg_0 -> ((HistogramImpl)histogram).update(arg_0));
        Assert.assertEquals((long)200L, (long)histogram.getCount());
        snapshot = histogram.snapshot();
        Assert.assertEquals((long)100L, (long)snapshot.getCount());
        Assert.assertEquals((long)150L, (long)snapshot.getMedian());
        Assert.assertEquals((long)149L, (long)snapshot.getMean());
        Assert.assertEquals((long)100L, (long)snapshot.getMin());
        Assert.assertEquals((long)199L, (long)snapshot.getMax());
        Assert.assertEquals((long)125L, (long)snapshot.get25thPercentile());
        Assert.assertEquals((long)175L, (long)snapshot.get75thPercentile());
        Assert.assertEquals((long)190L, (long)snapshot.get90thPercentile());
        Assert.assertEquals((long)195L, (long)snapshot.get95thPercentile());
        Assert.assertEquals((long)198L, (long)snapshot.get98thPercentile());
        Assert.assertEquals((long)199L, (long)snapshot.get99thPercentile());
        Assert.assertEquals((long)199L, (long)snapshot.get999thPercentile());
    }
}

