/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.metrics.impl;

import ch.cern.hbase.thirdparty.com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Set;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.metrics.impl.RefCountingMap;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestRefCountingMap {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRefCountingMap.class);
    private RefCountingMap<String, String> map;

    @Before
    public void setUp() {
        this.map = new RefCountingMap();
    }

    @Test
    public void testPutGet() {
        this.map.put((Object)"foo", () -> "foovalue");
        String v = (String)this.map.get((Object)"foo");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)"foovalue", (Object)v);
    }

    @Test
    public void testPutMulti() {
        String v1 = (String)this.map.put((Object)"foo", () -> "foovalue");
        String v2 = (String)this.map.put((Object)"foo", () -> "foovalue2");
        String v3 = (String)this.map.put((Object)"foo", () -> "foovalue3");
        String v = (String)this.map.get((Object)"foo");
        Assert.assertEquals((Object)"foovalue", (Object)v);
        Assert.assertEquals((Object)v, (Object)v1);
        Assert.assertEquals((Object)v, (Object)v2);
        Assert.assertEquals((Object)v, (Object)v3);
    }

    @Test
    public void testPutRemove() {
        this.map.put((Object)"foo", () -> "foovalue");
        String v = (String)this.map.remove((Object)"foo");
        Assert.assertNull((Object)v);
        v = (String)this.map.get((Object)"foo");
        Assert.assertNull((Object)v);
    }

    @Test
    public void testPutRemoveMulti() {
        this.map.put((Object)"foo", () -> "foovalue");
        this.map.put((Object)"foo", () -> "foovalue2");
        this.map.put((Object)"foo", () -> "foovalue3");
        String v = (String)this.map.remove((Object)"foo");
        Assert.assertEquals((Object)"foovalue", (Object)v);
        v = (String)this.map.remove((Object)"foo");
        Assert.assertEquals((Object)"foovalue", (Object)v);
        v = (String)this.map.remove((Object)"foo");
        Assert.assertNull((Object)v);
        v = (String)this.map.get((Object)"foo");
        Assert.assertNull((Object)v);
    }

    @Test
    public void testSize() {
        Assert.assertEquals((long)0L, (long)this.map.size());
        this.map.put((Object)"foo", () -> "foovalue");
        Assert.assertEquals((long)1L, (long)this.map.size());
        this.map.put((Object)"bar", () -> "foovalue2");
        Assert.assertEquals((long)2L, (long)this.map.size());
        this.map.put((Object)"bar", () -> "foovalue3");
        Assert.assertEquals((long)2L, (long)this.map.size());
    }

    @Test
    public void testClear() {
        this.map.put((Object)"foo", () -> "foovalue");
        this.map.put((Object)"bar", () -> "foovalue2");
        this.map.put((Object)"baz", () -> "foovalue3");
        this.map.clear();
        Assert.assertEquals((long)0L, (long)this.map.size());
    }

    @Test
    public void testKeySet() {
        this.map.put((Object)"foo", () -> "foovalue");
        this.map.put((Object)"bar", () -> "foovalue2");
        this.map.put((Object)"baz", () -> "foovalue3");
        Set keys = this.map.keySet();
        Assert.assertEquals((long)3L, (long)keys.size());
        Lists.newArrayList((Object[])new String[]{"foo", "bar", "baz"}).stream().forEach(v -> Assert.assertTrue((boolean)keys.contains(v)));
    }

    @Test
    public void testValues() {
        this.map.put((Object)"foo", () -> "foovalue");
        this.map.put((Object)"foo", () -> "foovalue2");
        this.map.put((Object)"bar", () -> "foovalue3");
        this.map.put((Object)"baz", () -> "foovalue4");
        Collection values = this.map.values();
        Assert.assertEquals((long)3L, (long)values.size());
        Lists.newArrayList((Object[])new String[]{"foovalue", "foovalue3", "foovalue4"}).stream().forEach(v -> Assert.assertTrue((boolean)values.contains(v)));
    }
}

