/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.SequentialProcedure;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, SmallTests.class})
public class TestChildProcedures {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestChildProcedures.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestChildProcedures.class);
    private static final int PROCEDURE_EXECUTOR_SLOTS = 1;
    private static TestProcEnv procEnv;
    private static ProcedureExecutor<TestProcEnv> procExecutor;
    private static ProcedureStore procStore;
    private HBaseCommonTestingUtility htu;
    private FileSystem fs;
    private Path testDir;
    private Path logDir;

    @Before
    public void setUp() throws IOException {
        this.htu = new HBaseCommonTestingUtility();
        this.testDir = this.htu.getDataTestDir();
        this.fs = this.testDir.getFileSystem(this.htu.getConfiguration());
        Assert.assertTrue((this.testDir.depth() > 1 ? 1 : 0) != 0);
        this.logDir = new Path(this.testDir, "proc-logs");
        procEnv = new TestProcEnv();
        procStore = ProcedureTestingUtility.createStore(this.htu.getConfiguration(), this.logDir);
        procExecutor = new ProcedureExecutor(this.htu.getConfiguration(), (Object)procEnv, procStore);
        TestChildProcedures.procExecutor.testing = new ProcedureExecutor.Testing();
        procStore.start(1);
        ProcedureTestingUtility.initAndStartWorkers(procExecutor, 1, 0, false, true);
    }

    @After
    public void tearDown() throws IOException {
        procExecutor.stop();
        procStore.stop(false);
        this.fs.delete(this.logDir, true);
    }

    @Test
    public void testChildLoad() throws Exception {
        TestChildProcedures.procEnv.toggleKillBeforeStoreUpdate = false;
        TestRootProcedure proc = new TestRootProcedure();
        long procId = ProcedureTestingUtility.submitAndWait(procExecutor, (Procedure)proc);
        ProcedureTestingUtility.restart(procExecutor);
        ProcedureTestingUtility.waitProcedure(procExecutor, (Procedure)proc);
        Assert.assertTrue((String)"expected completed proc", (boolean)procExecutor.isFinished(procId));
        ProcedureTestingUtility.assertProcNotFailed(procExecutor, procId);
    }

    @Test
    public void testChildLoadWithSteppedRestart() throws Exception {
        TestChildProcedures.procEnv.toggleKillBeforeStoreUpdate = true;
        TestRootProcedure proc = new TestRootProcedure();
        long procId = ProcedureTestingUtility.submitAndWait(procExecutor, (Procedure)proc);
        int restartCount = 0;
        while (!procExecutor.isFinished(procId)) {
            ProcedureTestingUtility.restart(procExecutor);
            ProcedureTestingUtility.waitProcedure(procExecutor, (Procedure)proc);
            ++restartCount;
        }
        Assert.assertEquals((long)3L, (long)restartCount);
        Assert.assertTrue((String)"expected completed proc", (boolean)procExecutor.isFinished(procId));
        ProcedureTestingUtility.assertProcNotFailed(procExecutor, procId);
    }

    @Test
    public void testChildLoadWithRestartAfterChildSuccess() throws Exception {
        TestChildProcedures.procEnv.toggleKillAfterStoreUpdate = true;
        TestRootProcedure proc = new TestRootProcedure();
        long procId = ProcedureTestingUtility.submitAndWait(procExecutor, (Procedure)proc);
        int restartCount = 0;
        while (!procExecutor.isFinished(procId)) {
            ProcedureTestingUtility.restart(procExecutor);
            ProcedureTestingUtility.waitProcedure(procExecutor, (Procedure)proc);
            ++restartCount;
        }
        Assert.assertEquals((long)4L, (long)restartCount);
        Assert.assertTrue((String)"expected completed proc", (boolean)procExecutor.isFinished(procId));
        ProcedureTestingUtility.assertProcNotFailed(procExecutor, procId);
    }

    @Test
    public void testChildRollbackLoad() throws Exception {
        TestChildProcedures.procEnv.toggleKillBeforeStoreUpdate = false;
        TestChildProcedures.procEnv.triggerRollbackOnChild = true;
        TestRootProcedure proc = new TestRootProcedure();
        long procId = ProcedureTestingUtility.submitAndWait(procExecutor, (Procedure)proc);
        ProcedureTestingUtility.restart(procExecutor);
        ProcedureTestingUtility.waitProcedure(procExecutor, (Procedure)proc);
        this.assertProcFailed(procId);
    }

    @Test
    public void testChildRollbackLoadWithSteppedRestart() throws Exception {
        TestChildProcedures.procEnv.toggleKillBeforeStoreUpdate = true;
        TestChildProcedures.procEnv.triggerRollbackOnChild = true;
        TestRootProcedure proc = new TestRootProcedure();
        long procId = ProcedureTestingUtility.submitAndWait(procExecutor, (Procedure)proc);
        int restartCount = 0;
        while (!procExecutor.isFinished(procId)) {
            ProcedureTestingUtility.restart(procExecutor);
            ProcedureTestingUtility.waitProcedure(procExecutor, (Procedure)proc);
            ++restartCount;
        }
        Assert.assertEquals((long)2L, (long)restartCount);
        this.assertProcFailed(procId);
    }

    private void assertProcFailed(long procId) {
        Assert.assertTrue((String)"expected completed proc", (boolean)procExecutor.isFinished(procId));
        Procedure result = procExecutor.getResult(procId);
        Assert.assertEquals((Object)true, (Object)result.isFailed());
        LOG.info(result.getException().getMessage());
    }

    private static class TestProcEnv {
        public boolean toggleKillBeforeStoreUpdate = false;
        public boolean toggleKillAfterStoreUpdate = false;
        public boolean triggerRollbackOnChild = false;

        private TestProcEnv() {
        }
    }

    public static class TestChildProcedure
    extends SequentialProcedure<TestProcEnv> {
        public Procedure[] execute(TestProcEnv env) {
            if (env.toggleKillBeforeStoreUpdate) {
                ProcedureTestingUtility.toggleKillBeforeStoreUpdate(procExecutor);
            }
            if (env.triggerRollbackOnChild) {
                this.setFailure("test", new Exception("test"));
            }
            return null;
        }

        public void rollback(TestProcEnv env) {
        }

        public boolean abort(TestProcEnv env) {
            return false;
        }
    }

    public static class TestRootProcedure
    extends SequentialProcedure<TestProcEnv> {
        public Procedure[] execute(TestProcEnv env) {
            if (env.toggleKillBeforeStoreUpdate) {
                ProcedureTestingUtility.toggleKillBeforeStoreUpdate(procExecutor);
            }
            if (env.toggleKillAfterStoreUpdate) {
                ProcedureTestingUtility.toggleKillAfterStoreUpdate(procExecutor);
            }
            return new Procedure[]{new TestChildProcedure(), new TestChildProcedure()};
        }

        public void rollback(TestProcEnv env) {
        }

        public boolean abort(TestProcEnv env) {
            return false;
        }
    }
}

