/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.procedure2.BadProcedureException;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.ProcedureUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, SmallTests.class})
public class TestProcedureUtil {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestProcedureUtil.class);

    @Test
    public void testValidation() throws Exception {
        ProcedureUtil.validateClass((Procedure)new ProcedureTestingUtility.TestProcedure(10L));
    }

    @Test(expected=BadProcedureException.class)
    public void testNoDefaultConstructorValidation() throws Exception {
        ProcedureUtil.validateClass((Procedure)new TestProcedureNoDefaultConstructor(1));
    }

    @Test
    public void testConvert() throws Exception {
        ProcedureTestingUtility.TestProcedure proc1 = new ProcedureTestingUtility.TestProcedure(10L, 1L, new byte[]{65});
        ProcedureProtos.Procedure proto1 = ProcedureUtil.convertToProtoProcedure((Procedure)proc1);
        ProcedureTestingUtility.TestProcedure proc2 = (ProcedureTestingUtility.TestProcedure)ProcedureUtil.convertToProcedure((ProcedureProtos.Procedure)proto1);
        ProcedureProtos.Procedure proto2 = ProcedureUtil.convertToProtoProcedure((Procedure)proc2);
        Assert.assertEquals((Object)false, (Object)proto2.hasResult());
        Assert.assertEquals((String)"Procedure protobuf does not match", (Object)proto1, (Object)proto2);
    }

    @Test
    public void testGetBackoffTimeMs() {
        for (int i = 30; i < 1000; ++i) {
            Assert.assertEquals((long)TimeUnit.MINUTES.toMillis(10L), (long)ProcedureUtil.getBackoffTimeMs((int)30));
        }
        long backoffTimeMs = ProcedureUtil.getBackoffTimeMs((int)0);
        Assert.assertTrue((backoffTimeMs >= 1000L ? 1 : 0) != 0);
        Assert.assertTrue(((float)backoffTimeMs <= 1010.0f ? 1 : 0) != 0);
        backoffTimeMs = ProcedureUtil.getBackoffTimeMs((int)1);
        Assert.assertTrue((backoffTimeMs >= 2000L ? 1 : 0) != 0);
        Assert.assertTrue(((float)backoffTimeMs <= 2020.0f ? 1 : 0) != 0);
        backoffTimeMs = ProcedureUtil.getBackoffTimeMs((int)5);
        Assert.assertTrue((backoffTimeMs >= 32000L ? 1 : 0) != 0);
        Assert.assertTrue(((float)backoffTimeMs <= 32320.0f ? 1 : 0) != 0);
    }

    public static class TestProcedureNoDefaultConstructor
    extends ProcedureTestingUtility.TestProcedure {
        public TestProcedureNoDefaultConstructor(int x) {
        }
    }
}

