/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import ch.cern.hbase.thirdparty.com.google.protobuf.Int32Value;
import ch.cern.hbase.thirdparty.com.google.protobuf.Message;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.procedure2.AbstractProcedureScheduler;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureEvent;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureScheduler;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, SmallTests.class})
public class TestProcedureEvents {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestProcedureEvents.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestProcedureEvents.class);
    private TestProcEnv procEnv;
    private ProcedureStore procStore;
    private ProcedureExecutor<TestProcEnv> procExecutor;
    private HBaseCommonTestingUtility htu;
    private FileSystem fs;
    private Path logDir;

    @Before
    public void setUp() throws IOException {
        this.htu = new HBaseCommonTestingUtility();
        Path testDir = this.htu.getDataTestDir();
        this.fs = testDir.getFileSystem(this.htu.getConfiguration());
        this.logDir = new Path(testDir, "proc-logs");
        this.procEnv = new TestProcEnv();
        this.procStore = ProcedureTestingUtility.createWalStore(this.htu.getConfiguration(), this.logDir);
        this.procExecutor = new ProcedureExecutor(this.htu.getConfiguration(), (Object)this.procEnv, this.procStore);
        this.procStore.start(1);
        ProcedureTestingUtility.initAndStartWorkers(this.procExecutor, 1, true);
    }

    @After
    public void tearDown() throws IOException {
        this.procExecutor.stop();
        this.procStore.stop(false);
        this.procExecutor.join();
        this.fs.delete(this.logDir, true);
    }

    @Test
    public void testTimeoutEventProcedure() throws Exception {
        int NTIMEOUTS = 5;
        TestTimeoutEventProcedure proc = new TestTimeoutEventProcedure(500, 5);
        this.procExecutor.submitProcedure((Procedure)proc);
        ProcedureTestingUtility.waitProcedure(this.procExecutor, proc.getProcId());
        ProcedureTestingUtility.assertIsAbortException(this.procExecutor.getResult(proc.getProcId()));
        Assert.assertEquals((long)6L, (long)proc.getTimeoutsCount());
    }

    @Test
    public void testTimeoutEventProcedureDoubleExecution() throws Exception {
        this.testTimeoutEventProcedureDoubleExecution(false);
    }

    @Test
    public void testTimeoutEventProcedureDoubleExecutionKillIfSuspended() throws Exception {
        this.testTimeoutEventProcedureDoubleExecution(true);
    }

    private void testTimeoutEventProcedureDoubleExecution(boolean killIfSuspended) throws Exception {
        TestTimeoutEventProcedure proc = new TestTimeoutEventProcedure(1000, 3);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(this.procExecutor, true);
        ProcedureTestingUtility.setKillIfSuspended(this.procExecutor, killIfSuspended);
        long procId = this.procExecutor.submitProcedure((Procedure)proc);
        ProcedureTestingUtility.testRecoveryAndDoubleExecution(this.procExecutor, procId, true);
        ProcedureTestingUtility.assertIsAbortException(this.procExecutor.getResult(proc.getProcId()));
    }

    private class TestProcEnv {
        private TestProcEnv() {
        }

        public ProcedureScheduler getProcedureScheduler() {
            return TestProcedureEvents.this.procExecutor.getScheduler();
        }
    }

    public static class TestTimeoutEventProcedure
    extends ProcedureTestingUtility.NoopProcedure<TestProcEnv> {
        private final ProcedureEvent event = new ProcedureEvent((Object)"timeout-event");
        private final AtomicInteger ntimeouts = new AtomicInteger(0);
        private int maxTimeouts = 1;

        public TestTimeoutEventProcedure() {
        }

        public TestTimeoutEventProcedure(int timeoutMsec, int maxTimeouts) {
            this.maxTimeouts = maxTimeouts;
            this.setTimeout(timeoutMsec);
        }

        public int getTimeoutsCount() {
            return this.ntimeouts.get();
        }

        @Override
        protected Procedure[] execute(TestProcEnv env) throws ProcedureSuspendedException {
            LOG.info("EXECUTE " + (Object)((Object)this) + " ntimeouts=" + this.ntimeouts);
            if (this.ntimeouts.get() > this.maxTimeouts) {
                this.setAbortFailure("test", "give up after " + this.ntimeouts.get());
                return null;
            }
            this.event.suspend();
            if (this.event.suspendIfNotReady((Procedure)this)) {
                this.setState(ProcedureProtos.ProcedureState.WAITING_TIMEOUT);
                throw new ProcedureSuspendedException();
            }
            return null;
        }

        protected synchronized boolean setTimeoutFailure(TestProcEnv env) {
            int n = this.ntimeouts.incrementAndGet();
            LOG.info("HANDLE TIMEOUT " + (Object)((Object)this) + " ntimeouts=" + n);
            this.setState(ProcedureProtos.ProcedureState.RUNNABLE);
            this.event.wake((AbstractProcedureScheduler)env.getProcedureScheduler());
            return false;
        }

        protected void afterReplay(TestProcEnv env) {
            if (this.getState() == ProcedureProtos.ProcedureState.WAITING_TIMEOUT) {
                this.event.suspend();
                this.event.suspendIfNotReady((Procedure)this);
            }
        }

        @Override
        protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
            Int32Value.Builder ntimeoutsBuilder = Int32Value.newBuilder().setValue(this.ntimeouts.get());
            serializer.serialize((Message)ntimeoutsBuilder.build());
            Int32Value.Builder maxTimeoutsBuilder = Int32Value.newBuilder().setValue(this.maxTimeouts);
            serializer.serialize((Message)maxTimeoutsBuilder.build());
        }

        @Override
        protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
            Int32Value ntimeoutsValue = (Int32Value)serializer.deserialize(Int32Value.class);
            this.ntimeouts.set(ntimeoutsValue.getValue());
            Int32Value maxTimeoutsValue = (Int32Value)serializer.deserialize(Int32Value.class);
            this.maxTimeouts = maxTimeoutsValue.getValue();
        }
    }
}

