/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import ch.cern.hbase.thirdparty.com.google.protobuf.Int32Value;
import ch.cern.hbase.thirdparty.com.google.protobuf.Message;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureAbortedException;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureException;
import org.apache.hadoop.hbase.procedure2.SequentialProcedure;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, SmallTests.class})
public class TestProcedureRecovery {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestProcedureRecovery.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestProcedureRecovery.class);
    private static final int PROCEDURE_EXECUTOR_SLOTS = 1;
    private static TestProcEnv procEnv;
    private static ProcedureExecutor<TestProcEnv> procExecutor;
    private static ProcedureStore procStore;
    private static int procSleepInterval;
    private HBaseCommonTestingUtility htu;
    private FileSystem fs;
    private Path testDir;
    private Path logDir;

    @Before
    public void setUp() throws IOException {
        this.htu = new HBaseCommonTestingUtility();
        this.testDir = this.htu.getDataTestDir();
        this.fs = this.testDir.getFileSystem(this.htu.getConfiguration());
        Assert.assertTrue((this.testDir.depth() > 1 ? 1 : 0) != 0);
        this.logDir = new Path(this.testDir, "proc-logs");
        procEnv = new TestProcEnv();
        procStore = ProcedureTestingUtility.createStore(this.htu.getConfiguration(), this.logDir);
        procExecutor = new ProcedureExecutor(this.htu.getConfiguration(), (Object)procEnv, procStore);
        TestProcedureRecovery.procExecutor.testing = new ProcedureExecutor.Testing();
        procStore.start(1);
        ProcedureTestingUtility.initAndStartWorkers(procExecutor, 1, true);
        procSleepInterval = 0;
    }

    @After
    public void tearDown() throws IOException {
        procExecutor.stop();
        procStore.stop(false);
        this.fs.delete(this.logDir, true);
    }

    private void restart() throws Exception {
        this.dumpLogDirState();
        ProcedureTestingUtility.restart(procExecutor);
        this.dumpLogDirState();
    }

    @Test
    public void testNoopLoad() throws Exception {
        this.restart();
    }

    @Test
    public void testSingleStepProcRecovery() throws Exception {
        TestSingleStepProcedure proc = new TestSingleStepProcedure();
        TestProcedureRecovery.procExecutor.testing.killBeforeStoreUpdate = true;
        long procId = ProcedureTestingUtility.submitAndWait(procExecutor, (Procedure)proc);
        Assert.assertFalse((boolean)procExecutor.isRunning());
        TestProcedureRecovery.procExecutor.testing.killBeforeStoreUpdate = false;
        long restartTs = EnvironmentEdgeManager.currentTime();
        this.restart();
        this.waitProcedure(procId);
        Procedure result = procExecutor.getResult(procId);
        Assert.assertTrue((result.getLastUpdate() > restartTs ? 1 : 0) != 0);
        ProcedureTestingUtility.assertProcNotFailed(result);
        Assert.assertEquals((long)1L, (long)Bytes.toInt((byte[])result.getResult()));
        long resultTs = result.getLastUpdate();
        this.restart();
        result = procExecutor.getResult(procId);
        ProcedureTestingUtility.assertProcNotFailed(result);
        Assert.assertEquals((long)resultTs, (long)result.getLastUpdate());
        Assert.assertEquals((long)1L, (long)Bytes.toInt((byte[])result.getResult()));
    }

    @Test
    public void testMultiStepProcRecovery() throws Exception {
        TestMultiStepProcedure proc = new TestMultiStepProcedure();
        long procId = ProcedureTestingUtility.submitAndWait(procExecutor, (Procedure)proc);
        Assert.assertFalse((boolean)procExecutor.isRunning());
        this.restart();
        this.waitProcedure(procId);
        ProcedureTestingUtility.assertProcNotYetCompleted(procExecutor, procId);
        Assert.assertFalse((boolean)procExecutor.isRunning());
        this.restart();
        this.waitProcedure(procId);
        ProcedureTestingUtility.assertProcNotYetCompleted(procExecutor, procId);
        Assert.assertFalse((boolean)procExecutor.isRunning());
        this.restart();
        this.waitProcedure(procId);
        Assert.assertTrue((boolean)procExecutor.isRunning());
        Procedure result = procExecutor.getResult(procId);
        ProcedureTestingUtility.assertProcNotFailed(result);
    }

    @Test
    public void testMultiStepRollbackRecovery() throws Exception {
        TestMultiStepProcedure proc = new TestMultiStepProcedure();
        long procId = ProcedureTestingUtility.submitAndWait(procExecutor, (Procedure)proc);
        Assert.assertFalse((boolean)procExecutor.isRunning());
        this.restart();
        this.waitProcedure(procId);
        ProcedureTestingUtility.assertProcNotYetCompleted(procExecutor, procId);
        Assert.assertFalse((boolean)procExecutor.isRunning());
        this.restart();
        this.waitProcedure(procId);
        ProcedureTestingUtility.assertProcNotYetCompleted(procExecutor, procId);
        Assert.assertFalse((boolean)procExecutor.isRunning());
        procSleepInterval = 2500;
        this.restart();
        Assert.assertTrue((boolean)procExecutor.abort(procId));
        this.waitProcedure(procId);
        Assert.assertFalse((boolean)procExecutor.isRunning());
        this.restart();
        this.waitProcedure(procId);
        ProcedureTestingUtility.assertProcNotYetCompleted(procExecutor, procId);
        Assert.assertFalse((boolean)procExecutor.isRunning());
        this.restart();
        this.waitProcedure(procId);
        ProcedureTestingUtility.assertProcNotYetCompleted(procExecutor, procId);
        Assert.assertFalse((boolean)procExecutor.isRunning());
        this.restart();
        this.waitProcedure(procId);
        Procedure result = procExecutor.getResult(procId);
        ProcedureTestingUtility.assertIsAbortException(result);
    }

    @Test
    public void testStateMachineMultipleLevel() throws Exception {
        long procId = procExecutor.submitProcedure((Procedure)new TestStateMachineProcedure(true));
        ProcedureTestingUtility.waitProcedure(procExecutor, procId);
        Procedure result = procExecutor.getResult(procId);
        ProcedureTestingUtility.assertProcNotFailed(result);
        Assert.assertEquals((long)19L, (long)Bytes.toInt((byte[])result.getResult()));
        Assert.assertEquals((long)4L, (long)procExecutor.getLastProcId());
    }

    @Test
    public void testStateMachineRecovery() throws Exception {
        ProcedureTestingUtility.setToggleKillBeforeStoreUpdate(procExecutor, true);
        ProcedureTestingUtility.setKillBeforeStoreUpdate(procExecutor, true);
        TestStateMachineProcedure proc = new TestStateMachineProcedure();
        long procId = ProcedureTestingUtility.submitAndWait(procExecutor, (Procedure)proc);
        Assert.assertFalse((boolean)procExecutor.isRunning());
        this.restart();
        this.waitProcedure(procId);
        ProcedureTestingUtility.assertProcNotYetCompleted(procExecutor, procId);
        Assert.assertFalse((boolean)procExecutor.isRunning());
        this.restart();
        this.waitProcedure(procId);
        ProcedureTestingUtility.assertProcNotYetCompleted(procExecutor, procId);
        Assert.assertFalse((boolean)procExecutor.isRunning());
        this.restart();
        this.waitProcedure(procId);
        ProcedureTestingUtility.assertProcNotYetCompleted(procExecutor, procId);
        Assert.assertFalse((boolean)procExecutor.isRunning());
        this.restart();
        this.waitProcedure(procId);
        Assert.assertTrue((boolean)procExecutor.isRunning());
        Procedure result = procExecutor.getResult(procId);
        ProcedureTestingUtility.assertProcNotFailed(result);
        Assert.assertEquals((long)26L, (long)Bytes.toInt((byte[])result.getResult()));
    }

    @Test
    public void testStateMachineRollbackRecovery() throws Exception {
        ProcedureTestingUtility.setToggleKillBeforeStoreUpdate(procExecutor, true);
        ProcedureTestingUtility.setKillBeforeStoreUpdate(procExecutor, true);
        TestStateMachineProcedure proc = new TestStateMachineProcedure();
        long procId = ProcedureTestingUtility.submitAndWait(procExecutor, (Procedure)proc);
        ProcedureTestingUtility.assertProcNotYetCompleted(procExecutor, procId);
        Assert.assertFalse((boolean)procExecutor.isRunning());
        this.restart();
        this.waitProcedure(procId);
        ProcedureTestingUtility.assertProcNotYetCompleted(procExecutor, procId);
        Assert.assertFalse((boolean)procExecutor.isRunning());
        this.restart();
        this.waitProcedure(procId);
        ProcedureTestingUtility.assertProcNotYetCompleted(procExecutor, procId);
        Assert.assertFalse((boolean)procExecutor.isRunning());
        procSleepInterval = 2500;
        this.restart();
        Assert.assertTrue((boolean)procExecutor.abort(procId));
        this.waitProcedure(procId);
        ProcedureTestingUtility.assertProcNotYetCompleted(procExecutor, procId);
        Assert.assertFalse((boolean)procExecutor.isRunning());
        this.restart();
        this.waitProcedure(procId);
        Assert.assertFalse((boolean)procExecutor.isRunning());
        ProcedureTestingUtility.assertProcNotYetCompleted(procExecutor, procId);
        this.restart();
        this.waitProcedure(procId);
        Assert.assertFalse((boolean)procExecutor.isRunning());
        ProcedureTestingUtility.assertProcNotYetCompleted(procExecutor, procId);
        this.restart();
        this.waitProcedure(procId);
        Assert.assertTrue((boolean)procExecutor.isRunning());
        Procedure result = procExecutor.getResult(procId);
        ProcedureTestingUtility.assertIsAbortException(result);
    }

    private void waitProcedure(long procId) {
        ProcedureTestingUtility.waitProcedure(procExecutor, procId);
        this.dumpLogDirState();
    }

    private void dumpLogDirState() {
        try {
            FileStatus[] files = this.fs.listStatus(this.logDir);
            if (files != null && files.length > 0) {
                for (FileStatus file : files) {
                    Assert.assertTrue((String)file.toString(), (boolean)file.isFile());
                    LOG.debug("log file " + file.getPath() + " size=" + file.getLen());
                }
            } else {
                LOG.debug("no files under: " + this.logDir);
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to dump " + this.logDir, (Throwable)e);
        }
    }

    private static class TestProcEnv {
        private CountDownLatch latch = null;

        private TestProcEnv() {
        }

        public void setWaitLatch(CountDownLatch latch) {
            this.latch = latch;
        }

        public void waitOnLatch() throws InterruptedException {
            if (this.latch != null) {
                this.latch.await();
            }
        }
    }

    public static class TestStateMachineProcedure
    extends StateMachineProcedure<TestProcEnv, State> {
        private AtomicBoolean aborted = new AtomicBoolean(false);
        private int iResult = 0;
        private boolean submitChildProc = false;

        public TestStateMachineProcedure() {
        }

        public TestStateMachineProcedure(boolean testSubmitChildProc) {
            this.submitChildProc = testSubmitChildProc;
        }

        protected StateMachineProcedure.Flow executeFromState(TestProcEnv env, State state) {
            switch (state) {
                case STATE_1: {
                    LOG.info("execute step 1 " + (Object)((Object)this));
                    this.setNextState((Object)State.STATE_2);
                    this.iResult += 3;
                    break;
                }
                case STATE_2: {
                    LOG.info("execute step 2 " + (Object)((Object)this));
                    if (this.submitChildProc) {
                        this.addChildProcedure((Procedure[])new TestStateMachineProcedure[]{new TestStateMachineProcedure(), new TestStateMachineProcedure()});
                        this.setNextState((Object)State.DONE);
                    } else {
                        this.setNextState((Object)State.STATE_3);
                    }
                    this.iResult += 5;
                    break;
                }
                case STATE_3: {
                    LOG.info("execute step 3 " + (Object)((Object)this));
                    Threads.sleepWithoutInterrupt((long)procSleepInterval);
                    if (this.aborted.get()) {
                        LOG.info("aborted step 3 " + (Object)((Object)this));
                        this.setAbortFailure("test", "aborted");
                        break;
                    }
                    this.setNextState((Object)State.DONE);
                    this.iResult += 7;
                    break;
                }
                case DONE: {
                    if (this.submitChildProc) {
                        this.addChildProcedure((Procedure[])new TestStateMachineProcedure[]{new TestStateMachineProcedure()});
                    }
                    this.iResult += 11;
                    this.setResult(Bytes.toBytes((int)this.iResult));
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            return StateMachineProcedure.Flow.HAS_MORE_STATE;
        }

        protected void rollbackState(TestProcEnv env, State state) {
            switch (state) {
                case STATE_1: {
                    LOG.info("rollback step 1 " + (Object)((Object)this));
                    break;
                }
                case STATE_2: {
                    LOG.info("rollback step 2 " + (Object)((Object)this));
                    break;
                }
                case STATE_3: {
                    LOG.info("rollback step 3 " + (Object)((Object)this));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }

        protected State getState(int stateId) {
            return State.values()[stateId];
        }

        protected int getStateId(State state) {
            return state.ordinal();
        }

        protected State getInitialState() {
            return State.STATE_1;
        }

        protected boolean abort(TestProcEnv env) {
            this.aborted.set(true);
            return true;
        }

        protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
            super.serializeStateData(serializer);
            Int32Value.Builder builder = Int32Value.newBuilder().setValue(this.iResult);
            serializer.serialize((Message)builder.build());
        }

        protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
            super.deserializeStateData(serializer);
            Int32Value value = (Int32Value)serializer.deserialize(Int32Value.class);
            this.iResult = value.getValue();
        }

        static enum State {
            STATE_1,
            STATE_2,
            STATE_3,
            DONE;

        }
    }

    public static class TestMultiStepProcedure
    extends BaseTestStepProcedure {
        @Override
        public Procedure[] execute(TestProcEnv env) throws InterruptedException {
            Procedure[] procedureArray;
            super.execute(env);
            if (this.isFailed()) {
                procedureArray = null;
            } else {
                Procedure[] procedureArray2 = new Procedure[1];
                procedureArray = procedureArray2;
                procedureArray2[0] = new Step1Procedure();
            }
            return procedureArray;
        }

        public static class Step2Procedure
        extends BaseTestStepProcedure {
        }

        public static class Step1Procedure
        extends BaseTestStepProcedure {
            @Override
            protected Procedure[] execute(TestProcEnv env) throws InterruptedException {
                Procedure[] procedureArray;
                super.execute(env);
                if (this.isFailed()) {
                    procedureArray = null;
                } else {
                    Procedure[] procedureArray2 = new Procedure[1];
                    procedureArray = procedureArray2;
                    procedureArray2[0] = new Step2Procedure();
                }
                return procedureArray;
            }
        }
    }

    public static class BaseTestStepProcedure
    extends SequentialProcedure<TestProcEnv> {
        private AtomicBoolean abort = new AtomicBoolean(false);
        private int step = 0;

        protected Procedure[] execute(TestProcEnv env) throws InterruptedException {
            env.waitOnLatch();
            LOG.debug("execute procedure " + (Object)((Object)this) + " step=" + this.step);
            ProcedureTestingUtility.toggleKillBeforeStoreUpdate(procExecutor);
            ++this.step;
            Threads.sleepWithoutInterrupt((long)procSleepInterval);
            if (this.isAborted()) {
                this.setFailure(new RemoteProcedureException(((Object)((Object)this)).getClass().getName(), (Throwable)new ProcedureAbortedException("got an abort at " + ((Object)((Object)this)).getClass().getName() + " step=" + this.step)));
                return null;
            }
            return null;
        }

        protected void rollback(TestProcEnv env) {
            LOG.debug("rollback procedure " + (Object)((Object)this) + " step=" + this.step);
            ProcedureTestingUtility.toggleKillBeforeStoreUpdate(procExecutor);
            ++this.step;
        }

        protected boolean abort(TestProcEnv env) {
            this.abort.set(true);
            return true;
        }

        private boolean isAborted() {
            boolean aborted = this.abort.get();
            BaseTestStepProcedure proc = this;
            while (proc.hasParent() && !aborted) {
                proc = (BaseTestStepProcedure)procExecutor.getProcedure(proc.getParentProcId());
                aborted = proc.isAborted();
            }
            return aborted;
        }
    }

    public static class TestSingleStepProcedure
    extends SequentialProcedure<TestProcEnv> {
        private int step = 0;

        protected Procedure[] execute(TestProcEnv env) throws InterruptedException {
            env.waitOnLatch();
            LOG.debug("execute procedure " + (Object)((Object)this) + " step=" + this.step);
            ++this.step;
            this.setResult(Bytes.toBytes((int)this.step));
            return null;
        }

        protected void rollback(TestProcEnv env) {
        }

        protected boolean abort(TestProcEnv env) {
            return true;
        }
    }
}

