/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import ch.cern.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.procedure2.AbstractProcedureScheduler;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureDeque;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ProcedureEvent<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ProcedureEvent.class);
    private final T object;
    private boolean ready = false;
    private ProcedureDeque suspendedProcedures = new ProcedureDeque();

    public ProcedureEvent(T object) {
        this.object = object;
    }

    public synchronized boolean isReady() {
        return this.ready;
    }

    public synchronized boolean suspendIfNotReady(Procedure proc) {
        if (!this.ready) {
            this.suspendedProcedures.addLast(proc);
        }
        return !this.ready;
    }

    public synchronized void suspend() {
        this.ready = false;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Suspend " + this.toString());
        }
    }

    public void wake(AbstractProcedureScheduler procedureScheduler) {
        procedureScheduler.wakeEvents(new ProcedureEvent[]{this});
    }

    public synchronized boolean wakeIfSuspended(AbstractProcedureScheduler procedureScheduler, Procedure<?> proc) {
        if (this.suspendedProcedures.stream().anyMatch(p -> p.getProcId() == proc.getProcId())) {
            this.wake(procedureScheduler);
            return true;
        }
        return false;
    }

    public static void wakeEvents(AbstractProcedureScheduler scheduler, ProcedureEvent ... events) {
        scheduler.wakeEvents(events);
    }

    synchronized void wakeInternal(AbstractProcedureScheduler procedureScheduler) {
        if (this.ready && !this.suspendedProcedures.isEmpty()) {
            LOG.warn("Found procedures suspended in a ready event! Size=" + this.suspendedProcedures.size());
        }
        this.ready = true;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Unsuspend " + this.toString());
        }
        procedureScheduler.addFront(this.suspendedProcedures.descendingIterator());
        this.suspendedProcedures.clear();
    }

    @VisibleForTesting
    public ProcedureDeque getSuspendedProcedures() {
        return this.suspendedProcedures;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " for " + this.object + ", ready=" + this.isReady() + ", " + this.suspendedProcedures;
    }
}

