/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import ch.cern.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.procedure2.AbstractProcedureScheduler;
import org.apache.hadoop.hbase.procedure2.LockedResource;
import org.apache.hadoop.hbase.procedure2.LockedResourceType;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureDeque;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class SimpleProcedureScheduler
extends AbstractProcedureScheduler {
    private final ProcedureDeque runnables = new ProcedureDeque();

    @Override
    protected void enqueue(Procedure procedure, boolean addFront) {
        if (addFront) {
            this.runnables.addFirst(procedure);
        } else {
            this.runnables.addLast(procedure);
        }
    }

    @Override
    protected Procedure dequeue() {
        return (Procedure)this.runnables.poll();
    }

    @Override
    @VisibleForTesting
    public void clear() {
        this.schedLock();
        try {
            this.runnables.clear();
        }
        finally {
            this.schedUnlock();
        }
    }

    @Override
    public void yield(Procedure proc) {
        this.addBack(proc);
    }

    @Override
    public boolean queueHasRunnables() {
        return this.runnables.size() > 0;
    }

    @Override
    public int queueSize() {
        return this.runnables.size();
    }

    @Override
    public void completionCleanup(Procedure proc) {
    }

    @Override
    public List<LockedResource> getLocks() {
        return Collections.emptyList();
    }

    @Override
    public LockedResource getLockResource(LockedResourceType resourceType, String resourceName) {
        return null;
    }
}

