/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeer;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerImpl;
import org.apache.hadoop.hbase.replication.ReplicationPeers;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.replication.ReplicationUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.zookeeper.KeeperException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TestReplicationStateBasic {
    private static final Logger LOG = LoggerFactory.getLogger(TestReplicationStateBasic.class);
    protected ReplicationQueueStorage rqs;
    protected ServerName server1 = ServerName.valueOf((String)"hostname1.example.org", (int)1234, (long)12345L);
    protected ServerName server2 = ServerName.valueOf((String)"hostname2.example.org", (int)1234, (long)12345L);
    protected ServerName server3 = ServerName.valueOf((String)"hostname3.example.org", (int)1234, (long)12345L);
    protected ReplicationPeers rp;
    protected static final String ID_ONE = "1";
    protected static final String ID_TWO = "2";
    protected static String KEY_ONE;
    protected static String KEY_TWO;
    protected String OUR_KEY;
    protected static int zkTimeoutCount;
    protected static final int ZK_MAX_COUNT = 300;
    protected static final int ZK_SLEEP_INTERVAL = 100;

    @Test
    public void testReplicationQueueStorage() throws ReplicationException {
        Assert.assertEquals((long)0L, (long)this.rqs.getListOfReplicators().size());
        Assert.assertTrue((boolean)this.rqs.getWALsInQueue(this.server1, "qId1").isEmpty());
        Assert.assertTrue((boolean)this.rqs.getAllQueues(this.server1).isEmpty());
        this.rqs.addWAL(this.server1, "qId1", "trash");
        this.rqs.removeWAL(this.server1, "qId1", "trash");
        this.rqs.addWAL(this.server1, "qId2", "filename1");
        this.rqs.addWAL(this.server1, "qId3", "filename2");
        this.rqs.addWAL(this.server1, "qId3", "filename3");
        this.rqs.addWAL(this.server2, "trash", "trash");
        this.rqs.removeQueue(this.server2, "trash");
        List reps = this.rqs.getListOfReplicators();
        Assert.assertEquals((long)2L, (long)reps.size());
        Assert.assertTrue((String)this.server1.getServerName(), (boolean)reps.contains(this.server1));
        Assert.assertTrue((String)this.server2.getServerName(), (boolean)reps.contains(this.server2));
        Assert.assertTrue((boolean)this.rqs.getWALsInQueue(ServerName.valueOf((String)"bogus", (int)12345, (long)12345L), "bogus").isEmpty());
        Assert.assertTrue((boolean)this.rqs.getWALsInQueue(this.server1, "bogus").isEmpty());
        Assert.assertEquals((long)0L, (long)this.rqs.getWALsInQueue(this.server1, "qId1").size());
        Assert.assertEquals((long)1L, (long)this.rqs.getWALsInQueue(this.server1, "qId2").size());
        Assert.assertEquals((Object)"filename1", this.rqs.getWALsInQueue(this.server1, "qId2").get(0));
        Assert.assertTrue((boolean)this.rqs.getAllQueues(ServerName.valueOf((String)"bogus", (int)12345, (long)-1L)).isEmpty());
        Assert.assertEquals((long)0L, (long)this.rqs.getAllQueues(this.server2).size());
        List list = this.rqs.getAllQueues(this.server1);
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("qId2"));
        Assert.assertTrue((boolean)list.contains("qId3"));
    }

    private void removeAllQueues(ServerName serverName) throws ReplicationException {
        for (String queue : this.rqs.getAllQueues(serverName)) {
            this.rqs.removeQueue(serverName, queue);
        }
    }

    @Test
    public void testReplicationQueues() throws ReplicationException {
        this.rp.init();
        this.rqs.removeQueue(this.server1, "bogus");
        this.rqs.removeWAL(this.server1, "bogus", "bogus");
        this.removeAllQueues(this.server1);
        Assert.assertEquals((long)0L, (long)this.rqs.getAllQueues(this.server1).size());
        Assert.assertEquals((long)0L, (long)this.rqs.getWALPosition(this.server1, "bogus", "bogus"));
        Assert.assertTrue((boolean)this.rqs.getWALsInQueue(this.server1, "bogus").isEmpty());
        Assert.assertTrue((boolean)this.rqs.getAllQueues(ServerName.valueOf((String)"bogus", (int)1234, (long)12345L)).isEmpty());
        this.populateQueues();
        Assert.assertEquals((long)3L, (long)this.rqs.getListOfReplicators().size());
        Assert.assertEquals((long)0L, (long)this.rqs.getWALsInQueue(this.server2, "qId1").size());
        Assert.assertEquals((long)5L, (long)this.rqs.getWALsInQueue(this.server3, "qId5").size());
        Assert.assertEquals((long)0L, (long)this.rqs.getWALPosition(this.server3, "qId1", "filename0"));
        this.rqs.setWALPosition(this.server3, "qId5", "filename4", 354L, Collections.emptyMap());
        Assert.assertEquals((long)354L, (long)this.rqs.getWALPosition(this.server3, "qId5", "filename4"));
        Assert.assertEquals((long)5L, (long)this.rqs.getWALsInQueue(this.server3, "qId5").size());
        Assert.assertEquals((long)0L, (long)this.rqs.getWALsInQueue(this.server2, "qId1").size());
        Assert.assertEquals((long)0L, (long)this.rqs.getAllQueues(this.server1).size());
        Assert.assertEquals((long)1L, (long)this.rqs.getAllQueues(this.server2).size());
        Assert.assertEquals((long)5L, (long)this.rqs.getAllQueues(this.server3).size());
        Assert.assertEquals((long)0L, (long)this.rqs.getAllQueues(this.server1).size());
        this.rqs.removeReplicatorIfQueueIsEmpty(this.server1);
        Assert.assertEquals((long)2L, (long)this.rqs.getListOfReplicators().size());
        List queues = this.rqs.getAllQueues(this.server3);
        Assert.assertEquals((long)5L, (long)queues.size());
        for (String queue : queues) {
            this.rqs.claimQueue(this.server3, queue, this.server2);
        }
        this.rqs.removeReplicatorIfQueueIsEmpty(this.server3);
        Assert.assertEquals((long)1L, (long)this.rqs.getListOfReplicators().size());
        Assert.assertEquals((long)6L, (long)this.rqs.getAllQueues(this.server2).size());
        this.removeAllQueues(this.server2);
        this.rqs.removeReplicatorIfQueueIsEmpty(this.server2);
        Assert.assertEquals((long)0L, (long)this.rqs.getListOfReplicators().size());
    }

    @Test
    public void testHfileRefsReplicationQueues() throws ReplicationException, KeeperException {
        this.rp.init();
        ArrayList<Pair> files1 = new ArrayList<Pair>(3);
        files1.add(new Pair(null, (Object)new Path("file_1")));
        files1.add(new Pair(null, (Object)new Path("file_2")));
        files1.add(new Pair(null, (Object)new Path("file_3")));
        Assert.assertTrue((boolean)this.rqs.getReplicableHFiles(ID_ONE).isEmpty());
        Assert.assertEquals((long)0L, (long)this.rqs.getAllPeersFromHFileRefsQueue().size());
        this.rp.getPeerStorage().addPeer(ID_ONE, ReplicationPeerConfig.newBuilder().setClusterKey(KEY_ONE).build(), true);
        this.rqs.addPeerToHFileRefs(ID_ONE);
        this.rqs.addHFileRefs(ID_ONE, files1);
        Assert.assertEquals((long)1L, (long)this.rqs.getAllPeersFromHFileRefsQueue().size());
        Assert.assertEquals((long)3L, (long)this.rqs.getReplicableHFiles(ID_ONE).size());
        ArrayList<String> hfiles2 = new ArrayList<String>(files1.size());
        for (Pair p : files1) {
            hfiles2.add(((Path)p.getSecond()).getName());
        }
        String removedString = (String)hfiles2.remove(0);
        this.rqs.removeHFileRefs(ID_ONE, hfiles2);
        Assert.assertEquals((long)1L, (long)this.rqs.getReplicableHFiles(ID_ONE).size());
        hfiles2 = new ArrayList(1);
        hfiles2.add(removedString);
        this.rqs.removeHFileRefs(ID_ONE, hfiles2);
        Assert.assertEquals((long)0L, (long)this.rqs.getReplicableHFiles(ID_ONE).size());
        this.rp.getPeerStorage().removePeer(ID_ONE);
    }

    @Test
    public void testRemovePeerForHFileRefs() throws ReplicationException, KeeperException {
        this.rp.init();
        this.rp.getPeerStorage().addPeer(ID_ONE, ReplicationPeerConfig.newBuilder().setClusterKey(KEY_ONE).build(), true);
        this.rqs.addPeerToHFileRefs(ID_ONE);
        this.rp.getPeerStorage().addPeer(ID_TWO, ReplicationPeerConfig.newBuilder().setClusterKey(KEY_TWO).build(), true);
        this.rqs.addPeerToHFileRefs(ID_TWO);
        ArrayList<Pair> files1 = new ArrayList<Pair>(3);
        files1.add(new Pair(null, (Object)new Path("file_1")));
        files1.add(new Pair(null, (Object)new Path("file_2")));
        files1.add(new Pair(null, (Object)new Path("file_3")));
        this.rqs.addHFileRefs(ID_ONE, files1);
        this.rqs.addHFileRefs(ID_TWO, files1);
        Assert.assertEquals((long)2L, (long)this.rqs.getAllPeersFromHFileRefsQueue().size());
        Assert.assertEquals((long)3L, (long)this.rqs.getReplicableHFiles(ID_ONE).size());
        Assert.assertEquals((long)3L, (long)this.rqs.getReplicableHFiles(ID_TWO).size());
        this.rp.getPeerStorage().removePeer(ID_ONE);
        this.rqs.removePeerFromHFileRefs(ID_ONE);
        Assert.assertEquals((long)1L, (long)this.rqs.getAllPeersFromHFileRefsQueue().size());
        Assert.assertTrue((boolean)this.rqs.getReplicableHFiles(ID_ONE).isEmpty());
        Assert.assertEquals((long)3L, (long)this.rqs.getReplicableHFiles(ID_TWO).size());
        this.rp.getPeerStorage().removePeer(ID_TWO);
        this.rqs.removePeerFromHFileRefs(ID_TWO);
        Assert.assertEquals((long)0L, (long)this.rqs.getAllPeersFromHFileRefsQueue().size());
        Assert.assertTrue((boolean)this.rqs.getReplicableHFiles(ID_TWO).isEmpty());
    }

    @Test
    public void testReplicationPeers() throws Exception {
        this.rp.init();
        try {
            this.rp.getPeerStorage().setPeerState("bogus", true);
            Assert.fail((String)"Should have thrown an IllegalArgumentException when passed a bogus peerId");
        }
        catch (ReplicationException replicationException) {
            // empty catch block
        }
        try {
            this.rp.getPeerStorage().setPeerState("bogus", false);
            Assert.fail((String)"Should have thrown an IllegalArgumentException when passed a bogus peerId");
        }
        catch (ReplicationException replicationException) {
            // empty catch block
        }
        try {
            Assert.assertFalse((boolean)this.rp.addPeer("bogus"));
            Assert.fail((String)"Should have thrown an ReplicationException when passed a bogus peerId");
        }
        catch (ReplicationException replicationException) {
            // empty catch block
        }
        this.assertNumberOfPeers(0);
        this.rp.getPeerStorage().addPeer(ID_ONE, new ReplicationPeerConfig().setClusterKey(KEY_ONE), true);
        this.assertNumberOfPeers(1);
        this.rp.getPeerStorage().addPeer(ID_TWO, new ReplicationPeerConfig().setClusterKey(KEY_TWO), true);
        this.assertNumberOfPeers(2);
        Assert.assertEquals((Object)KEY_ONE, (Object)ZKConfig.getZooKeeperClusterKey((Configuration)ReplicationUtils.getPeerClusterConfiguration((ReplicationPeerConfig)this.rp.getPeerStorage().getPeerConfig(ID_ONE), (Configuration)this.rp.getConf())));
        this.rp.getPeerStorage().removePeer(ID_ONE);
        this.rp.removePeer(ID_ONE);
        this.assertNumberOfPeers(1);
        this.rp.getPeerStorage().addPeer(ID_ONE, new ReplicationPeerConfig().setClusterKey(KEY_ONE), true);
        this.rp.addPeer(ID_ONE);
        this.assertNumberOfPeers(2);
        Assert.assertTrue((boolean)this.rp.getPeer(ID_ONE).isPeerEnabled());
        this.rp.getPeerStorage().setPeerState(ID_ONE, false);
        ReplicationPeerImpl peer = this.rp.getPeer(ID_ONE);
        this.rp.refreshPeerState(peer.getId());
        Assert.assertEquals((Object)ReplicationPeer.PeerState.DISABLED, (Object)peer.getPeerState());
        this.assertConnectedPeerStatus(false, ID_ONE);
        this.rp.getPeerStorage().setPeerState(ID_ONE, true);
        this.rp.refreshPeerState(peer.getId());
        Assert.assertEquals((Object)ReplicationPeer.PeerState.ENABLED, (Object)peer.getPeerState());
        this.assertConnectedPeerStatus(true, ID_ONE);
        this.rp.removePeer(ID_ONE);
        this.assertNumberOfPeers(2);
    }

    private String getFileName(String base, int i) {
        return String.format(base + "-%04d", i);
    }

    @Test
    public void testPersistLogPositionAndSeqIdAtomically() throws Exception {
        int i;
        ServerName serverName1 = ServerName.valueOf((String)"127.0.0.1", (int)8000, (long)10000L);
        Assert.assertTrue((boolean)this.rqs.getAllQueues(serverName1).isEmpty());
        String queue1 = ID_ONE;
        String region0 = "6b2c8f8555335cc9af74455b94516cbe";
        String region1 = "6ecd2e9e010499f8ddef97ee8f70834f";
        for (int i2 = 0; i2 < 10; ++i2) {
            this.rqs.addWAL(serverName1, queue1, this.getFileName("file1", i2));
        }
        List queueIds = this.rqs.getAllQueues(serverName1);
        Assert.assertEquals((long)1L, (long)queueIds.size());
        Assert.assertThat((Object)queueIds, (Matcher)CoreMatchers.hasItems((Object[])new String[]{ID_ONE}));
        List wals1 = this.rqs.getWALsInQueue(serverName1, queue1);
        Assert.assertEquals((long)10L, (long)wals1.size());
        for (i = 0; i < 10; ++i) {
            Assert.assertThat((Object)wals1, (Matcher)CoreMatchers.hasItems((Object[])new String[]{this.getFileName("file1", i)}));
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((long)0L, (long)this.rqs.getWALPosition(serverName1, queue1, this.getFileName("file1", i)));
        }
        Assert.assertEquals((long)-1L, (long)this.rqs.getLastSequenceId(region0, queue1));
        Assert.assertEquals((long)-1L, (long)this.rqs.getLastSequenceId(region1, queue1));
        for (i = 0; i < 10; ++i) {
            this.rqs.setWALPosition(serverName1, queue1, this.getFileName("file1", i), (long)((i + 1) * 100), (Map)ImmutableMap.of((Object)region0, (Object)((long)i * 100L), (Object)region1, (Object)((long)(i + 1) * 100L)));
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((long)((i + 1) * 100), (long)this.rqs.getWALPosition(serverName1, queue1, this.getFileName("file1", i)));
        }
        Assert.assertEquals((long)900L, (long)this.rqs.getLastSequenceId(region0, queue1));
        Assert.assertEquals((long)1000L, (long)this.rqs.getLastSequenceId(region1, queue1));
        this.rqs.setWALPosition(serverName1, queue1, this.getFileName("file1", 0), 1100L, (Map)ImmutableMap.of((Object)region0, (Object)899L, (Object)region1, (Object)1001L));
        Assert.assertEquals((long)900L, (long)this.rqs.getLastSequenceId(region0, queue1));
        Assert.assertEquals((long)1001L, (long)this.rqs.getLastSequenceId(region1, queue1));
    }

    protected void assertConnectedPeerStatus(boolean status, String peerId) throws Exception {
        if (status != this.rp.getPeerStorage().isPeerEnabled(peerId)) {
            Assert.fail((String)("ConnectedPeerStatus was " + !status + " but expected " + status + " in ZK"));
        }
        while (status != this.rp.getPeer(peerId).isPeerEnabled()) {
            if (zkTimeoutCount < 300) {
                LOG.debug("ConnectedPeerStatus was " + !status + " but expected " + status + ", sleeping and trying again.");
                Thread.sleep(100L);
                continue;
            }
            Assert.fail((String)("Timed out waiting for ConnectedPeerStatus to be " + status));
        }
        return;
    }

    protected void assertNumberOfPeers(int total) throws ReplicationException {
        Assert.assertEquals((long)total, (long)this.rp.getPeerStorage().listPeerIds().size());
    }

    protected void populateQueues() throws ReplicationException {
        this.rqs.addWAL(this.server1, "trash", "trash");
        this.rqs.removeQueue(this.server1, "trash");
        this.rqs.addWAL(this.server2, "qId1", "trash");
        this.rqs.removeWAL(this.server2, "qId1", "trash");
        for (int i = 1; i < 6; ++i) {
            for (int j = 0; j < i; ++j) {
                this.rqs.addWAL(this.server3, "qId" + i, "filename" + j);
            }
            this.rp.getPeerStorage().addPeer("qId" + i, ReplicationPeerConfig.newBuilder().setClusterKey("localhost:2818:/bogus" + i).build(), true);
        }
    }
}

